/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.spark.translation;

import java.io.Serializable;
import java.util.Collections;
import javax.annotation.Nullable;
import org.apache.beam.runners.spark.coders.CoderHelpers;
import org.apache.beam.runners.spark.translation.ReifyTimestampsAndWindowsFunction;
import org.apache.beam.runners.spark.translation.SparkGlobalCombineFn;
import org.apache.beam.runners.spark.translation.SparkKeyedCombineFn;
import org.apache.beam.runners.spark.translation.TranslationUtils;
import org.apache.beam.runners.spark.translation.ValueAndCoderLazySerializable;
import org.apache.beam.runners.spark.util.ByteArray;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.IterableCoder;
import org.apache.beam.sdk.coders.KvCoder;
import org.apache.beam.sdk.util.WindowedValue;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.WindowingStrategy;
import org.apache.beam.vendor.guava.v20_0.com.google.common.base.Optional;
import org.apache.beam.vendor.guava.v20_0.com.google.common.collect.Iterables;
import org.apache.spark.Partitioner;
import org.apache.spark.api.java.JavaPairRDD;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.function.Function;
import org.apache.spark.api.java.function.Function2;
import org.apache.spark.api.java.function.PairFunction;
import scala.Tuple2;

public class GroupCombineFunctions {
    public static <K, V> JavaRDD<WindowedValue<KV<K, Iterable<WindowedValue<V>>>>> groupByKeyOnly(JavaRDD<WindowedValue<KV<K, V>>> rdd, Coder<K> keyCoder, WindowedValue.WindowedValueCoder<V> wvCoder, @Nullable Partitioner partitioner) {
        JavaPairRDD pairRDD = rdd.map(new ReifyTimestampsAndWindowsFunction()).map(WindowedValue::getValue).mapToPair(TranslationUtils.toPairFunction()).mapToPair(CoderHelpers.toByteFunction(keyCoder, wvCoder));
        JavaPairRDD groupedRDD = partitioner != null ? pairRDD.groupByKey(partitioner) : pairRDD.groupByKey();
        return groupedRDD.mapPartitionsToPair(TranslationUtils.pairFunctionToPairFlatMapFunction(CoderHelpers.fromByteFunctionIterable(keyCoder, wvCoder)), true).mapPartitions(TranslationUtils.fromPairFlatMapFunction(), true).mapPartitions(TranslationUtils.functionToFlatMapFunction(WindowedValue::valueInGlobalWindow), true);
    }

    public static <InputT, AccumT> Optional<Iterable<WindowedValue<AccumT>>> combineGlobally(JavaRDD<WindowedValue<InputT>> rdd, SparkGlobalCombineFn<InputT, AccumT, ?> sparkCombineFn, Coder<AccumT> aCoder, WindowingStrategy<?, ?> windowingStrategy) {
        WindowedValue.FullWindowedValueCoder wvaCoder = WindowedValue.FullWindowedValueCoder.of(aCoder, (Coder)windowingStrategy.getWindowFn().windowCoder());
        IterableCoder iterAccumCoder = IterableCoder.of((Coder)wvaCoder);
        ValueAndCoderLazySerializable accumulatedResult = (ValueAndCoderLazySerializable)rdd.aggregate(ValueAndCoderLazySerializable.of(Collections.emptyList(), iterAccumCoder), (Function2 & Serializable)(ab, ib) -> {
            Iterable merged = sparkCombineFn.seqOp((Iterable)ab.getOrDecode(iterAccumCoder), (WindowedValue)ib);
            return ValueAndCoderLazySerializable.of(merged, iterAccumCoder);
        }, (Function2 & Serializable)(a1b, a2b) -> {
            Iterable merged = sparkCombineFn.combOp((Iterable)a1b.getOrDecode(iterAccumCoder), (Iterable)a2b.getOrDecode(iterAccumCoder));
            return ValueAndCoderLazySerializable.of(merged, iterAccumCoder);
        });
        Iterable result = (Iterable)accumulatedResult.getOrDecode(iterAccumCoder);
        return Iterables.isEmpty((Iterable)result) ? Optional.absent() : Optional.of((Object)result);
    }

    public static <K, InputT, AccumT> JavaPairRDD<K, Iterable<WindowedValue<KV<K, AccumT>>>> combinePerKey(JavaRDD<WindowedValue<KV<K, InputT>>> rdd, SparkKeyedCombineFn<K, InputT, AccumT, ?> sparkCombineFn, Coder<K> keyCoder, Coder<AccumT> aCoder, WindowingStrategy<?, ?> windowingStrategy) {
        WindowedValue.FullWindowedValueCoder wkvaCoder = WindowedValue.FullWindowedValueCoder.of((Coder)KvCoder.of(keyCoder, aCoder), (Coder)windowingStrategy.getWindowFn().windowCoder());
        IterableCoder iterAccumCoder = IterableCoder.of((Coder)wkvaCoder);
        JavaPairRDD inRddDuplicatedKeyPair = rdd.mapToPair(TranslationUtils.toPairByKeyInWindowedValue(keyCoder));
        JavaPairRDD accumulatedResult = inRddDuplicatedKeyPair.combineByKey((Function & Serializable)input -> ValueAndCoderLazySerializable.of(sparkCombineFn.createCombiner((WindowedValue)input), iterAccumCoder), (Function2 & Serializable)(acc, input) -> ValueAndCoderLazySerializable.of(sparkCombineFn.mergeValue((WindowedValue)input, (Iterable)acc.getOrDecode(iterAccumCoder)), iterAccumCoder), (Function2 & Serializable)(acc1, acc2) -> ValueAndCoderLazySerializable.of(sparkCombineFn.mergeCombiners((Iterable)acc1.getOrDecode(iterAccumCoder), (Iterable)acc2.getOrDecode(iterAccumCoder)), iterAccumCoder));
        return accumulatedResult.mapToPair((PairFunction & Serializable)i -> new Tuple2(CoderHelpers.fromByteArray(((ByteArray)i._1).getValue(), keyCoder), (Object)((Iterable)((ValueAndCoderLazySerializable)i._2).getOrDecode(iterAccumCoder))));
    }

    public static <K, V> JavaRDD<WindowedValue<KV<K, V>>> reshuffle(JavaRDD<WindowedValue<KV<K, V>>> rdd, Coder<K> keyCoder, WindowedValue.WindowedValueCoder<V> wvCoder) {
        return rdd.map(new ReifyTimestampsAndWindowsFunction()).map(WindowedValue::getValue).mapToPair(TranslationUtils.toPairFunction()).mapToPair(CoderHelpers.toByteFunction(keyCoder, wvCoder)).repartition(rdd.getNumPartitions()).mapToPair(CoderHelpers.fromByteFunction(keyCoder, wvCoder)).map(TranslationUtils.fromPairFunction()).map(TranslationUtils.toKVByWindowInValue());
    }
}

