/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.samza.runtime;

import org.apache.beam.runners.core.StateNamespace;

class TimerKey<K> {
    private final K key;
    private final byte[] keyBytes;
    private final StateNamespace stateNamespace;
    private final String timerId;

    TimerKey(K key, byte[] keyBytes, StateNamespace stateNamespace, String timerId) {
        this.key = key;
        this.keyBytes = keyBytes;
        this.stateNamespace = stateNamespace;
        this.timerId = timerId;
    }

    public K getKey() {
        return this.key;
    }

    public byte[] getKeyBytes() {
        return this.keyBytes;
    }

    public StateNamespace getStateNamespace() {
        return this.stateNamespace;
    }

    public String getTimerId() {
        return this.timerId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TimerKey timerKey = (TimerKey)o;
        if (this.key != null ? !this.key.equals(timerKey.key) : timerKey.key != null) {
            return false;
        }
        if (!this.stateNamespace.equals(timerKey.stateNamespace)) {
            return false;
        }
        return this.timerId.equals(timerKey.timerId);
    }

    public int hashCode() {
        int result = this.key != null ? this.key.hashCode() : 0;
        result = 31 * result + this.stateNamespace.hashCode();
        result = 31 * result + this.timerId.hashCode();
        return result;
    }

    public String toString() {
        return "TimerKey{key=" + this.key + ", stateNamespace=" + this.stateNamespace + ", timerId='" + this.timerId + '\'' + '}';
    }
}

