/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.samza;

import java.util.Map;
import org.apache.beam.runners.samza.SamzaExecutionContext;
import org.apache.beam.runners.samza.SamzaPipelineOptions;
import org.apache.beam.runners.samza.SamzaPipelineOptionsValidator;
import org.apache.beam.runners.samza.SamzaPipelineResult;
import org.apache.beam.runners.samza.metrics.SamzaMetricsContainer;
import org.apache.beam.runners.samza.translation.ConfigBuilder;
import org.apache.beam.runners.samza.translation.PViewToIdMapper;
import org.apache.beam.runners.samza.translation.SamzaPipelineTranslator;
import org.apache.beam.runners.samza.translation.SamzaTransformOverrides;
import org.apache.beam.runners.samza.util.PipelineDotRenderer;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.PipelineRunner;
import org.apache.beam.sdk.metrics.MetricsEnvironment;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.transforms.Create;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.values.PValue;
import org.apache.samza.application.StreamApplication;
import org.apache.samza.config.Config;
import org.apache.samza.metrics.MetricsRegistryMap;
import org.apache.samza.operators.ContextManager;
import org.apache.samza.operators.StreamGraph;
import org.apache.samza.runtime.ApplicationRunner;
import org.apache.samza.task.TaskContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SamzaRunner
extends PipelineRunner<SamzaPipelineResult> {
    private static final Logger LOG = LoggerFactory.getLogger(SamzaRunner.class);
    private final SamzaPipelineOptions options;

    public static SamzaRunner fromOptions(PipelineOptions opts) {
        SamzaPipelineOptions samzaOptions = SamzaPipelineOptionsValidator.validate(opts);
        return new SamzaRunner(samzaOptions);
    }

    public SamzaRunner(SamzaPipelineOptions options) {
        this.options = options;
    }

    public SamzaPipelineResult run(final Pipeline pipeline) {
        MetricsEnvironment.setMetricsSupported((boolean)true);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Pre-processed Beam pipeline:\n{}", (Object)PipelineDotRenderer.toDotString(pipeline));
        }
        pipeline.replaceAll(SamzaTransformOverrides.getDefaultOverrides());
        if (LOG.isDebugEnabled()) {
            LOG.debug("Post-processed Beam pipeline:\n{}", (Object)PipelineDotRenderer.toDotString(pipeline));
        }
        final PValue dummySource = (PValue)pipeline.apply("Dummy Input Source", (PTransform)Create.of((Object)"dummy", (Object[])new String[0]));
        final Map<PValue, String> idMap = PViewToIdMapper.buildIdMap(pipeline);
        ConfigBuilder configBuilder = new ConfigBuilder(this.options);
        SamzaPipelineTranslator.createConfig(pipeline, idMap, configBuilder);
        ApplicationRunner runner = ApplicationRunner.fromConfig((Config)configBuilder.build());
        final SamzaExecutionContext executionContext = new SamzaExecutionContext();
        StreamApplication app = new StreamApplication(){

            public void init(StreamGraph streamGraph, Config config) {
                streamGraph.withContextManager(new ContextManager(){

                    public void init(Config config, TaskContext context) {
                        if (executionContext.getMetricsContainer() == null) {
                            MetricsRegistryMap metricsRegistry = (MetricsRegistryMap)context.getSamzaContainerContext().metricsRegistry;
                            executionContext.setMetricsContainer(new SamzaMetricsContainer(metricsRegistry));
                        }
                        context.setUserContext((Object)executionContext);
                    }

                    public void close() {
                    }
                });
                SamzaPipelineTranslator.translate(pipeline, SamzaRunner.this.options, streamGraph, idMap, dummySource);
            }
        };
        SamzaPipelineResult result = new SamzaPipelineResult(app, runner, executionContext);
        runner.run(app);
        return result;
    }
}

