/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.samza.translation;

import java.util.Map;
import org.apache.beam.repackaged.beam_runners_samza.com.google.common.collect.Iterables;
import org.apache.beam.sdk.runners.AppliedPTransform;
import org.apache.beam.sdk.runners.TransformHierarchy;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.values.PValue;

public class ConfigContext {
    private final Map<PValue, String> idMap;
    private AppliedPTransform<?, ?, ?> currentTransform;

    public ConfigContext(Map<PValue, String> idMap) {
        this.idMap = idMap;
    }

    public void setCurrentTransform(AppliedPTransform<?, ?, ?> currentTransform) {
        this.currentTransform = currentTransform;
    }

    public void clearCurrentTransform() {
        this.currentTransform = null;
    }

    public <OutT extends PValue> OutT getOutput(PTransform<?, OutT> transform) {
        return (OutT)((PValue)Iterables.getOnlyElement(this.currentTransform.getOutputs().values()));
    }

    public String getOutputId(TransformHierarchy.Node node) {
        return this.getIdForPValue((PValue)Iterables.getOnlyElement(node.getOutputs().values()));
    }

    private String getIdForPValue(PValue pvalue) {
        String id = this.idMap.get(pvalue);
        if (id == null) {
            throw new IllegalArgumentException("No id mapping for value: " + pvalue);
        }
        return id;
    }
}

