/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.samza;

import java.io.File;
import java.nio.file.Paths;
import java.util.HashMap;
import org.apache.beam.runners.samza.SamzaPipelineOptions;
import org.apache.beam.runners.samza.SamzaPipelineResult;
import org.apache.beam.runners.samza.SamzaRunner;
import org.apache.beam.runners.samza.translation.ConfigBuilder;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.PipelineResult;
import org.apache.beam.sdk.PipelineRunner;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.options.PipelineOptionsValidator;
import org.apache.commons.io.FileUtils;
import org.apache.samza.config.JobConfig;

public class TestSamzaRunner
extends PipelineRunner<PipelineResult> {
    private final SamzaRunner delegate;

    public static TestSamzaRunner fromOptions(PipelineOptions options) {
        return new TestSamzaRunner(TestSamzaRunner.createSamzaPipelineOptions(options));
    }

    public static SamzaPipelineOptions createSamzaPipelineOptions(PipelineOptions options) {
        try {
            SamzaPipelineOptions samzaOptions = (SamzaPipelineOptions)PipelineOptionsValidator.validate(SamzaPipelineOptions.class, (PipelineOptions)options);
            HashMap<String, String> config = new HashMap<String, String>(ConfigBuilder.localRunConfig());
            File storeDir = Paths.get(System.getProperty("java.io.tmpdir"), "beam-samza-test").toFile();
            FileUtils.deleteDirectory((File)storeDir);
            if (!storeDir.mkdir()) {
                // empty if block
            }
            config.put(JobConfig.JOB_LOGGED_STORE_BASE_DIR(), storeDir.getAbsolutePath());
            config.put(JobConfig.JOB_NON_LOGGED_STORE_BASE_DIR(), storeDir.getAbsolutePath());
            if (samzaOptions.getConfigOverride() != null) {
                config.putAll(samzaOptions.getConfigOverride());
            }
            samzaOptions.setConfigOverride(config);
            return samzaOptions;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public TestSamzaRunner(SamzaPipelineOptions options) {
        this.delegate = SamzaRunner.fromOptions(options);
    }

    public PipelineResult run(Pipeline pipeline) {
        try {
            SamzaPipelineResult result = this.delegate.run(pipeline);
            result.waitUntilFinish();
            return result;
        }
        catch (Throwable t) {
            for (Throwable current = t; current != null; current = current.getCause()) {
                if (!(current instanceof AssertionError)) continue;
                throw (AssertionError)((Object)current);
            }
            throw t;
        }
    }
}

