/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.samza.translation;

import com.google.auto.service.AutoService;
import java.util.Map;
import org.apache.beam.repackaged.beam_runners_samza.com.google.common.base.Preconditions;
import org.apache.beam.repackaged.beam_runners_samza.com.google.common.collect.ImmutableMap;
import org.apache.beam.runners.core.construction.PTransformTranslation;
import org.apache.beam.runners.core.construction.TransformPayloadTranslatorRegistrar;
import org.apache.beam.runners.samza.SamzaPipelineOptions;
import org.apache.beam.runners.samza.translation.FlattenPCollectionsTranslator;
import org.apache.beam.runners.samza.translation.GroupByKeyTranslator;
import org.apache.beam.runners.samza.translation.ParDoBoundMultiTranslator;
import org.apache.beam.runners.samza.translation.ReadTranslator;
import org.apache.beam.runners.samza.translation.SamzaPublishView;
import org.apache.beam.runners.samza.translation.SamzaPublishViewTranslator;
import org.apache.beam.runners.samza.translation.TransformTranslator;
import org.apache.beam.runners.samza.translation.TranslationContext;
import org.apache.beam.runners.samza.translation.WindowAssignTranslator;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.runners.TransformHierarchy;
import org.apache.beam.sdk.transforms.Combine;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.values.PValue;
import org.apache.samza.operators.StreamGraph;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SamzaPipelineTranslator {
    private static final Logger LOG = LoggerFactory.getLogger(SamzaPipelineTranslator.class);
    private static final Map<String, TransformTranslator<?>> TRANSLATORS = ImmutableMap.builder().put(PTransformTranslation.READ_TRANSFORM_URN, new ReadTranslator()).put(PTransformTranslation.PAR_DO_TRANSFORM_URN, new ParDoBoundMultiTranslator()).put(PTransformTranslation.GROUP_BY_KEY_TRANSFORM_URN, new GroupByKeyTranslator()).put(PTransformTranslation.COMBINE_PER_KEY_TRANSFORM_URN, new GroupByKeyTranslator()).put(PTransformTranslation.ASSIGN_WINDOWS_TRANSFORM_URN, new WindowAssignTranslator()).put(PTransformTranslation.FLATTEN_TRANSFORM_URN, new FlattenPCollectionsTranslator()).put("beam:transform:samza:publish-view:v1", new SamzaPublishViewTranslator()).build();

    private SamzaPipelineTranslator() {
    }

    public static void translate(Pipeline pipeline, SamzaPipelineOptions options, StreamGraph graph, Map<PValue, String> idMap, PValue dummySource) {
        TranslationContext ctx = new TranslationContext(graph, idMap, options, dummySource);
        TranslationVisitor visitor = new TranslationVisitor(ctx);
        pipeline.traverseTopologically((Pipeline.PipelineVisitor)visitor);
    }

    @AutoService(value=TransformPayloadTranslatorRegistrar.class)
    public static class SamzaTransformsRegistrar
    implements TransformPayloadTranslatorRegistrar {
        public Map<? extends Class<? extends PTransform>, ? extends PTransformTranslation.TransformPayloadTranslator> getTransformPayloadTranslators() {
            return ImmutableMap.of(SamzaPublishView.class, new SamzaPublishView.SamzaPublishViewPayloadTranslator());
        }
    }

    private static class TranslationVisitor
    extends Pipeline.PipelineVisitor.Defaults {
        private final TranslationContext ctx;
        private int topologicalId = 0;

        private TranslationVisitor(TranslationContext ctx) {
            this.ctx = ctx;
        }

        public Pipeline.PipelineVisitor.CompositeBehavior enterCompositeTransform(TransformHierarchy.Node node) {
            PTransform transform = node.getTransform();
            String urn = TranslationVisitor.getUrnForTransform(transform);
            if (TranslationVisitor.canTranslate(urn, transform)) {
                this.applyTransform(transform, node, (TransformTranslator)TRANSLATORS.get(urn));
                return Pipeline.PipelineVisitor.CompositeBehavior.DO_NOT_ENTER_TRANSFORM;
            }
            return Pipeline.PipelineVisitor.CompositeBehavior.ENTER_TRANSFORM;
        }

        public void visitPrimitiveTransform(TransformHierarchy.Node node) {
            PTransform transform = node.getTransform();
            String urn = TranslationVisitor.getUrnForTransform(transform);
            Preconditions.checkArgument(TranslationVisitor.canTranslate(urn, transform), String.format("Unsupported transform class: %s. Node: %s", transform, node));
            this.applyTransform(transform, node, (TransformTranslator)TRANSLATORS.get(urn));
        }

        private <T extends PTransform<?, ?>> void applyTransform(T transform, TransformHierarchy.Node node, TransformTranslator<?> translator) {
            this.ctx.setCurrentTransform(node.toAppliedPTransform(this.getPipeline()));
            this.ctx.setCurrentTopologicalId(this.topologicalId++);
            TransformTranslator<?> typedTranslator = translator;
            typedTranslator.translate(transform, node, this.ctx);
            this.ctx.clearCurrentTransform();
        }

        private static boolean canTranslate(String urn, PTransform<?, ?> transform) {
            if (!TRANSLATORS.containsKey(urn)) {
                return false;
            }
            if (urn.equals(PTransformTranslation.COMBINE_PER_KEY_TRANSFORM_URN)) {
                return ((Combine.PerKey)transform).getSideInputs().isEmpty();
            }
            return true;
        }

        private static String getUrnForTransform(PTransform<?, ?> transform) {
            return transform == null ? null : PTransformTranslation.urnForTransformOrNull(transform);
        }
    }
}

