/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.samza.translation;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.beam.runners.samza.util.StateUtils;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.transforms.reflect.DoFnSignature;
import org.apache.beam.sdk.transforms.reflect.DoFnSignatures;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class StateIdParser
extends Pipeline.PipelineVisitor.Defaults {
    private final @UnknownKeyFor @NonNull @Initialized Set<@UnknownKeyFor @NonNull @Initialized String> nonUniqueStateIds = new HashSet<String>();
    private final @UnknownKeyFor @NonNull @Initialized Set<@UnknownKeyFor @NonNull @Initialized String> usedStateIds = new HashSet<String>();

    public static @UnknownKeyFor @NonNull @Initialized Set<@UnknownKeyFor @NonNull @Initialized String> scan(@UnknownKeyFor @NonNull @Initialized Pipeline pipeline) {
        StateIdParser parser = new StateIdParser();
        pipeline.traverseTopologically((Pipeline.PipelineVisitor)parser);
        return parser.getNonUniqueStateIds();
    }

    private StateIdParser() {
    }

    public void visitPrimitiveTransform(// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized TransformHierarchy. @UnknownKeyFor @NonNull @Initialized Node node) {
        DoFn doFn;
        if (node.getTransform() instanceof ParDo.MultiOutput && StateUtils.isStateful(doFn = ((ParDo.MultiOutput)node.getTransform()).getFn())) {
            DoFnSignature signature = DoFnSignatures.getSignature(doFn.getClass());
            for (String stateId : signature.stateDeclarations().keySet()) {
                if (this.usedStateIds.add(stateId)) continue;
                this.nonUniqueStateIds.add(stateId);
            }
        }
    }

    public @UnknownKeyFor @NonNull @Initialized Set<@UnknownKeyFor @NonNull @Initialized String> getNonUniqueStateIds() {
        return Collections.unmodifiableSet(this.nonUniqueStateIds);
    }
}

