/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.samza.runtime;

import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.transforms.windowing.WindowFn;
import org.apache.beam.sdk.util.WindowedValue;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.Iterables;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.joda.time.Instant;

class SamzaAssignContext<@UnknownKeyFor InT, @UnknownKeyFor W extends @UnknownKeyFor @NonNull @Initialized BoundedWindow>
extends WindowFn.AssignContext {
    private final @UnknownKeyFor @NonNull @Initialized WindowedValue<InT> value;

    public SamzaAssignContext(@UnknownKeyFor @NonNull @Initialized WindowFn<InT, W> fn, @UnknownKeyFor @NonNull @Initialized WindowedValue<InT> value) {
        super(fn);
        this.value = value;
        if (value.getWindows().size() != 1) {
            throw new IllegalArgumentException(String.format("Only single windowed value allowed for assignment. Windows: %s", value.getWindows()));
        }
    }

    public InT element() {
        return (InT)this.value.getValue();
    }

    public @UnknownKeyFor @NonNull @Initialized Instant timestamp() {
        return this.value.getTimestamp();
    }

    public @UnknownKeyFor @NonNull @Initialized BoundedWindow window() {
        return (BoundedWindow)Iterables.getOnlyElement((Iterable)this.value.getWindows());
    }
}

