/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.samza.runtime;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.List;
import org.apache.beam.runners.core.StateNamespace;
import org.apache.beam.runners.core.StateNamespaces;
import org.apache.beam.runners.core.TimerInternals;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.CoderException;
import org.apache.beam.sdk.coders.InstantCoder;
import org.apache.beam.sdk.coders.StringUtf8Coder;
import org.apache.beam.sdk.coders.StructuredCoder;
import org.apache.beam.sdk.state.TimeDomain;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.EnsuresNonNullIf;
import org.checkerframework.checker.nullness.qual.KeyForBottom;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.dataflow.qual.Pure;
import org.checkerframework.dataflow.qual.SideEffectFree;
import org.joda.time.Instant;

public class KeyedTimerData<@UnknownKeyFor K>
implements Comparable<KeyedTimerData<K>> {
    private final @UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] keyBytes;
    private final K key;
    private final // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized TimerInternals.TimerData timerData;

    public KeyedTimerData(@UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] keyBytes, K key, // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized TimerInternals.TimerData timerData) {
        this.keyBytes = keyBytes;
        this.key = key;
        this.timerData = timerData;
    }

    public K getKey() {
        return this.key;
    }

    public @UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] getKeyBytes() {
        return this.keyBytes;
    }

    public // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized TimerInternals.TimerData getTimerData() {
        return this.timerData;
    }

    @Override
    @Pure
    public @UnknownKeyFor @NonNull @Initialized int compareTo(@UnknownKeyFor @NonNull @Initialized KeyedTimerData<K> other) {
        int timerCompare = this.getTimerData().compareTo(other.getTimerData());
        if (timerCompare != 0) {
            return timerCompare;
        }
        if (this.keyBytes == null) {
            return other.keyBytes == null ? 0 : -1;
        }
        if (other.keyBytes == null) {
            return 1;
        }
        if (this.keyBytes.length < other.keyBytes.length) {
            return -1;
        }
        if (this.keyBytes.length > other.keyBytes.length) {
            return 1;
        }
        for (int i = 0; i < this.keyBytes.length; ++i) {
            char b1 = (char)this.keyBytes[i];
            char b2 = (char)other.keyBytes[i];
            if (b1 == b2) continue;
            return b1 - b2;
        }
        return 0;
    }

    @SideEffectFree
    public @UnknownKeyFor @NonNull @Initialized String toString() {
        return "KeyedTimerData{key=" + this.key + ", keyBytes=" + Arrays.toString(this.keyBytes) + ", timerData=" + this.timerData + '}';
    }

    @EnsuresNonNullIf(expression={"#1"}, result=true)
    @Pure
    public @UnknownKeyFor @NonNull @Initialized boolean equals(@Nullable @UnknownKeyFor @Initialized Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        KeyedTimerData that = (KeyedTimerData)o;
        return Arrays.equals(this.keyBytes, that.keyBytes) && this.timerData.equals(that.timerData);
    }

    @Pure
    public @UnknownKeyFor @NonNull @Initialized int hashCode() {
        int result = Arrays.hashCode(this.keyBytes);
        result = 31 * result + this.timerData.hashCode();
        return result;
    }

    public static class KeyedTimerDataCoder<@UnknownKeyFor K>
    extends StructuredCoder<KeyedTimerData<K>> {
        private static final @UnknownKeyFor @NonNull @Initialized StringUtf8Coder STRING_CODER = StringUtf8Coder.of();
        private static final @UnknownKeyFor @NonNull @Initialized InstantCoder INSTANT_CODER = InstantCoder.of();
        private final @UnknownKeyFor @NonNull @Initialized Coder<K> keyCoder;
        private final @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized BoundedWindow> windowCoder;

        KeyedTimerDataCoder(@UnknownKeyFor @NonNull @Initialized Coder<K> keyCoder, @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized BoundedWindow> windowCoder) {
            this.keyCoder = keyCoder;
            this.windowCoder = windowCoder;
        }

        public void encode(@UnknownKeyFor @NonNull @Initialized KeyedTimerData<K> value, @UnknownKeyFor @NonNull @Initialized OutputStream outStream) throws @UnknownKeyFor @NonNull @Initialized CoderException, @UnknownKeyFor @NonNull @Initialized IOException {
            TimerInternals.TimerData timer = value.getTimerData();
            INSTANT_CODER.encode(timer.getTimestamp(), outStream);
            STRING_CODER.encode(timer.getTimerId(), outStream);
            STRING_CODER.encode(timer.getNamespace().stringKey(), outStream);
            STRING_CODER.encode(timer.getDomain().name(), outStream);
            if (this.keyCoder != null) {
                this.keyCoder.encode(((KeyedTimerData)value).key, outStream);
            }
            STRING_CODER.encode(timer.getTimerFamilyId(), outStream);
            INSTANT_CODER.encode(timer.getOutputTimestamp(), outStream);
        }

        public @UnknownKeyFor @NonNull @Initialized KeyedTimerData<K> decode(@UnknownKeyFor @NonNull @Initialized InputStream inStream) throws @UnknownKeyFor @NonNull @Initialized CoderException, @UnknownKeyFor @NonNull @Initialized IOException {
            Instant timestamp = INSTANT_CODER.decode(inStream);
            String timerId = STRING_CODER.decode(inStream);
            StateNamespace namespace = StateNamespaces.fromString((String)STRING_CODER.decode(inStream), this.windowCoder);
            TimeDomain domain = TimeDomain.valueOf((String)STRING_CODER.decode(inStream));
            byte[] keyBytes = null;
            Object key = null;
            if (this.keyCoder != null) {
                key = this.keyCoder.decode(inStream);
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                try {
                    this.keyCoder.encode(key, (OutputStream)baos);
                }
                catch (IOException e) {
                    throw new RuntimeException("Could not encode key: " + key, e);
                }
                keyBytes = baos.toByteArray();
            }
            String timerFamilyId = inStream.available() > 0 ? STRING_CODER.decode(inStream) : "";
            Instant outputTimestamp = inStream.available() > 0 ? INSTANT_CODER.decode(inStream) : timestamp;
            TimerInternals.TimerData timer = TimerInternals.TimerData.of((String)timerId, (String)timerFamilyId, (StateNamespace)namespace, (Instant)timestamp, (Instant)outputTimestamp, (TimeDomain)domain);
            return new KeyedTimerData<Object>(keyBytes, key, timer);
        }

        public /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized List<@KeyForBottom @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> getCoderArguments() {
            return Arrays.asList(this.keyCoder, this.windowCoder);
        }

        public void verifyDeterministic() throws // Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized Coder.NonDeterministicException {
        }
    }
}

