/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.samza.metrics;

import java.io.Closeable;
import org.apache.beam.runners.samza.metrics.SamzaMetricsContainer;
import org.apache.beam.sdk.metrics.MetricsContainer;
import org.apache.beam.sdk.metrics.MetricsEnvironment;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class FnWithMetricsWrapper {
    private final @UnknownKeyFor @NonNull @Initialized SamzaMetricsContainer metricsContainer;
    private final @UnknownKeyFor @NonNull @Initialized String stepName;

    public FnWithMetricsWrapper(@UnknownKeyFor @NonNull @Initialized SamzaMetricsContainer metricsContainer, @UnknownKeyFor @NonNull @Initialized String stepName) {
        this.metricsContainer = metricsContainer;
        this.stepName = stepName;
    }

    public <T> T wrap(@UnknownKeyFor @NonNull @Initialized SupplierWithException<T> fn, @UnknownKeyFor @NonNull @Initialized boolean shouldUpdateMetrics) throws @UnknownKeyFor @NonNull @Initialized Exception {
        try (Closeable closeable = MetricsEnvironment.scopedMetricsContainer((MetricsContainer)this.metricsContainer.getContainer(this.stepName));){
            T result = fn.get();
            if (shouldUpdateMetrics) {
                this.metricsContainer.updateMetrics(this.stepName);
            }
            T t = result;
            return t;
        }
    }

    public static interface SupplierWithException<@UnknownKeyFor T> {
        public T get() throws @UnknownKeyFor @NonNull @Initialized Exception;
    }
}

