/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.samza;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import org.apache.beam.runners.samza.SamzaPipelineOptions;
import org.apache.beam.runners.samza.SamzaPipelineResult;
import org.apache.beam.runners.samza.SamzaRunner;
import org.apache.beam.runners.samza.translation.ConfigBuilder;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.PipelineResult;
import org.apache.beam.sdk.PipelineRunner;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.options.PipelineOptionsValidator;
import org.apache.commons.io.FileUtils;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class TestSamzaRunner
extends PipelineRunner<PipelineResult> {
    private final @UnknownKeyFor @NonNull @Initialized SamzaRunner delegate;
    private final @UnknownKeyFor @NonNull @Initialized File storeDir = TestSamzaRunner.createStoreDir();

    public static @UnknownKeyFor @NonNull @Initialized TestSamzaRunner fromOptions(@UnknownKeyFor @NonNull @Initialized PipelineOptions options) {
        return new TestSamzaRunner(options);
    }

    public static @UnknownKeyFor @NonNull @Initialized SamzaPipelineOptions createSamzaPipelineOptions(@UnknownKeyFor @NonNull @Initialized PipelineOptions options, @UnknownKeyFor @NonNull @Initialized File storeDir) {
        try {
            SamzaPipelineOptions samzaOptions = (SamzaPipelineOptions)PipelineOptionsValidator.validate(SamzaPipelineOptions.class, (PipelineOptions)options);
            HashMap<String, String> config = new HashMap<String, String>(ConfigBuilder.localRunConfig());
            config.put("job.logged.store.base.dir", storeDir.getAbsolutePath());
            config.put("job.non-logged.store.base.dir", storeDir.getAbsolutePath());
            config.put("job.jmx.enabled", "false");
            if (samzaOptions.getConfigOverride() != null) {
                config.putAll(samzaOptions.getConfigOverride());
            }
            samzaOptions.setConfigOverride(config);
            return samzaOptions;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static @UnknownKeyFor @NonNull @Initialized File createStoreDir() {
        try {
            return Files.createTempDirectory("beam-samza-test", new FileAttribute[0]).toFile();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public TestSamzaRunner(@UnknownKeyFor @NonNull @Initialized PipelineOptions options) {
        this.delegate = SamzaRunner.fromOptions(TestSamzaRunner.createSamzaPipelineOptions(options, this.storeDir));
    }

    @SuppressFBWarnings(value={"DE_MIGHT_IGNORE"})
    public @UnknownKeyFor @NonNull @Initialized PipelineResult run(@UnknownKeyFor @NonNull @Initialized Pipeline pipeline) {
        try {
            SamzaPipelineResult result = this.delegate.run(pipeline);
            result.waitUntilFinish();
            SamzaPipelineResult samzaPipelineResult = result;
            return samzaPipelineResult;
        }
        catch (Throwable t) {
            for (Throwable current = t; current != null; current = current.getCause()) {
                if (!(current instanceof AssertionError)) continue;
                throw (AssertionError)((Object)current);
            }
            throw t;
        }
        finally {
            try {
                FileUtils.deleteDirectory((File)this.storeDir);
            }
            catch (Exception exception) {}
        }
    }
}

