/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.samza;

import java.io.OutputStream;
import org.apache.beam.runners.jobsubmission.JobServerDriver;
import org.apache.beam.runners.samza.SamzaJobInvoker;
import org.apache.beam.sdk.fn.server.ServerFactory;
import org.apache.beam.sdk.io.FileSystems;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.options.PipelineOptionsFactory;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.kohsuke.args4j.CmdLineException;
import org.kohsuke.args4j.CmdLineParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SamzaJobServerDriver
extends JobServerDriver {
    private static final @UnknownKeyFor @NonNull @Initialized Logger LOG = LoggerFactory.getLogger(SamzaJobServerDriver.class);

    public static void main(@UnknownKeyFor @NonNull @Initialized String @UnknownKeyFor @NonNull @Initialized [] args) {
        PipelineOptions options = PipelineOptionsFactory.create();
        FileSystems.setDefaultPipelineOptions((PipelineOptions)options);
        SamzaJobServerDriver.fromParams(args).run();
    }

    private static @UnknownKeyFor @NonNull @Initialized SamzaJobServerDriver fromParams(@UnknownKeyFor @NonNull @Initialized String @UnknownKeyFor @NonNull @Initialized [] args) {
        return SamzaJobServerDriver.fromConfig(SamzaJobServerDriver.parseArgs(args));
    }

    private static void printUsage(@UnknownKeyFor @NonNull @Initialized CmdLineParser parser) {
        System.err.printf("Usage: java %s arguments...%n", SamzaJobServerDriver.class.getSimpleName());
        parser.printUsage((OutputStream)System.err);
        System.err.println();
    }

    private static @UnknownKeyFor @NonNull @Initialized SamzaJobServerDriver fromConfig(@UnknownKeyFor @NonNull @Initialized SamzaServerConfiguration configuration) {
        return SamzaJobServerDriver.create(configuration, SamzaJobServerDriver.createJobServerFactory((JobServerDriver.ServerConfiguration)configuration), SamzaJobServerDriver.createArtifactServerFactory((JobServerDriver.ServerConfiguration)configuration));
    }

    public static @UnknownKeyFor @NonNull @Initialized SamzaServerConfiguration parseArgs(@UnknownKeyFor @NonNull @Initialized String @UnknownKeyFor @NonNull @Initialized [] args) {
        SamzaServerConfiguration configuration = new SamzaServerConfiguration();
        CmdLineParser parser = new CmdLineParser((Object)configuration);
        try {
            parser.parseArgument(args);
        }
        catch (CmdLineException e) {
            LOG.error("Unable to parse command line arguments.", (Throwable)e);
            SamzaJobServerDriver.printUsage(parser);
            throw new IllegalArgumentException("Unable to parse command line arguments.", e);
        }
        return configuration;
    }

    private static @UnknownKeyFor @NonNull @Initialized SamzaJobServerDriver create(@UnknownKeyFor @NonNull @Initialized SamzaServerConfiguration configuration, @UnknownKeyFor @NonNull @Initialized ServerFactory jobServerFactory, @UnknownKeyFor @NonNull @Initialized ServerFactory artifactServerFactory) {
        return new SamzaJobServerDriver(configuration, jobServerFactory, artifactServerFactory);
    }

    private SamzaJobServerDriver(@UnknownKeyFor @NonNull @Initialized SamzaServerConfiguration configuration, @UnknownKeyFor @NonNull @Initialized ServerFactory jobServerFactory, @UnknownKeyFor @NonNull @Initialized ServerFactory artifactServerFactory) {
        this(configuration, jobServerFactory, artifactServerFactory, () -> SamzaJobInvoker.create(configuration));
    }

    protected SamzaJobServerDriver(// Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized JobServerDriver.ServerConfiguration configuration, @UnknownKeyFor @NonNull @Initialized ServerFactory jobServerFactory, @UnknownKeyFor @NonNull @Initialized ServerFactory artifactServerFactory, // Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized JobServerDriver.JobInvokerFactory jobInvokerFactory) {
        super(configuration, jobServerFactory, artifactServerFactory, jobInvokerFactory);
    }

    public static class SamzaServerConfiguration
    extends JobServerDriver.ServerConfiguration {
    }
}

