/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.samza.translation;

import com.google.auto.service.AutoService;
import java.util.HashMap;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;
import org.apache.beam.model.pipeline.v1.RunnerApi;
import org.apache.beam.runners.core.construction.graph.PipelineNode;
import org.apache.beam.runners.core.construction.graph.QueryablePipeline;
import org.apache.beam.runners.samza.SamzaPipelineOptions;
import org.apache.beam.runners.samza.translation.ConfigBuilder;
import org.apache.beam.runners.samza.translation.FlattenPCollectionsTranslator;
import org.apache.beam.runners.samza.translation.GroupByKeyTranslator;
import org.apache.beam.runners.samza.translation.ImpulseTranslator;
import org.apache.beam.runners.samza.translation.ParDoBoundMultiTranslator;
import org.apache.beam.runners.samza.translation.PortableTranslationContext;
import org.apache.beam.runners.samza.translation.SamzaPortableTranslatorRegistrar;
import org.apache.beam.runners.samza.translation.SamzaTestStreamTranslator;
import org.apache.beam.runners.samza.translation.TransformConfigGenerator;
import org.apache.beam.runners.samza.translation.TransformTranslator;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SamzaPortablePipelineTranslator {
    private static final Logger LOG = LoggerFactory.getLogger(SamzaPortablePipelineTranslator.class);
    private static final Map<String, TransformTranslator<?>> TRANSLATORS = SamzaPortablePipelineTranslator.loadTranslators();

    private static Map<String, TransformTranslator<?>> loadTranslators() {
        HashMap translators = new HashMap();
        for (SamzaPortableTranslatorRegistrar registrar : ServiceLoader.load(SamzaPortableTranslatorRegistrar.class)) {
            translators.putAll(registrar.getTransformTranslators());
        }
        LOG.info("{} translators loaded.", (Object)translators.size());
        return ImmutableMap.copyOf(translators);
    }

    private SamzaPortablePipelineTranslator() {
    }

    public static void translate(RunnerApi.Pipeline pipeline, PortableTranslationContext ctx) {
        QueryablePipeline queryablePipeline = QueryablePipeline.forPipeline((RunnerApi.Pipeline)pipeline);
        for (PipelineNode.PTransformNode transform : queryablePipeline.getTopologicallyOrderedTransforms()) {
            ctx.setCurrentTransform(transform);
            LOG.info("Translating transform urn: {}", (Object)transform.getTransform().getSpec().getUrn());
            TRANSLATORS.get(transform.getTransform().getSpec().getUrn()).translatePortable(transform, queryablePipeline, ctx);
            ctx.clearCurrentTransform();
        }
    }

    public static void createConfig(RunnerApi.Pipeline pipeline, ConfigBuilder configBuilder, SamzaPipelineOptions options) {
        QueryablePipeline queryablePipeline = QueryablePipeline.forPipeline((RunnerApi.Pipeline)pipeline);
        for (PipelineNode.PTransformNode transform : queryablePipeline.getTopologicallyOrderedTransforms()) {
            TransformTranslator<?> translator = TRANSLATORS.get(transform.getTransform().getSpec().getUrn());
            if (!(translator instanceof TransformConfigGenerator)) continue;
            TransformConfigGenerator configGenerator = (TransformConfigGenerator)((Object)translator);
            configBuilder.putAll(configGenerator.createPortableConfig(transform, options));
        }
    }

    public static Set<String> knownUrns() {
        return TRANSLATORS.keySet();
    }

    @AutoService(value={SamzaPortableTranslatorRegistrar.class})
    public static class SamzaTranslators
    implements SamzaPortableTranslatorRegistrar {
        @Override
        public Map<String, TransformTranslator<?>> getTransformTranslators() {
            return ImmutableMap.builder().put((Object)"beam:transform:group_by_key:v1", new GroupByKeyTranslator()).put((Object)"beam:transform:flatten:v1", new FlattenPCollectionsTranslator()).put((Object)"beam:transform:impulse:v1", (Object)new ImpulseTranslator()).put((Object)"beam:transform:teststream:v1", new SamzaTestStreamTranslator()).put((Object)"beam:runner:executable_stage:v1", new ParDoBoundMultiTranslator()).build();
        }
    }
}

