/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.samza.translation;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.beam.runners.core.construction.graph.PipelineNode;
import org.apache.beam.runners.fnexecution.provisioning.JobInfo;
import org.apache.beam.runners.samza.SamzaPipelineOptions;
import org.apache.beam.runners.samza.runtime.OpMessage;
import org.apache.beam.runners.samza.translation.TranslationContext;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Iterables;
import org.apache.samza.application.descriptors.StreamApplicationDescriptor;
import org.apache.samza.operators.KV;
import org.apache.samza.operators.MessageStream;
import org.apache.samza.system.descriptors.InputDescriptor;

public class PortableTranslationContext
extends TranslationContext {
    private final Map<String, MessageStream<?>> messageStreams = new HashMap();
    private final JobInfo jobInfo;
    private PipelineNode.PTransformNode currentTransform;

    public PortableTranslationContext(StreamApplicationDescriptor appDescriptor, SamzaPipelineOptions options, JobInfo jobInfo) {
        super(appDescriptor, Collections.emptyMap(), options);
        this.jobInfo = jobInfo;
    }

    public <T> List<MessageStream<OpMessage<T>>> getAllInputMessageStreams(PipelineNode.PTransformNode transform) {
        Collection inputStreamIds = transform.getTransform().getInputsMap().values();
        return inputStreamIds.stream().map(this::getMessageStreamById).collect(Collectors.toList());
    }

    public <T> MessageStream<OpMessage<T>> getOneInputMessageStream(PipelineNode.PTransformNode transform) {
        String id = (String)Iterables.getOnlyElement(transform.getTransform().getInputsMap().values());
        return this.getMessageStreamById(id);
    }

    public <T> MessageStream<OpMessage<T>> getMessageStreamById(String id) {
        return this.messageStreams.get(id);
    }

    public String getInputId(PipelineNode.PTransformNode transform) {
        return (String)Iterables.getOnlyElement(transform.getTransform().getInputsMap().values());
    }

    public String getOutputId(PipelineNode.PTransformNode transform) {
        return (String)Iterables.getOnlyElement(transform.getTransform().getOutputsMap().values());
    }

    public JobInfo getJobInfo() {
        return this.jobInfo;
    }

    public <T> void registerMessageStream(String id, MessageStream<OpMessage<T>> stream) {
        if (this.messageStreams.containsKey(id)) {
            throw new IllegalArgumentException("Stream already registered for id: " + id);
        }
        this.messageStreams.put(id, stream);
    }

    public <T> void registerInputMessageStream(String id, InputDescriptor<KV<?, OpMessage<T>>, ?> inputDescriptor) {
        this.registerInputMessageStreams(id, Collections.singletonList(inputDescriptor));
    }

    public <T> void registerInputMessageStreams(String id, List<? extends InputDescriptor<KV<?, OpMessage<T>>, ?>> inputDescriptors) {
        this.registerInputMessageStreams(id, inputDescriptors, this::registerMessageStream);
    }

    public void setCurrentTransform(PipelineNode.PTransformNode currentTransform) {
        this.currentTransform = currentTransform;
    }

    @Override
    public void clearCurrentTransform() {
        this.currentTransform = null;
    }

    @Override
    public String getTransformFullName() {
        return this.currentTransform.getTransform().getUniqueName();
    }
}

