/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.samza.runtime;

import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.Executors;
import org.apache.beam.runners.core.DoFnRunner;
import org.apache.beam.runners.core.DoFnRunners;
import org.apache.beam.runners.core.KeyedWorkItem;
import org.apache.beam.runners.core.KeyedWorkItems;
import org.apache.beam.runners.core.NullSideInputReader;
import org.apache.beam.runners.core.OutputAndTimeBoundedSplittableProcessElementInvoker;
import org.apache.beam.runners.core.OutputWindowedValue;
import org.apache.beam.runners.core.SideInputReader;
import org.apache.beam.runners.core.SplittableParDoViaKeyedWorkItems;
import org.apache.beam.runners.core.SplittableProcessElementInvoker;
import org.apache.beam.runners.core.StateInternals;
import org.apache.beam.runners.core.StateInternalsFactory;
import org.apache.beam.runners.core.StepContext;
import org.apache.beam.runners.core.TimerInternals;
import org.apache.beam.runners.core.construction.SerializablePipelineOptions;
import org.apache.beam.runners.core.construction.SplittableParDo;
import org.apache.beam.runners.core.serialization.Base64Serializer;
import org.apache.beam.runners.samza.SamzaPipelineOptions;
import org.apache.beam.runners.samza.runtime.KeyedInternals;
import org.apache.beam.runners.samza.runtime.KeyedTimerData;
import org.apache.beam.runners.samza.runtime.Op;
import org.apache.beam.runners.samza.runtime.OpEmitter;
import org.apache.beam.runners.samza.runtime.OutputManagerFactory;
import org.apache.beam.runners.samza.runtime.SamzaStoreStateInternals;
import org.apache.beam.runners.samza.runtime.SamzaTimerInternalsFactory;
import org.apache.beam.sdk.coders.ByteArrayCoder;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.DoFnSchemaInformation;
import org.apache.beam.sdk.transforms.join.RawUnionValue;
import org.apache.beam.sdk.transforms.reflect.DoFnInvokers;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.transforms.windowing.PaneInfo;
import org.apache.beam.sdk.util.WindowedValue;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.TupleTag;
import org.apache.beam.sdk.values.WindowingStrategy;
import org.apache.samza.config.Config;
import org.apache.samza.context.Context;
import org.apache.samza.operators.Scheduler;
import org.joda.time.Duration;
import org.joda.time.Instant;
import org.joda.time.ReadableInstant;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SplittableParDoProcessKeyedElementsOp<InputT, OutputT, RestrictionT, PositionT, WatermarkEstimatorStateT>
implements Op<KeyedWorkItem<byte[], KV<InputT, RestrictionT>>, RawUnionValue, byte[]> {
    private static final Logger LOG = LoggerFactory.getLogger(SplittableParDoProcessKeyedElementsOp.class);
    private static final String TIMER_STATE_ID = "timer";
    private final TupleTag<OutputT> mainOutputTag;
    private final WindowingStrategy<?, BoundedWindow> windowingStrategy;
    private final OutputManagerFactory<RawUnionValue> outputManagerFactory;
    private final SplittableParDoViaKeyedWorkItems.ProcessElements<InputT, OutputT, RestrictionT, PositionT, WatermarkEstimatorStateT> processElements;
    private final String transformId;
    private final PCollection.IsBounded isBounded;
    private transient StateInternalsFactory<byte[]> stateInternalsFactory;
    private transient SamzaTimerInternalsFactory<byte[]> timerInternalsFactory;
    private transient DoFnRunner<KeyedWorkItem<byte[], KV<InputT, RestrictionT>>, OutputT> fnRunner;
    private transient SamzaPipelineOptions pipelineOptions;

    public SplittableParDoProcessKeyedElementsOp(TupleTag<OutputT> mainOutputTag, SplittableParDo.ProcessKeyedElements<InputT, OutputT, RestrictionT, WatermarkEstimatorStateT> processKeyedElements, WindowingStrategy<?, BoundedWindow> windowingStrategy, OutputManagerFactory<RawUnionValue> outputManagerFactory, String transformFullName, String transformId, PCollection.IsBounded isBounded) {
        this.mainOutputTag = mainOutputTag;
        this.windowingStrategy = windowingStrategy;
        this.outputManagerFactory = outputManagerFactory;
        this.transformId = transformId;
        this.isBounded = isBounded;
        this.processElements = new SplittableParDoViaKeyedWorkItems.ProcessElements(processKeyedElements);
    }

    @Override
    public void open(Config config, Context context, Scheduler<KeyedTimerData<byte[]>> timerRegistry, OpEmitter<RawUnionValue> emitter) {
        this.pipelineOptions = (SamzaPipelineOptions)((SerializablePipelineOptions)Base64Serializer.deserializeUnchecked((String)((String)config.get((Object)"beamPipelineOptions")), SerializablePipelineOptions.class)).get().as(SamzaPipelineOptions.class);
        SamzaStoreStateInternals.Factory nonKeyedStateInternalsFactory = SamzaStoreStateInternals.createNonKeyedStateInternalsFactory(this.transformId, context.getTaskContext(), this.pipelineOptions);
        final DoFnRunners.OutputManager outputManager = this.outputManagerFactory.create(emitter);
        this.stateInternalsFactory = new SamzaStoreStateInternals.Factory<byte[]>(this.transformId, Collections.singletonMap("beamStore", SamzaStoreStateInternals.getBeamStore(context.getTaskContext())), (Coder<byte[]>)ByteArrayCoder.of(), this.pipelineOptions.getStoreBatchGetSize());
        this.timerInternalsFactory = SamzaTimerInternalsFactory.createTimerInternalFactory(ByteArrayCoder.of(), timerRegistry, TIMER_STATE_ID, nonKeyedStateInternalsFactory, this.windowingStrategy, this.isBounded, this.pipelineOptions);
        final KeyedInternals<byte[]> keyedInternals = new KeyedInternals<byte[]>(this.stateInternalsFactory, this.timerInternalsFactory);
        SplittableParDoViaKeyedWorkItems.ProcessFn processFn = this.processElements.newProcessFn(this.processElements.getFn());
        DoFnInvokers.tryInvokeSetupFor((DoFn)processFn, (PipelineOptions)this.pipelineOptions);
        processFn.setStateInternalsFactory(this.stateInternalsFactory);
        processFn.setTimerInternalsFactory(this.timerInternalsFactory);
        processFn.setSideInputReader((SideInputReader)NullSideInputReader.empty());
        processFn.setProcessElementInvoker((SplittableProcessElementInvoker)new OutputAndTimeBoundedSplittableProcessElementInvoker(this.processElements.getFn(), (PipelineOptions)this.pipelineOptions, new OutputWindowedValue<OutputT>(){

            public void outputWindowedValue(OutputT output, Instant timestamp, Collection<? extends BoundedWindow> windows, PaneInfo pane) {
                this.outputWindowedValue(SplittableParDoProcessKeyedElementsOp.this.mainOutputTag, output, timestamp, windows, pane);
            }

            public <AdditionalOutputT> void outputWindowedValue(TupleTag<AdditionalOutputT> tag, AdditionalOutputT output, Instant timestamp, Collection<? extends BoundedWindow> windows, PaneInfo pane) {
                outputManager.output(tag, WindowedValue.of(output, (Instant)timestamp, windows, (PaneInfo)pane));
            }
        }, (SideInputReader)NullSideInputReader.empty(), Executors.newSingleThreadScheduledExecutor(Executors.defaultThreadFactory()), 10000, Duration.standardSeconds((long)10L), () -> {
            throw new UnsupportedOperationException("BundleFinalizer unsupported in Samza");
        }));
        StepContext stepContext = new StepContext(){

            public StateInternals stateInternals() {
                return keyedInternals.stateInternals();
            }

            public TimerInternals timerInternals() {
                return keyedInternals.timerInternals();
            }
        };
        this.fnRunner = DoFnRunners.simpleRunner((PipelineOptions)this.pipelineOptions, (DoFn)processFn, (SideInputReader)NullSideInputReader.of(Collections.emptyList()), (DoFnRunners.OutputManager)outputManager, this.mainOutputTag, Collections.emptyList(), (StepContext)stepContext, null, Collections.emptyMap(), this.windowingStrategy, (DoFnSchemaInformation)DoFnSchemaInformation.create(), Collections.emptyMap());
    }

    @Override
    public void processElement(WindowedValue<KeyedWorkItem<byte[], KV<InputT, RestrictionT>>> inputElement, OpEmitter<RawUnionValue> emitter) {
        this.fnRunner.startBundle();
        this.fnRunner.processElement(inputElement);
        this.fnRunner.finishBundle();
    }

    @Override
    public void processWatermark(Instant watermark, OpEmitter<RawUnionValue> emitter) {
        this.timerInternalsFactory.setInputWatermark(watermark);
        Collection<KeyedTimerData<byte[]>> readyTimers = this.timerInternalsFactory.removeReadyTimers();
        if (!readyTimers.isEmpty()) {
            this.fnRunner.startBundle();
            for (KeyedTimerData<byte[]> keyedTimerData : readyTimers) {
                this.fireTimer(keyedTimerData.getKey(), keyedTimerData.getTimerData());
            }
            this.fnRunner.finishBundle();
        }
        if (this.timerInternalsFactory.getOutputWatermark() == null || this.timerInternalsFactory.getOutputWatermark().isBefore((ReadableInstant)watermark)) {
            this.timerInternalsFactory.setOutputWatermark(watermark);
            emitter.emitWatermark(this.timerInternalsFactory.getOutputWatermark());
        }
    }

    @Override
    public void processTimer(KeyedTimerData<byte[]> keyedTimerData, OpEmitter<RawUnionValue> emitter) {
        this.fnRunner.startBundle();
        this.fireTimer(keyedTimerData.getKey(), keyedTimerData.getTimerData());
        this.fnRunner.finishBundle();
        this.timerInternalsFactory.removeProcessingTimer(keyedTimerData);
    }

    private void fireTimer(byte[] key, TimerInternals.TimerData timer) {
        LOG.debug("Firing timer {} for key {}", (Object)timer, (Object)key);
        this.fnRunner.processElement(WindowedValue.valueInGlobalWindow((Object)KeyedWorkItems.timersWorkItem((Object)key, Collections.singletonList(timer))));
    }
}

