/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.samza;

import java.time.Duration;
import org.apache.beam.runners.samza.SamzaPipelineOptions;

public class SamzaRunnerOverrideConfigs {
    public static final String BEAM_RUNNER_CONFIG_PREFIX = "beam.override.";
    public static final String IS_PORTABLE_MODE = "beam.override.portable";
    public static final String FN_CONTROL_PORT = "beam.override.control.port";
    public static final String CONTROL_CLIENT_MAX_WAIT_TIME_MS = "controL.wait.time.ms";
    public static final long DEFAULT_CONTROL_CLIENT_MAX_WAIT_TIME_MS = Duration.ofMinutes(2L).toMillis();
    public static final String FS_TOKEN_PATH = "beam.override.fs.token.path";
    public static final String DEFAULT_FS_TOKEN_PATH = null;

    private static boolean containsKey(SamzaPipelineOptions options, String configKey) {
        if (options == null || options.getConfigOverride() == null) {
            return false;
        }
        return options.getConfigOverride().containsKey(configKey);
    }

    public static boolean isPortableMode(SamzaPipelineOptions options) {
        if (SamzaRunnerOverrideConfigs.containsKey(options, IS_PORTABLE_MODE)) {
            return options.getConfigOverride().get(IS_PORTABLE_MODE).equals(String.valueOf(true));
        }
        return false;
    }

    public static int getFnControlPort(SamzaPipelineOptions options) {
        if (SamzaRunnerOverrideConfigs.containsKey(options, FN_CONTROL_PORT)) {
            return Integer.parseInt(options.getConfigOverride().get(FN_CONTROL_PORT));
        }
        return -1;
    }

    public static long getControlClientWaitTimeoutMs(SamzaPipelineOptions options) {
        if (SamzaRunnerOverrideConfigs.containsKey(options, CONTROL_CLIENT_MAX_WAIT_TIME_MS)) {
            return Long.parseLong(options.getConfigOverride().get(CONTROL_CLIENT_MAX_WAIT_TIME_MS));
        }
        return DEFAULT_CONTROL_CLIENT_MAX_WAIT_TIME_MS;
    }

    public static String getFsTokenPath(SamzaPipelineOptions options) {
        if (SamzaRunnerOverrideConfigs.containsKey(options, FS_TOKEN_PATH)) {
            return options.getConfigOverride().get(FS_TOKEN_PATH);
        }
        return DEFAULT_FS_TOKEN_PATH;
    }
}

