/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.samza;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.beam.runners.samza.SamzaExecutionEnvironment;
import org.apache.beam.sdk.options.Default;
import org.apache.beam.sdk.options.DefaultValueFactory;
import org.apache.beam.sdk.options.Description;
import org.apache.beam.sdk.options.Hidden;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.util.concurrent.ThreadFactoryBuilder;
import org.apache.samza.config.ConfigLoaderFactory;
import org.apache.samza.config.loaders.PropertiesConfigLoaderFactory;
import org.apache.samza.metrics.MetricsReporter;

public interface SamzaPipelineOptions
extends PipelineOptions {
    @Description(value="The config file for Samza. It is *optional*. By default Samza supports properties config.Without a config file, Samza uses a default config for local execution.")
    public String getConfigFilePath();

    public void setConfigFilePath(String var1);

    @Description(value="The factory to read config file from config file path.")
    @Default.Class(value=PropertiesConfigLoaderFactory.class)
    public Class<? extends ConfigLoaderFactory> getConfigLoaderFactory();

    public void setConfigLoaderFactory(Class<? extends ConfigLoaderFactory> var1);

    @Description(value="The config override to set programmatically. It will be applied on top of config file if it exits, otherwise used directly as the config.")
    public Map<String, String> getConfigOverride();

    public void setConfigOverride(Map<String, String> var1);

    @Description(value="The instance name of the job")
    @Default.String(value="1")
    public String getJobInstance();

    public void setJobInstance(String var1);

    @Description(value="Samza application execution environment.See {@link org.apache.beam.runners.samza.SamzaExecutionEnvironment} for detailed environment descriptions.")
    @Default.Enum(value="LOCAL")
    public SamzaExecutionEnvironment getSamzaExecutionEnvironment();

    public void setSamzaExecutionEnvironment(SamzaExecutionEnvironment var1);

    @Description(value="The interval to check for watermarks in milliseconds.")
    @Default.Long(value=1000L)
    public long getWatermarkInterval();

    public void setWatermarkInterval(long var1);

    @Description(value="The maximum number of messages to buffer for a given system.")
    @Default.Integer(value=5000)
    public int getSystemBufferSize();

    public void setSystemBufferSize(int var1);

    @Description(value="The maximum number of event-time timers to buffer in memory for a PTransform")
    @Default.Integer(value=50000)
    public int getEventTimerBufferSize();

    public void setEventTimerBufferSize(int var1);

    @Description(value="The maximum number of ready timers to process at once per watermark.")
    @Default.Integer(value=0x7FFFFFFF)
    public int getMaxReadyTimersToProcessOnce();

    public void setMaxReadyTimersToProcessOnce(int var1);

    @Description(value="The maximum parallelism allowed for any data source.")
    @Default.Integer(value=1)
    public int getMaxSourceParallelism();

    public void setMaxSourceParallelism(int var1);

    @Description(value="The batch get size limit for the state store.")
    @Default.Integer(value=10000)
    public int getStoreBatchGetSize();

    public void setStoreBatchGetSize(int var1);

    @Description(value="Enable/disable Beam metrics in Samza Runner")
    @Default.Boolean(value=true)
    public Boolean getEnableMetrics();

    public void setEnableMetrics(Boolean var1);

    @Description(value="The config for state to be durable")
    @Default.Boolean(value=false)
    public Boolean getStateDurable();

    public void setStateDurable(Boolean var1);

    @JsonIgnore
    @Description(value="The metrics reporters that will be used to emit metrics.")
    public List<MetricsReporter> getMetricsReporters();

    public void setMetricsReporters(List<MetricsReporter> var1);

    @Description(value="The maximum number of elements in a bundle.")
    @Default.Long(value=1L)
    public long getMaxBundleSize();

    public void setMaxBundleSize(long var1);

    @Description(value="The maximum time to wait before finalising a bundle (in milliseconds).")
    @Default.Long(value=1000L)
    public long getMaxBundleTimeMs();

    public void setMaxBundleTimeMs(long var1);

    @Description(value="The number of threads to run DoFn.processElements in parallel within a bundle. Used only in non-portable mode.")
    @Default.Integer(value=1)
    public int getNumThreadsForProcessElement();

    public void setNumThreadsForProcessElement(int var1);

    @JsonIgnore
    @Description(value="The ExecutorService instance to run DoFN.processElements in parallel within a bundle. Used only in non-portable mode.")
    @Default.InstanceFactory(value=ProcessElementExecutorServiceFactory.class)
    @Hidden
    public ExecutorService getExecutorServiceForProcessElement();

    public void setExecutorServiceForProcessElement(ExecutorService var1);

    public static class ProcessElementExecutorServiceFactory
    implements DefaultValueFactory<ExecutorService> {
        public ExecutorService create(PipelineOptions options) {
            return Executors.newFixedThreadPool(((SamzaPipelineOptions)options.as(SamzaPipelineOptions.class)).getNumThreadsForProcessElement(), new ThreadFactoryBuilder().setNameFormat("Process Element Thread-%d").build());
        }
    }
}

