/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.samza;

import java.io.OutputStream;
import org.apache.beam.runners.jobsubmission.JobServerDriver;
import org.apache.beam.runners.samza.SamzaJobInvoker;
import org.apache.beam.sdk.fn.server.ServerFactory;
import org.apache.beam.sdk.io.FileSystems;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.options.PipelineOptionsFactory;
import org.kohsuke.args4j.CmdLineException;
import org.kohsuke.args4j.CmdLineParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SamzaJobServerDriver
extends JobServerDriver {
    private static final Logger LOG = LoggerFactory.getLogger(SamzaJobServerDriver.class);

    public static void main(String[] args) {
        PipelineOptions options = PipelineOptionsFactory.create();
        FileSystems.setDefaultPipelineOptions((PipelineOptions)options);
        SamzaJobServerDriver.fromParams(args).run();
    }

    private static SamzaJobServerDriver fromParams(String[] args) {
        return SamzaJobServerDriver.fromConfig(SamzaJobServerDriver.parseArgs(args));
    }

    private static void printUsage(CmdLineParser parser) {
        System.err.printf("Usage: java %s arguments...%n", SamzaJobServerDriver.class.getSimpleName());
        parser.printUsage((OutputStream)System.err);
        System.err.println();
    }

    private static SamzaJobServerDriver fromConfig(SamzaServerConfiguration configuration) {
        return SamzaJobServerDriver.create(configuration, SamzaJobServerDriver.createJobServerFactory((JobServerDriver.ServerConfiguration)configuration), SamzaJobServerDriver.createArtifactServerFactory((JobServerDriver.ServerConfiguration)configuration));
    }

    public static SamzaServerConfiguration parseArgs(String[] args) {
        SamzaServerConfiguration configuration = new SamzaServerConfiguration();
        CmdLineParser parser = new CmdLineParser((Object)configuration);
        try {
            parser.parseArgument(args);
        }
        catch (CmdLineException e) {
            LOG.error("Unable to parse command line arguments.", (Throwable)e);
            SamzaJobServerDriver.printUsage(parser);
            throw new IllegalArgumentException("Unable to parse command line arguments.", e);
        }
        return configuration;
    }

    private static SamzaJobServerDriver create(SamzaServerConfiguration configuration, ServerFactory jobServerFactory, ServerFactory artifactServerFactory) {
        return new SamzaJobServerDriver(configuration, jobServerFactory, artifactServerFactory);
    }

    private SamzaJobServerDriver(SamzaServerConfiguration configuration, ServerFactory jobServerFactory, ServerFactory artifactServerFactory) {
        this(configuration, jobServerFactory, artifactServerFactory, () -> SamzaJobInvoker.create(configuration));
    }

    protected SamzaJobServerDriver(JobServerDriver.ServerConfiguration configuration, ServerFactory jobServerFactory, ServerFactory artifactServerFactory, JobServerDriver.JobInvokerFactory jobInvokerFactory) {
        super(configuration, jobServerFactory, artifactServerFactory, jobInvokerFactory);
    }

    public static class SamzaServerConfiguration
    extends JobServerDriver.ServerConfiguration {
    }
}

