/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.samza.util;

import java.io.IOException;
import org.apache.beam.model.pipeline.v1.RunnerApi;
import org.apache.beam.runners.core.construction.RehydratedComponents;
import org.apache.beam.runners.core.construction.WindowingStrategyTranslation;
import org.apache.beam.runners.core.construction.graph.PipelineNode;
import org.apache.beam.runners.fnexecution.wire.WireCoders;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.util.WindowedValue;
import org.apache.beam.sdk.values.WindowingStrategy;

public class WindowUtils {
    public static WindowingStrategy<?, BoundedWindow> getWindowStrategy(String collectionId, RunnerApi.Components components) {
        WindowingStrategy windowingStrategy;
        RehydratedComponents rehydratedComponents = RehydratedComponents.forComponents((RunnerApi.Components)components);
        RunnerApi.WindowingStrategy windowingStrategyProto = components.getWindowingStrategiesOrThrow(components.getPcollectionsOrThrow(collectionId).getWindowingStrategyId());
        try {
            windowingStrategy = WindowingStrategyTranslation.fromProto((RunnerApi.WindowingStrategy)windowingStrategyProto, (RehydratedComponents)rehydratedComponents);
        }
        catch (Exception e) {
            throw new IllegalStateException(String.format("Unable to hydrate GroupByKey windowing strategy %s.", windowingStrategyProto), e);
        }
        WindowingStrategy ret = windowingStrategy;
        return ret;
    }

    public static <T> WindowedValue.WindowedValueCoder<T> instantiateWindowedCoder(String collectionId, RunnerApi.Components components) {
        PipelineNode.PCollectionNode collectionNode = PipelineNode.pCollection((String)collectionId, (RunnerApi.PCollection)components.getPcollectionsOrThrow(collectionId));
        try {
            return (WindowedValue.WindowedValueCoder)WireCoders.instantiateRunnerWireCoder((PipelineNode.PCollectionNode)collectionNode, (RunnerApi.Components)components);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

