/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.samza;

import java.util.UUID;
import javax.annotation.Nullable;
import org.apache.beam.model.pipeline.v1.RunnerApi;
import org.apache.beam.runners.core.construction.PipelineOptionsTranslation;
import org.apache.beam.runners.fnexecution.provisioning.JobInfo;
import org.apache.beam.runners.jobsubmission.JobInvocation;
import org.apache.beam.runners.jobsubmission.JobInvoker;
import org.apache.beam.runners.jobsubmission.PortablePipelineJarCreator;
import org.apache.beam.runners.jobsubmission.PortablePipelineRunner;
import org.apache.beam.runners.samza.SamzaJobServerDriver;
import org.apache.beam.runners.samza.SamzaPipelineRunner;
import org.apache.beam.runners.samza.SamzaPortablePipelineOptions;
import org.apache.beam.vendor.grpc.v1p43p2.com.google.protobuf.Struct;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Strings;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.util.concurrent.ListeningExecutorService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SamzaJobInvoker
extends JobInvoker {
    private static final Logger LOG = LoggerFactory.getLogger(SamzaJobInvoker.class);

    public static SamzaJobInvoker create(SamzaJobServerDriver.SamzaServerConfiguration configuration) {
        return new SamzaJobInvoker();
    }

    private SamzaJobInvoker() {
        super("samza-runner-job-invoker-%d");
    }

    protected JobInvocation invokeWithExecutor(RunnerApi.Pipeline pipeline, Struct options, @Nullable String retrievalToken, ListeningExecutorService executorService) {
        LOG.trace("Parsing pipeline options");
        SamzaPortablePipelineOptions samzaOptions = (SamzaPortablePipelineOptions)PipelineOptionsTranslation.fromProto((Struct)options).as(SamzaPortablePipelineOptions.class);
        SamzaPipelineRunner pipelineRunner = Strings.isNullOrEmpty((String)samzaOptions.getOutputExecutablePath()) ? new SamzaPipelineRunner(samzaOptions) : new PortablePipelineJarCreator(SamzaPipelineRunner.class);
        String invocationId = String.format("%s_%s", samzaOptions.getJobName(), UUID.randomUUID().toString());
        JobInfo jobInfo = JobInfo.create((String)invocationId, (String)samzaOptions.getJobName(), (String)retrievalToken, (Struct)options);
        return new JobInvocation(jobInfo, executorService, pipeline, (PortablePipelineRunner)pipelineRunner);
    }
}

