/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.samza.util;

import com.google.errorprone.annotations.FormatMethod;
import com.google.errorprone.annotations.FormatString;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.ServiceLoader;
import javax.annotation.Nullable;
import org.apache.beam.model.pipeline.v1.RunnerApi;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.annotations.Experimental;
import org.apache.beam.sdk.runners.TransformHierarchy;
import org.apache.beam.sdk.values.PValue;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Iterators;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Experimental
public class PipelineJsonRenderer
implements Pipeline.PipelineVisitor {
    private static final Logger LOG = LoggerFactory.getLogger(PipelineJsonRenderer.class);
    private static final String OUTERMOST_NODE = "OuterMostNode";
    @Nullable
    private static final SamzaIOInfo SAMZA_IO_INFO = PipelineJsonRenderer.loadSamzaIOInfo();
    private final StringBuilder jsonBuilder = new StringBuilder();
    private final StringBuilder graphLinks = new StringBuilder();
    private final Map<PValue, String> valueToProducerNodeName = new HashMap<PValue, String>();
    private int indent;

    public static String toJsonString(Pipeline pipeline) {
        PipelineJsonRenderer visitor = new PipelineJsonRenderer();
        pipeline.traverseTopologically((Pipeline.PipelineVisitor)visitor);
        return visitor.jsonBuilder.toString();
    }

    public static String toJsonString(RunnerApi.Pipeline pipeline) {
        throw new UnsupportedOperationException("JSON DAG for portable pipeline is not supported yet.");
    }

    private PipelineJsonRenderer() {
    }

    @Nullable
    private static SamzaIOInfo loadSamzaIOInfo() {
        Iterator<SamzaIORegistrar> beamIORegistrarIterator = ServiceLoader.load(SamzaIORegistrar.class).iterator();
        return beamIORegistrarIterator.hasNext() ? ((SamzaIORegistrar)Iterators.getOnlyElement(beamIORegistrarIterator)).getSamzaIO() : null;
    }

    public void enterPipeline(Pipeline p) {
        this.writeLine("{ \n \"RootNode\": [", new Object[0]);
        this.graphLinks.append(",\"graphLinks\": [");
        this.enterBlock();
    }

    public Pipeline.PipelineVisitor.CompositeBehavior enterCompositeTransform(TransformHierarchy.Node node) {
        Optional<String> ioInfo;
        String fullName = node.getFullName();
        this.writeLine("{ \"fullName\":\"%s\",", this.assignNodeName(fullName));
        if (node.getEnclosingNode() != null) {
            String enclosingNodeName = node.getEnclosingNode().getFullName();
            this.writeLine("  \"enclosingNode\":\"%s\",", this.assignNodeName(enclosingNodeName));
        }
        if ((ioInfo = this.getIOInfo(node)).isPresent() && !ioInfo.get().isEmpty()) {
            this.writeLine(" \"ioInfo\":\"%s\",", PipelineJsonRenderer.escapeString(ioInfo.get()));
        }
        this.writeLine("  \"ChildNodes\":[", new Object[0]);
        this.enterBlock();
        return Pipeline.PipelineVisitor.CompositeBehavior.ENTER_TRANSFORM;
    }

    public void leaveCompositeTransform(TransformHierarchy.Node node) {
        this.exitBlock();
        this.writeLine("]},", new Object[0]);
    }

    public void visitPrimitiveTransform(TransformHierarchy.Node node) {
        String fullName = node.getFullName();
        this.writeLine("{ \"fullName\":\"%s\",", PipelineJsonRenderer.escapeString(fullName));
        String enclosingNodeName = node.getEnclosingNode().getFullName();
        this.writeLine("  \"enclosingNode\":\"%s\"},", this.assignNodeName(enclosingNodeName));
        node.getOutputs().values().forEach(x -> this.valueToProducerNodeName.put((PValue)x, fullName));
        node.getInputs().forEach((key, value) -> {
            String producerName = this.valueToProducerNodeName.get(value);
            this.graphLinks.append(String.format("{\"from\":\"%s\",\"to\":\"%s\"},", producerName, fullName));
        });
    }

    public void visitValue(PValue value, TransformHierarchy.Node producer) {
    }

    public void leavePipeline(Pipeline pipeline) {
        this.exitBlock();
        this.writeLine("]", new Object[0]);
        int lastIndex = this.graphLinks.length() - 1;
        if (this.graphLinks.charAt(lastIndex) == ',') {
            this.graphLinks.deleteCharAt(lastIndex);
        }
        this.graphLinks.append("]");
        this.jsonBuilder.append((CharSequence)this.graphLinks);
        this.jsonBuilder.append("}");
    }

    private void enterBlock() {
        this.indent += 4;
    }

    private void exitBlock() {
        this.indent -= 4;
    }

    @FormatMethod
    private void writeLine(@FormatString String format, Object ... args) {
        int secondLastCharIndex = this.jsonBuilder.length() - 2;
        if (this.jsonBuilder.length() > 1 && this.jsonBuilder.charAt(secondLastCharIndex) == ',' && (format.startsWith("}") || format.startsWith("]"))) {
            this.jsonBuilder.deleteCharAt(secondLastCharIndex);
        }
        if (this.indent != 0) {
            this.jsonBuilder.append(String.format("%-" + this.indent + "s", ""));
        }
        this.jsonBuilder.append(String.format(format, args));
        this.jsonBuilder.append("\n");
    }

    private static String escapeString(String x) {
        return x.replace("\"", "\\\"");
    }

    private String assignNodeName(String nodeName) {
        return PipelineJsonRenderer.escapeString(nodeName.isEmpty() ? OUTERMOST_NODE : nodeName);
    }

    private Optional<String> getIOInfo(TransformHierarchy.Node node) {
        if (SAMZA_IO_INFO == null) {
            return Optional.empty();
        }
        return SAMZA_IO_INFO.getIOInfo(node);
    }

    public static interface SamzaIORegistrar {
        public SamzaIOInfo getSamzaIO();
    }

    @Experimental
    public static interface SamzaIOInfo {
        public Optional<String> getIOInfo(TransformHierarchy.Node var1);
    }
}

