/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.samza.util;

import java.io.IOException;
import org.apache.beam.model.pipeline.v1.RunnerApi;
import org.apache.beam.runners.core.construction.graph.PipelineNode;
import org.apache.beam.runners.fnexecution.wire.WireCoders;
import org.apache.beam.sdk.util.WindowedValue;
import org.apache.beam.sdk.values.PCollection;

public final class SamzaPipelineTranslatorUtils {
    private SamzaPipelineTranslatorUtils() {
    }

    public static WindowedValue.WindowedValueCoder instantiateCoder(String collectionId, RunnerApi.Components components) {
        PipelineNode.PCollectionNode collectionNode = PipelineNode.pCollection((String)collectionId, (RunnerApi.PCollection)components.getPcollectionsOrThrow(collectionId));
        try {
            return (WindowedValue.WindowedValueCoder)WireCoders.instantiateRunnerWireCoder((PipelineNode.PCollectionNode)collectionNode, (RunnerApi.Components)components);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static String escape(String name) {
        return name.replaceFirst(".*:([a-zA-Z#0-9]+).*", "$1").replaceAll("[^A-Za-z0-9_-]", "_");
    }

    public static PCollection.IsBounded isBounded(RunnerApi.PCollection pCollection) {
        return pCollection.getIsBounded() == RunnerApi.IsBounded.Enum.BOUNDED ? PCollection.IsBounded.BOUNDED : PCollection.IsBounded.UNBOUNDED;
    }
}

