/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.samza.runtime;

import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import org.apache.beam.model.pipeline.v1.RunnerApi;
import org.apache.beam.runners.core.DoFnRunner;
import org.apache.beam.runners.core.DoFnRunners;
import org.apache.beam.runners.core.PushbackSideInputDoFnRunner;
import org.apache.beam.runners.core.ReadyCheckingSideInputReader;
import org.apache.beam.runners.core.SideInputHandler;
import org.apache.beam.runners.core.SimplePushbackSideInputDoFnRunner;
import org.apache.beam.runners.core.StateNamespace;
import org.apache.beam.runners.core.StateNamespaces;
import org.apache.beam.runners.core.StateTags;
import org.apache.beam.runners.core.TimerInternals;
import org.apache.beam.runners.core.construction.graph.ExecutableStage;
import org.apache.beam.runners.fnexecution.control.ExecutableStageContext;
import org.apache.beam.runners.fnexecution.control.StageBundleFactory;
import org.apache.beam.runners.fnexecution.provisioning.JobInfo;
import org.apache.beam.runners.fnexecution.state.StateRequestHandler;
import org.apache.beam.runners.samza.SamzaExecutionContext;
import org.apache.beam.runners.samza.SamzaPipelineOptions;
import org.apache.beam.runners.samza.runtime.BundleManager;
import org.apache.beam.runners.samza.runtime.DoFnRunnerWithKeyedInternals;
import org.apache.beam.runners.samza.runtime.FutureCollector;
import org.apache.beam.runners.samza.runtime.KeyedTimerData;
import org.apache.beam.runners.samza.runtime.Op;
import org.apache.beam.runners.samza.runtime.OpEmitter;
import org.apache.beam.runners.samza.runtime.OutputManagerFactory;
import org.apache.beam.runners.samza.runtime.SamzaDoFnInvokerRegistrar;
import org.apache.beam.runners.samza.runtime.SamzaDoFnRunners;
import org.apache.beam.runners.samza.runtime.SamzaExecutableStageContextFactory;
import org.apache.beam.runners.samza.runtime.SamzaStateRequestHandlers;
import org.apache.beam.runners.samza.runtime.SamzaStoreStateInternals;
import org.apache.beam.runners.samza.runtime.SamzaTimerInternalsFactory;
import org.apache.beam.runners.samza.util.FutureUtils;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.state.BagState;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.DoFnSchemaInformation;
import org.apache.beam.sdk.transforms.join.RawUnionValue;
import org.apache.beam.sdk.transforms.reflect.DoFnInvoker;
import org.apache.beam.sdk.transforms.reflect.DoFnInvokers;
import org.apache.beam.sdk.transforms.reflect.DoFnSignature;
import org.apache.beam.sdk.transforms.reflect.DoFnSignatures;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.transforms.windowing.PaneInfo;
import org.apache.beam.sdk.util.WindowedValue;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PCollectionView;
import org.apache.beam.sdk.values.TupleTag;
import org.apache.beam.sdk.values.WindowingStrategy;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Iterators;
import org.apache.samza.config.Config;
import org.apache.samza.context.Context;
import org.apache.samza.operators.Scheduler;
import org.joda.time.Instant;
import org.joda.time.ReadableInstant;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DoFnOp<InT, FnOutT, OutT>
implements Op<InT, OutT, Void> {
    private static final Logger LOG = LoggerFactory.getLogger(DoFnOp.class);
    private final TupleTag<FnOutT> mainOutputTag;
    private final DoFn<InT, FnOutT> doFn;
    private final Coder<?> keyCoder;
    private final Collection<PCollectionView<?>> sideInputs;
    private final List<TupleTag<?>> sideOutputTags;
    private final WindowingStrategy windowingStrategy;
    private final OutputManagerFactory<OutT> outputManagerFactory;
    private final HashMap<String, PCollectionView<?>> idToViewMap;
    private final String transformFullName;
    private final String transformId;
    private final Coder<InT> inputCoder;
    private final Coder<WindowedValue<InT>> windowedValueCoder;
    private final HashMap<TupleTag<?>, Coder<?>> outputCoders;
    private final PCollection.IsBounded isBounded;
    private final String bundleCheckTimerId;
    private final String bundleStateId;
    private final boolean isPortable;
    private final RunnerApi.ExecutableStagePayload stagePayload;
    private final JobInfo jobInfo;
    private final HashMap<String, TupleTag<?>> idToTupleTagMap;
    private transient SamzaTimerInternalsFactory<?> timerInternalsFactory;
    private transient DoFnRunner<InT, FnOutT> fnRunner;
    private transient PushbackSideInputDoFnRunner<InT, FnOutT> pushbackFnRunner;
    private transient SideInputHandler sideInputHandler;
    private transient DoFnInvoker<InT, FnOutT> doFnInvoker;
    private transient SamzaPipelineOptions samzaPipelineOptions;
    @SuppressWarnings(justification="No bug", value={"SE_TRANSIENT_FIELD_NOT_RESTORED"})
    private transient Instant pushbackWatermarkHold;
    private transient Instant inputWatermark;
    private transient BundleManager<OutT> bundleManager;
    private transient Instant sideInputWatermark;
    private transient List<WindowedValue<InT>> pushbackValues;
    private transient ExecutableStageContext stageContext;
    private transient StageBundleFactory stageBundleFactory;
    private DoFnSchemaInformation doFnSchemaInformation;
    private transient boolean bundleDisabled;
    private Map<?, PCollectionView<?>> sideInputMapping;

    public DoFnOp(TupleTag<FnOutT> mainOutputTag, DoFn<InT, FnOutT> doFn, Coder<?> keyCoder, Coder<InT> inputCoder, Coder<WindowedValue<InT>> windowedValueCoder, Map<TupleTag<?>, Coder<?>> outputCoders, Collection<PCollectionView<?>> sideInputs, List<TupleTag<?>> sideOutputTags, WindowingStrategy windowingStrategy, Map<String, PCollectionView<?>> idToViewMap, OutputManagerFactory<OutT> outputManagerFactory, String transformFullName, String transformId, PCollection.IsBounded isBounded, boolean isPortable, RunnerApi.ExecutableStagePayload stagePayload, JobInfo jobInfo, Map<String, TupleTag<?>> idToTupleTagMap, DoFnSchemaInformation doFnSchemaInformation, Map<?, PCollectionView<?>> sideInputMapping) {
        this.mainOutputTag = mainOutputTag;
        this.doFn = doFn;
        this.sideInputs = sideInputs;
        this.sideOutputTags = sideOutputTags;
        this.inputCoder = inputCoder;
        this.windowedValueCoder = windowedValueCoder;
        this.outputCoders = new HashMap(outputCoders);
        this.windowingStrategy = windowingStrategy;
        this.idToViewMap = new HashMap(idToViewMap);
        this.outputManagerFactory = outputManagerFactory;
        this.transformFullName = transformFullName;
        this.transformId = transformId;
        this.keyCoder = keyCoder;
        this.isBounded = isBounded;
        this.isPortable = isPortable;
        this.stagePayload = stagePayload;
        this.jobInfo = jobInfo;
        this.idToTupleTagMap = new HashMap(idToTupleTagMap);
        this.bundleCheckTimerId = "_samza_bundle_check_" + transformId;
        this.bundleStateId = "_samza_bundle_" + transformId;
        this.doFnSchemaInformation = doFnSchemaInformation;
        this.sideInputMapping = sideInputMapping;
    }

    @Override
    public void open(Config config, Context context, Scheduler<KeyedTimerData<Void>> timerRegistry, OpEmitter<OutT> emitter) {
        this.inputWatermark = BoundedWindow.TIMESTAMP_MIN_VALUE;
        this.sideInputWatermark = BoundedWindow.TIMESTAMP_MIN_VALUE;
        this.pushbackWatermarkHold = BoundedWindow.TIMESTAMP_MAX_VALUE;
        DoFnSignature signature = DoFnSignatures.getSignature(this.doFn.getClass());
        SamzaExecutionContext samzaExecutionContext = (SamzaExecutionContext)context.getApplicationContainerContext();
        this.samzaPipelineOptions = samzaExecutionContext.getPipelineOptions();
        this.bundleDisabled = this.samzaPipelineOptions.getMaxBundleSize() <= 1L;
        String stateId = "pardo-" + this.transformId;
        SamzaStoreStateInternals.Factory<Object> nonKeyedStateInternalsFactory = SamzaStoreStateInternals.createStateInternalFactory(stateId, null, context.getTaskContext(), this.samzaPipelineOptions, signature);
        FutureCollector<OutT> outputFutureCollector = this.createFutureCollector();
        this.bundleManager = new BundleManager<OutT>(this.createBundleProgressListener(), outputFutureCollector, this.samzaPipelineOptions.getMaxBundleSize(), this.samzaPipelineOptions.getMaxBundleTimeMs(), timerRegistry, this.bundleCheckTimerId);
        this.timerInternalsFactory = SamzaTimerInternalsFactory.createTimerInternalFactory(this.keyCoder, timerRegistry, this.getTimerStateId(signature), nonKeyedStateInternalsFactory, this.windowingStrategy, this.isBounded, this.samzaPipelineOptions);
        this.sideInputHandler = new SideInputHandler(this.sideInputs, nonKeyedStateInternalsFactory.stateInternalsForKey(null));
        if (this.isPortable) {
            BagState bundledEventsBagState = (BagState)nonKeyedStateInternalsFactory.stateInternalsForKey(null).state(StateNamespaces.global(), StateTags.bag((String)this.bundleStateId, this.windowedValueCoder));
            ExecutableStage executableStage = ExecutableStage.fromPayload((RunnerApi.ExecutableStagePayload)this.stagePayload);
            this.stageContext = SamzaExecutableStageContextFactory.getInstance().get(this.jobInfo);
            this.stageBundleFactory = this.stageContext.getStageBundleFactory(executableStage);
            StateRequestHandler stateRequestHandler = SamzaStateRequestHandlers.of(executableStage, this.sideInputMapping, this.sideInputHandler);
            this.fnRunner = SamzaDoFnRunners.createPortable(this.samzaPipelineOptions, bundledEventsBagState, this.outputManagerFactory.create(emitter, outputFutureCollector), this.stageBundleFactory, stateRequestHandler, this.mainOutputTag, this.idToTupleTagMap, context, this.transformFullName);
        } else {
            this.fnRunner = SamzaDoFnRunners.create(this.samzaPipelineOptions, this.doFn, this.windowingStrategy, this.transformFullName, stateId, context, this.mainOutputTag, this.sideInputHandler, this.timerInternalsFactory, this.keyCoder, this.outputManagerFactory.create(emitter, outputFutureCollector), this.inputCoder, this.sideOutputTags, this.outputCoders, this.doFnSchemaInformation, this.sideInputMapping);
        }
        this.pushbackFnRunner = SimplePushbackSideInputDoFnRunner.create(this.fnRunner, this.sideInputs, (ReadyCheckingSideInputReader)this.sideInputHandler);
        this.pushbackValues = new ArrayList<WindowedValue<InT>>();
        Iterator<SamzaDoFnInvokerRegistrar> invokerReg = ServiceLoader.load(SamzaDoFnInvokerRegistrar.class).iterator();
        this.doFnInvoker = !invokerReg.hasNext() ? DoFnInvokers.tryInvokeSetupFor(this.doFn, (PipelineOptions)this.samzaPipelineOptions) : ((SamzaDoFnInvokerRegistrar)Iterators.getOnlyElement(invokerReg)).invokerSetupFor(this.doFn, this.samzaPipelineOptions, context);
    }

    FutureCollector<OutT> createFutureCollector() {
        return new FutureCollectorImpl();
    }

    private String getTimerStateId(DoFnSignature signature) {
        StringBuilder builder = new StringBuilder("timer");
        if (signature.usesTimers()) {
            signature.timerDeclarations().keySet().forEach(key -> builder.append((String)key));
        }
        return builder.toString();
    }

    @Override
    public void processElement(WindowedValue<InT> inputElement, OpEmitter<OutT> emitter) {
        try {
            this.bundleManager.tryStartBundle();
            Iterable rejectedValues = this.pushbackFnRunner.processElementInReadyWindows(inputElement);
            for (WindowedValue rejectedValue : rejectedValues) {
                if (rejectedValue.getTimestamp().compareTo((ReadableInstant)this.pushbackWatermarkHold) < 0) {
                    this.pushbackWatermarkHold = rejectedValue.getTimestamp();
                }
                this.pushbackValues.add(rejectedValue);
            }
            this.bundleManager.tryFinishBundle(emitter);
        }
        catch (Throwable t) {
            LOG.error("Encountered error during process element", t);
            this.bundleManager.signalFailure(t);
            throw t;
        }
    }

    private void doProcessWatermark(Instant watermark, OpEmitter<OutT> emitter) {
        this.inputWatermark = watermark;
        if (this.sideInputWatermark.isEqual((ReadableInstant)BoundedWindow.TIMESTAMP_MAX_VALUE)) {
            this.emitAllPushbackValues();
        }
        Instant actualInputWatermark = this.pushbackWatermarkHold.isBefore((ReadableInstant)this.inputWatermark) ? this.pushbackWatermarkHold : this.inputWatermark;
        this.timerInternalsFactory.setInputWatermark(actualInputWatermark);
        Collection<KeyedTimerData<?>> readyTimers = this.timerInternalsFactory.removeReadyTimers();
        if (!readyTimers.isEmpty()) {
            this.pushbackFnRunner.startBundle();
            for (KeyedTimerData<?> keyedTimerData : readyTimers) {
                this.fireTimer(keyedTimerData);
            }
            this.pushbackFnRunner.finishBundle();
        }
        if (this.timerInternalsFactory.getOutputWatermark() == null || this.timerInternalsFactory.getOutputWatermark().isBefore((ReadableInstant)actualInputWatermark)) {
            this.timerInternalsFactory.setOutputWatermark(actualInputWatermark);
            emitter.emitWatermark(this.timerInternalsFactory.getOutputWatermark());
        }
    }

    @Override
    public void processWatermark(Instant watermark, OpEmitter<OutT> emitter) {
        this.bundleManager.processWatermark(watermark, emitter);
    }

    @Override
    public void processSideInput(String id, WindowedValue<? extends Iterable<?>> elements, OpEmitter<OutT> emitter) {
        Preconditions.checkState((boolean)this.bundleDisabled, (Object)"Side input not supported in bundling mode. Please disable bundling.");
        WindowedValue<? extends Iterable<?>> retypedElements = elements;
        PCollectionView<?> view = this.idToViewMap.get(id);
        if (view == null) {
            throw new IllegalArgumentException("No mapping of id " + id + " to view.");
        }
        this.sideInputHandler.addSideInputValue(view, retypedElements);
        ArrayList<WindowedValue<InT>> previousPushbackValues = new ArrayList<WindowedValue<InT>>(this.pushbackValues);
        this.pushbackWatermarkHold = BoundedWindow.TIMESTAMP_MAX_VALUE;
        this.pushbackValues.clear();
        for (WindowedValue windowedValue : previousPushbackValues) {
            this.processElement(windowedValue, emitter);
        }
        this.processWatermark(this.inputWatermark, emitter);
    }

    @Override
    public void processSideInputWatermark(Instant watermark, OpEmitter<OutT> emitter) {
        Preconditions.checkState((boolean)this.bundleDisabled, (Object)"Side input not supported in bundling mode. Please disable bundling.");
        this.sideInputWatermark = watermark;
        if (this.sideInputWatermark.isEqual((ReadableInstant)BoundedWindow.TIMESTAMP_MAX_VALUE)) {
            this.processWatermark(this.inputWatermark, emitter);
        }
    }

    @Override
    public void processTimer(KeyedTimerData<Void> keyedTimerData, OpEmitter<OutT> emitter) {
        if (this.bundleCheckTimerId.equals(keyedTimerData.getTimerData().getTimerId())) {
            this.bundleManager.processTimer(keyedTimerData, emitter);
            return;
        }
        this.pushbackFnRunner.startBundle();
        this.fireTimer(keyedTimerData);
        this.pushbackFnRunner.finishBundle();
        this.timerInternalsFactory.removeProcessingTimer(keyedTimerData);
    }

    @Override
    public void close() {
        this.doFnInvoker.invokeTeardown();
        try (StageBundleFactory factory = this.stageBundleFactory;){
            ExecutableStageContext context = this.stageContext;
            Throwable throwable = null;
            if (context != null) {
                if (throwable != null) {
                    try {
                        context.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                } else {
                    context.close();
                }
            }
        }
        catch (Exception e) {
            LOG.error("Failed to close stage bundle factory", (Throwable)e);
        }
    }

    private void fireTimer(KeyedTimerData<?> keyedTimerData) {
        TimerInternals.TimerData timer = keyedTimerData.getTimerData();
        LOG.debug("Firing timer {}", (Object)timer);
        StateNamespace namespace = timer.getNamespace();
        BoundedWindow window = ((StateNamespaces.WindowNamespace)namespace).getWindow();
        if (this.fnRunner instanceof DoFnRunnerWithKeyedInternals) {
            ((DoFnRunnerWithKeyedInternals)this.fnRunner).onTimer(keyedTimerData, window);
        } else {
            this.pushbackFnRunner.onTimer(timer.getTimerId(), timer.getTimerFamilyId(), null, window, timer.getTimestamp(), timer.getOutputTimestamp(), timer.getDomain());
        }
    }

    private void emitAllPushbackValues() {
        if (!this.pushbackValues.isEmpty()) {
            this.pushbackFnRunner.startBundle();
            ArrayList<WindowedValue<InT>> previousPushbackValues = new ArrayList<WindowedValue<InT>>(this.pushbackValues);
            this.pushbackWatermarkHold = BoundedWindow.TIMESTAMP_MAX_VALUE;
            this.pushbackValues.clear();
            for (WindowedValue windowedValue : previousPushbackValues) {
                this.fnRunner.processElement(windowedValue);
            }
            this.pushbackFnRunner.finishBundle();
        }
    }

    private BundleManager.BundleProgressListener<OutT> createBundleProgressListener() {
        return new BundleManager.BundleProgressListener<OutT>(){

            @Override
            public void onBundleStarted() {
                DoFnOp.this.pushbackFnRunner.startBundle();
            }

            @Override
            public void onBundleFinished(OpEmitter<OutT> emitter) {
                DoFnOp.this.pushbackFnRunner.finishBundle();
            }

            @Override
            public void onWatermark(Instant watermark, OpEmitter<OutT> emitter) {
                DoFnOp.this.doProcessWatermark(watermark, emitter);
            }
        };
    }

    static <T, OutT> CompletionStage<WindowedValue<OutT>> createOutputFuture(WindowedValue<T> windowedValue, CompletionStage<T> valueFuture, Function<T, OutT> valueMapper) {
        return valueFuture.thenApply(res -> WindowedValue.of(valueMapper.apply(res), (Instant)windowedValue.getTimestamp(), (Collection)windowedValue.getWindows(), (PaneInfo)windowedValue.getPane()));
    }

    public static class MultiOutputManagerFactory
    implements OutputManagerFactory<RawUnionValue> {
        private final Map<TupleTag<?>, Integer> tagToIndexMap;

        public MultiOutputManagerFactory(Map<TupleTag<?>, Integer> tagToIndexMap) {
            this.tagToIndexMap = tagToIndexMap;
        }

        @Override
        public DoFnRunners.OutputManager create(OpEmitter<RawUnionValue> emitter) {
            return this.createOutputManager(emitter, null);
        }

        @Override
        public DoFnRunners.OutputManager create(OpEmitter<RawUnionValue> emitter, FutureCollector<RawUnionValue> collector) {
            return this.createOutputManager(emitter, collector);
        }

        private DoFnRunners.OutputManager createOutputManager(final OpEmitter<RawUnionValue> emitter, final FutureCollector<RawUnionValue> collector) {
            return new DoFnRunners.OutputManager(){

                public <T> void output(TupleTag<T> tupleTag, WindowedValue<T> windowedValue) {
                    int index = (Integer)tagToIndexMap.get(tupleTag);
                    Object rawValue = windowedValue.getValue();
                    if (rawValue instanceof CompletionStage) {
                        CompletionStage valueFuture = (CompletionStage)rawValue;
                        if (collector != null) {
                            collector.add(DoFnOp.createOutputFuture(windowedValue, valueFuture, res -> new RawUnionValue(index, res)));
                        }
                    } else {
                        RawUnionValue rawUnionValue = new RawUnionValue(index, rawValue);
                        emitter.emitElement(windowedValue.withValue((Object)rawUnionValue));
                    }
                }
            };
        }
    }

    public static class SingleOutputManagerFactory<OutT>
    implements OutputManagerFactory<OutT> {
        @Override
        public DoFnRunners.OutputManager create(OpEmitter<OutT> emitter) {
            return this.createOutputManager(emitter, null);
        }

        @Override
        public DoFnRunners.OutputManager create(OpEmitter<OutT> emitter, FutureCollector<OutT> collector) {
            return this.createOutputManager(emitter, collector);
        }

        private DoFnRunners.OutputManager createOutputManager(final OpEmitter<OutT> emitter, final FutureCollector<OutT> collector) {
            return new DoFnRunners.OutputManager(){

                public <T> void output(TupleTag<T> tupleTag, WindowedValue<T> windowedValue) {
                    if (windowedValue.getValue() instanceof CompletionStage) {
                        CompletionStage valueFuture = (CompletionStage)windowedValue.getValue();
                        if (collector != null) {
                            collector.add(DoFnOp.createOutputFuture(windowedValue, valueFuture, value -> value));
                        }
                    } else {
                        WindowedValue<T> retypedWindowedValue = windowedValue;
                        emitter.emitElement(retypedWindowedValue);
                    }
                }
            };
        }
    }

    static class FutureCollectorImpl<OutT>
    implements FutureCollector<OutT> {
        private final List<CompletionStage<WindowedValue<OutT>>> outputFutures = Collections.synchronizedList(new ArrayList());
        private AtomicBoolean collectorSealed = new AtomicBoolean(true);

        FutureCollectorImpl() {
        }

        @Override
        public void add(CompletionStage<WindowedValue<OutT>> element) {
            Preconditions.checkState((!this.collectorSealed.get() ? 1 : 0) != 0, (Object)"Cannot add elements to an unprepared collector. Make sure prepare() is invoked before adding elements.");
            this.outputFutures.add(element);
        }

        @Override
        public void discard() {
            this.collectorSealed.compareAndSet(false, true);
            this.outputFutures.clear();
        }

        @Override
        public CompletionStage<Collection<WindowedValue<OutT>>> finish() {
            this.collectorSealed.compareAndSet(false, true);
            CompletionStage<Collection<WindowedValue<OutT>>> sealedOutputFuture = FutureUtils.flattenFutures(this.outputFutures);
            this.outputFutures.clear();
            return sealedOutputFuture;
        }

        @Override
        public void prepare() {
            boolean isCollectorSealed = this.collectorSealed.compareAndSet(true, false);
            Preconditions.checkState((boolean)isCollectorSealed, (Object)"Failed to prepare the collector. Collector needs to be sealed before prepare() is invoked.");
        }
    }
}

