/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.samza.translation;

import java.io.File;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.apache.beam.repackaged.core.org.apache.commons.lang3.StringUtils;
import org.apache.beam.runners.core.construction.SerializablePipelineOptions;
import org.apache.beam.runners.core.serialization.Base64Serializer;
import org.apache.beam.runners.samza.SamzaExecutionEnvironment;
import org.apache.beam.runners.samza.SamzaPipelineOptions;
import org.apache.beam.runners.samza.container.BeamContainerRunner;
import org.apache.beam.runners.samza.container.BeamJobCoordinatorRunner;
import org.apache.beam.runners.samza.runtime.SamzaStoreStateInternals;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.annotations.VisibleForTesting;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableMap;
import org.apache.samza.config.Config;
import org.apache.samza.config.ConfigLoaderFactory;
import org.apache.samza.config.MapConfig;
import org.apache.samza.config.loaders.PropertiesConfigLoaderFactory;
import org.apache.samza.container.grouper.task.SingleContainerGrouperFactory;
import org.apache.samza.job.yarn.YarnJobFactory;
import org.apache.samza.runtime.LocalApplicationRunner;
import org.apache.samza.runtime.RemoteApplicationRunner;
import org.apache.samza.standalone.PassthroughJobCoordinatorFactory;
import org.apache.samza.zk.ZkJobCoordinatorFactory;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigBuilder {
    private static final @UnknownKeyFor @NonNull @Initialized Logger LOG = LoggerFactory.getLogger(ConfigBuilder.class);
    private static final @UnknownKeyFor @NonNull @Initialized String BEAM_STORE_FACTORY = "stores.beamStore.factory";
    private static final @UnknownKeyFor @NonNull @Initialized String APP_RUNNER_CLASS = "app.runner.class";
    private static final @UnknownKeyFor @NonNull @Initialized String YARN_PACKAGE_PATH = "yarn.package.path";
    private static final @UnknownKeyFor @NonNull @Initialized String JOB_FACTORY_CLASS = "job.factory.class";
    private final @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized String> config = new HashMap<String, String>();
    private final @UnknownKeyFor @NonNull @Initialized SamzaPipelineOptions options;

    public ConfigBuilder(@UnknownKeyFor @NonNull @Initialized SamzaPipelineOptions options) {
        this.options = options;
    }

    public void put(@UnknownKeyFor @NonNull @Initialized String name, @UnknownKeyFor @NonNull @Initialized String property) {
        this.config.put(name, property);
    }

    public void putAll(@UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized String> properties) {
        this.config.putAll(properties);
    }

    public @UnknownKeyFor @NonNull @Initialized Config build() {
        try {
            this.config.putAll(ConfigBuilder.createSystemConfig(this.options, this.config));
            this.config.putAll(ConfigBuilder.createUserConfig(this.options));
            this.config.put("app.name", this.options.getJobName());
            this.config.put("app.id", this.options.getJobInstance());
            this.config.put("job.name", this.options.getJobName());
            this.config.put("job.id", this.options.getJobInstance());
            this.config.put("task.max.concurrency", String.valueOf(this.options.getMaxBundleSize()));
            this.options.setConfigOverride(new HashMap<String, String>());
            this.config.put("beamPipelineOptions", Base64Serializer.serializeUnchecked((Serializable)new SerializablePipelineOptions((PipelineOptions)this.options)));
            ConfigBuilder.validateConfigs(this.options, this.config);
            return new MapConfig(this.config);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized String> createUserConfig(@UnknownKeyFor @NonNull @Initialized SamzaPipelineOptions options) throws @UnknownKeyFor @NonNull @Initialized Exception {
        HashMap<String, String> config = new HashMap<String, String>();
        String configFilePath = options.getConfigFilePath();
        if (StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{configFilePath})) {
            LOG.info("configFilePath: " + configFilePath);
            MapConfig properties = new MapConfig(Collections.singletonMap("path", configFilePath));
            ConfigLoaderFactory configLoaderFactory = options.getConfigLoaderFactory().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            LOG.info("configLoaderFactory: " + configLoaderFactory.getClass().getName());
            if (configLoaderFactory instanceof PropertiesConfigLoaderFactory) {
                Preconditions.checkArgument((boolean)new File(configFilePath).exists(), (String)"Config file %s does not exist", (Object)configFilePath);
            }
            config.putAll((Map<String, String>)configLoaderFactory.getLoader((Config)properties).getConfig());
        }
        if (options.getConfigOverride() != null) {
            config.putAll(options.getConfigOverride());
        }
        return config;
    }

    private static void validateZKStandAloneRun(@UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized String> config) {
        Preconditions.checkArgument((boolean)config.containsKey(APP_RUNNER_CLASS), (String)"Config %s not found for %s Deployment", (Object)APP_RUNNER_CLASS, (Object)((Object)SamzaExecutionEnvironment.STANDALONE));
        Preconditions.checkArgument((boolean)config.get(APP_RUNNER_CLASS).equals(LocalApplicationRunner.class.getName()), (String)"Config %s must be set to %s for %s Deployment", (Object)APP_RUNNER_CLASS, (Object)LocalApplicationRunner.class.getName(), (Object)((Object)SamzaExecutionEnvironment.STANDALONE));
        Preconditions.checkArgument((boolean)config.containsKey("job.coordinator.factory"), (String)"Config %s not found for %s Deployment", (Object)"job.coordinator.factory", (Object)((Object)SamzaExecutionEnvironment.STANDALONE));
        Preconditions.checkArgument((boolean)config.get("job.coordinator.factory").equals(ZkJobCoordinatorFactory.class.getName()), (String)"Config %s must be set to %s for %s Deployment", (Object)"job.coordinator.factory", (Object)ZkJobCoordinatorFactory.class.getName(), (Object)((Object)SamzaExecutionEnvironment.STANDALONE));
        Preconditions.checkArgument((boolean)config.containsKey("job.coordinator.zk.connect"), (String)"Config %s not found for %s Deployment", (Object)"job.coordinator.zk.connect", (Object)((Object)SamzaExecutionEnvironment.STANDALONE));
    }

    private static void validateYarnRun(@UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized String> config) {
        Preconditions.checkArgument((boolean)config.containsKey(YARN_PACKAGE_PATH), (String)"Config %s not found for %s Deployment", (Object)YARN_PACKAGE_PATH, (Object)((Object)SamzaExecutionEnvironment.YARN));
        String appRunner = config.get(APP_RUNNER_CLASS);
        Preconditions.checkArgument((appRunner == null || BeamJobCoordinatorRunner.class.getName().equals(appRunner) || RemoteApplicationRunner.class.getName().equals(appRunner) || BeamContainerRunner.class.getName().equals(appRunner) ? 1 : 0) != 0, (String)"Config %s must be set to %s for %s Deployment", (Object)APP_RUNNER_CLASS, (Object)RemoteApplicationRunner.class.getName(), (Object)((Object)SamzaExecutionEnvironment.YARN));
        Preconditions.checkArgument((boolean)config.containsKey(JOB_FACTORY_CLASS), (String)"Config %s not found for %s Deployment", (Object)JOB_FACTORY_CLASS, (Object)((Object)SamzaExecutionEnvironment.YARN));
    }

    @VisibleForTesting
    public static @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized String> localRunConfig() {
        return ImmutableMap.builder().put((Object)APP_RUNNER_CLASS, (Object)LocalApplicationRunner.class.getName()).put((Object)"job.coordinator.factory", (Object)PassthroughJobCoordinatorFactory.class.getName()).put((Object)"task.name.grouper.factory", (Object)SingleContainerGrouperFactory.class.getName()).put((Object)"task.commit.ms", (Object)"-1").put((Object)"processor.id", (Object)"1").put((Object)"app.run.id", (Object)(System.currentTimeMillis() + "-" + UUID.randomUUID().toString().substring(0, 8))).build();
    }

    public static @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized String> yarnRunConfig() {
        return ImmutableMap.builder().put((Object)APP_RUNNER_CLASS, (Object)RemoteApplicationRunner.class.getName()).put((Object)JOB_FACTORY_CLASS, (Object)YarnJobFactory.class.getName()).build();
    }

    public static @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized String> standAloneRunConfig() {
        return ImmutableMap.builder().put((Object)APP_RUNNER_CLASS, (Object)LocalApplicationRunner.class.getName()).put((Object)"job.coordinator.factory", (Object)ZkJobCoordinatorFactory.class.getName()).build();
    }

    private static @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized String> createSystemConfig(@UnknownKeyFor @NonNull @Initialized SamzaPipelineOptions options, @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized String> config) {
        ImmutableMap.Builder configBuilder = ImmutableMap.builder().put((Object)"stores.beamStore.key.serde", (Object)"byteArraySerde").put((Object)"stores.beamStore.msg.serde", (Object)"stateValueSerde").put((Object)"serializers.registry.stateValueSerde.class", (Object)SamzaStoreStateInternals.StateValueSerdeFactory.class.getName()).put((Object)"serializers.registry.byteArraySerde.class", (Object)SamzaStoreStateInternals.ByteArraySerdeFactory.class.getName());
        if (!config.containsKey(BEAM_STORE_FACTORY)) {
            options.setStateDurable(false);
            configBuilder.put((Object)BEAM_STORE_FACTORY, (Object)"org.apache.samza.storage.kv.inmemory.InMemoryKeyValueStorageEngineFactory");
        }
        LOG.info("Execution environment is " + (Object)((Object)options.getSamzaExecutionEnvironment()));
        switch (options.getSamzaExecutionEnvironment()) {
            case YARN: {
                configBuilder.putAll(ConfigBuilder.yarnRunConfig());
                break;
            }
            case STANDALONE: {
                configBuilder.putAll(ConfigBuilder.standAloneRunConfig());
                break;
            }
            default: {
                configBuilder.putAll(ConfigBuilder.localRunConfig());
            }
        }
        configBuilder.put((Object)"samza.li.task.wrapper.enabled", (Object)"false");
        return configBuilder.build();
    }

    static @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized String> createRocksDBStoreConfig(@UnknownKeyFor @NonNull @Initialized SamzaPipelineOptions options) {
        ImmutableMap.Builder configBuilder = ImmutableMap.builder().put((Object)BEAM_STORE_FACTORY, (Object)"org.apache.samza.storage.kv.RocksDbKeyValueStorageEngineFactory").put((Object)"stores.beamStore.rocksdb.compression", (Object)"lz4");
        if (options.getStateDurable().booleanValue()) {
            LOG.info("stateDurable is enabled");
            configBuilder.put((Object)"stores.beamStore.changelog", (Object)ConfigBuilder.getChangelogTopic(options, "beamStore"));
            configBuilder.put((Object)"job.host-affinity.enabled", (Object)"true");
        }
        return configBuilder.build();
    }

    private static void validateConfigs(@UnknownKeyFor @NonNull @Initialized SamzaPipelineOptions options, @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized String> config) {
        switch (options.getSamzaExecutionEnvironment()) {
            case YARN: {
                ConfigBuilder.validateYarnRun(config);
                break;
            }
            case STANDALONE: {
                ConfigBuilder.validateZKStandAloneRun(config);
                break;
            }
        }
    }

    static @UnknownKeyFor @NonNull @Initialized String getChangelogTopic(@UnknownKeyFor @NonNull @Initialized SamzaPipelineOptions options, @UnknownKeyFor @NonNull @Initialized String storeName) {
        return String.format("%s-%s-%s-changelog", options.getJobName(), options.getJobInstance(), storeName);
    }
}

