/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.samza.runtime;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.beam.runners.core.StateInternals;
import org.apache.beam.runners.core.StateInternalsFactory;
import org.apache.beam.runners.core.StateNamespace;
import org.apache.beam.runners.core.StateTag;
import org.apache.beam.runners.core.TimerInternals;
import org.apache.beam.runners.core.TimerInternalsFactory;
import org.apache.beam.runners.samza.runtime.SamzaStoreStateInternals;
import org.apache.beam.sdk.state.State;
import org.apache.beam.sdk.state.StateContext;
import org.apache.beam.sdk.state.TimeDomain;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.joda.time.Instant;

@ThreadSafe
class KeyedInternals<@UnknownKeyFor K> {
    private static final @UnknownKeyFor @NonNull @Initialized ThreadLocal<@UnknownKeyFor @NonNull @Initialized KeyedStates> threadLocalKeyedStates = new ThreadLocal();
    private final @UnknownKeyFor @NonNull @Initialized StateInternalsFactory<K> stateFactory;
    private final @UnknownKeyFor @NonNull @Initialized TimerInternalsFactory<K> timerFactory;

    KeyedInternals(@UnknownKeyFor @NonNull @Initialized StateInternalsFactory<K> stateFactory, @UnknownKeyFor @NonNull @Initialized TimerInternalsFactory<K> timerFactory) {
        this.stateFactory = stateFactory;
        this.timerFactory = timerFactory;
    }

    @UnknownKeyFor @NonNull @Initialized StateInternals stateInternals() {
        return new KeyedStateInternals();
    }

    @UnknownKeyFor @NonNull @Initialized TimerInternals timerInternals() {
        return new KeyedTimerInternals();
    }

    void setKey(K key) {
        Preconditions.checkState((threadLocalKeyedStates.get() == null ? 1 : 0) != 0, (String)"States for key %s is not cleared before processing", key);
        threadLocalKeyedStates.set(new KeyedStates(key));
    }

    K getKey() {
        KeyedStates keyedStates = threadLocalKeyedStates.get();
        return (K)(keyedStates == null ? null : keyedStates.key);
    }

    void clearKey() {
        List states = threadLocalKeyedStates.get().states;
        states.forEach(state -> {
            if (state instanceof SamzaStoreStateInternals.KeyValueIteratorState) {
                ((SamzaStoreStateInternals.KeyValueIteratorState)state).closeIterators();
            }
        });
        states.clear();
        threadLocalKeyedStates.remove();
    }

    private class KeyedTimerInternals
    implements TimerInternals {
        private KeyedTimerInternals() {
        }

        private @UnknownKeyFor @NonNull @Initialized TimerInternals getInternals() {
            return KeyedInternals.this.timerFactory.timerInternalsForKey(KeyedInternals.this.getKey());
        }

        public void setTimer(@UnknownKeyFor @NonNull @Initialized StateNamespace namespace, @UnknownKeyFor @NonNull @Initialized String timerId, @UnknownKeyFor @NonNull @Initialized String timerFamilyId, @UnknownKeyFor @NonNull @Initialized Instant target, @UnknownKeyFor @NonNull @Initialized Instant outputTimestamp, @UnknownKeyFor @NonNull @Initialized TimeDomain timeDomain) {
            this.getInternals().setTimer(namespace, timerId, timerFamilyId, target, outputTimestamp, timeDomain);
        }

        public void setTimer(// Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized TimerInternals.TimerData timerData) {
            this.getInternals().setTimer(timerData);
        }

        public void deleteTimer(@UnknownKeyFor @NonNull @Initialized StateNamespace namespace, @UnknownKeyFor @NonNull @Initialized String timerId, @UnknownKeyFor @NonNull @Initialized TimeDomain timeDomain) {
            this.getInternals().deleteTimer(namespace, timerId, timeDomain);
        }

        public void deleteTimer(@UnknownKeyFor @NonNull @Initialized StateNamespace namespace, @UnknownKeyFor @NonNull @Initialized String timerId, @UnknownKeyFor @NonNull @Initialized String timerFamilyId) {
            this.getInternals().deleteTimer(namespace, timerId, timerFamilyId);
        }

        public void deleteTimer(// Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized TimerInternals.TimerData timerKey) {
            this.getInternals().deleteTimer(timerKey);
        }

        public @UnknownKeyFor @NonNull @Initialized Instant currentProcessingTime() {
            return this.getInternals().currentProcessingTime();
        }

        public @Nullable @UnknownKeyFor @Initialized Instant currentSynchronizedProcessingTime() {
            return this.getInternals().currentSynchronizedProcessingTime();
        }

        public @UnknownKeyFor @NonNull @Initialized Instant currentInputWatermarkTime() {
            return this.getInternals().currentInputWatermarkTime();
        }

        public @Nullable @UnknownKeyFor @Initialized Instant currentOutputWatermarkTime() {
            return this.getInternals().currentOutputWatermarkTime();
        }
    }

    private class KeyedStateInternals
    implements StateInternals {
        private KeyedStateInternals() {
        }

        public K getKey() {
            return KeyedInternals.this.getKey();
        }

        public <T extends State> T state(@UnknownKeyFor @NonNull @Initialized StateNamespace namespace, @UnknownKeyFor @NonNull @Initialized StateTag<T> address, /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized StateContext<@UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?> c) {
            Preconditions.checkState((this.getKey() != null ? 1 : 0) != 0, (Object)"Key is not set before state access in Stateful ParDo.");
            State state = KeyedInternals.this.stateFactory.stateInternalsForKey(this.getKey()).state(namespace, address, c);
            ((KeyedStates)threadLocalKeyedStates.get()).states.add(state);
            return (T)state;
        }
    }

    private static class KeyedStates<@UnknownKeyFor K> {
        private final K key;
        private final @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized State> states;

        private KeyedStates(K key) {
            this.key = key;
            this.states = new ArrayList<State>();
        }
    }
}

