/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.samza;

import org.apache.beam.model.jobmanagement.v1.JobApi;
import org.apache.beam.model.pipeline.v1.RunnerApi;
import org.apache.beam.runners.core.construction.graph.GreedyPipelineFuser;
import org.apache.beam.runners.jobsubmission.JobInvocation;
import org.apache.beam.runners.samza.SamzaPipelineOptions;
import org.apache.beam.runners.samza.SamzaPipelineResult;
import org.apache.beam.runners.samza.SamzaPortablePipelineResult;
import org.apache.beam.runners.samza.SamzaRunner;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SamzaJobInvocation
extends JobInvocation {
    private static final @UnknownKeyFor @NonNull @Initialized Logger LOG = LoggerFactory.getLogger(SamzaJobInvocation.class);
    private final @UnknownKeyFor @NonNull @Initialized SamzaPipelineOptions options;
    private final // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized RunnerApi.Pipeline originalPipeline;
    private volatile @UnknownKeyFor @NonNull @Initialized SamzaPipelineResult pipelineResult;

    public SamzaJobInvocation(// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized RunnerApi.Pipeline pipeline, @UnknownKeyFor @NonNull @Initialized SamzaPipelineOptions options) {
        super(null, null, pipeline, null);
        this.originalPipeline = pipeline;
        this.options = options;
    }

    private @UnknownKeyFor @NonNull @Initialized SamzaPipelineResult invokeSamzaJob() {
        RunnerApi.Pipeline fusedPipeline = GreedyPipelineFuser.fuse((RunnerApi.Pipeline)this.originalPipeline).toPipeline();
        this.options.setRunner(SamzaRunner.class);
        try {
            SamzaRunner runner = SamzaRunner.fromOptions(this.options);
            return (SamzaPortablePipelineResult)runner.runPortablePipeline(fusedPipeline);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to invoke samza job", e);
        }
    }

    public synchronized void start() {
        LOG.info("Starting job invocation {}", (Object)this.getId());
        this.pipelineResult = this.invokeSamzaJob();
    }

    public @UnknownKeyFor @NonNull @Initialized String getId() {
        return this.options.getJobName();
    }

    public synchronized void cancel() {
        try {
            if (this.pipelineResult != null) {
                LOG.info("Cancelling pipeline {}", (Object)this.getId());
                this.pipelineResult.cancel();
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to cancel job.", e);
        }
    }

    public // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized JobApi.JobState.Enum getState() {
        if (this.pipelineResult == null) {
            return JobApi.JobState.Enum.STARTING;
        }
        switch (this.pipelineResult.getState()) {
            case RUNNING: {
                return JobApi.JobState.Enum.RUNNING;
            }
            case FAILED: {
                return JobApi.JobState.Enum.FAILED;
            }
            case DONE: {
                return JobApi.JobState.Enum.DONE;
            }
            case STOPPED: {
                return JobApi.JobState.Enum.STOPPED;
            }
            case UPDATED: {
                return JobApi.JobState.Enum.UPDATED;
            }
            case CANCELLED: {
                return JobApi.JobState.Enum.CANCELLED;
            }
        }
        return JobApi.JobState.Enum.UNRECOGNIZED;
    }
}

