/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.samza;

import java.io.File;
import java.nio.file.Paths;
import java.util.HashMap;
import org.apache.beam.runners.samza.SamzaPipelineOptions;
import org.apache.beam.runners.samza.SamzaPipelineResult;
import org.apache.beam.runners.samza.SamzaRunner;
import org.apache.beam.runners.samza.translation.ConfigBuilder;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.PipelineResult;
import org.apache.beam.sdk.PipelineRunner;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.options.PipelineOptionsValidator;
import org.apache.commons.io.FileUtils;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class TestSamzaRunner
extends PipelineRunner<PipelineResult> {
    private final @UnknownKeyFor @NonNull @Initialized SamzaRunner delegate;

    public static @UnknownKeyFor @NonNull @Initialized TestSamzaRunner fromOptions(@UnknownKeyFor @NonNull @Initialized PipelineOptions options) {
        return new TestSamzaRunner(TestSamzaRunner.createSamzaPipelineOptions(options));
    }

    public static @UnknownKeyFor @NonNull @Initialized SamzaPipelineOptions createSamzaPipelineOptions(@UnknownKeyFor @NonNull @Initialized PipelineOptions options) {
        try {
            SamzaPipelineOptions samzaOptions = (SamzaPipelineOptions)PipelineOptionsValidator.validate(SamzaPipelineOptions.class, (PipelineOptions)options);
            HashMap<String, String> config = new HashMap<String, String>(ConfigBuilder.localRunConfig());
            File storeDir = Paths.get(System.getProperty("java.io.tmpdir"), "beam-samza-test").toFile();
            FileUtils.deleteDirectory((File)storeDir);
            if (!storeDir.mkdir()) {
                // empty if block
            }
            config.put("job.logged.store.base.dir", storeDir.getAbsolutePath());
            config.put("job.non-logged.store.base.dir", storeDir.getAbsolutePath());
            if (samzaOptions.getConfigOverride() != null) {
                config.putAll(samzaOptions.getConfigOverride());
            }
            samzaOptions.setConfigOverride(config);
            return samzaOptions;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public TestSamzaRunner(@UnknownKeyFor @NonNull @Initialized SamzaPipelineOptions options) {
        this.delegate = SamzaRunner.fromOptions(options);
    }

    public @UnknownKeyFor @NonNull @Initialized PipelineResult run(@UnknownKeyFor @NonNull @Initialized Pipeline pipeline) {
        try {
            SamzaPipelineResult result = this.delegate.run(pipeline);
            result.waitUntilFinish();
            return result;
        }
        catch (Throwable t) {
            for (Throwable current = t; current != null; current = current.getCause()) {
                if (!(current instanceof AssertionError)) continue;
                throw (AssertionError)((Object)current);
            }
            throw t;
        }
    }
}

