/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.samza;

import org.apache.beam.model.pipeline.v1.RunnerApi;
import org.apache.beam.runners.core.construction.graph.GreedyPipelineFuser;
import org.apache.beam.runners.core.construction.graph.ProtoOverrides;
import org.apache.beam.runners.core.construction.graph.SplittableParDoExpander;
import org.apache.beam.runners.core.construction.renderer.PipelineDotRenderer;
import org.apache.beam.runners.fnexecution.provisioning.JobInfo;
import org.apache.beam.runners.jobsubmission.PortablePipelineResult;
import org.apache.beam.runners.jobsubmission.PortablePipelineRunner;
import org.apache.beam.runners.samza.SamzaPipelineOptions;
import org.apache.beam.runners.samza.SamzaRunner;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SamzaPipelineRunner
implements PortablePipelineRunner {
    private static final @UnknownKeyFor @NonNull @Initialized Logger LOG = LoggerFactory.getLogger(SamzaPipelineRunner.class);
    private final @UnknownKeyFor @NonNull @Initialized SamzaPipelineOptions options;

    public @UnknownKeyFor @NonNull @Initialized PortablePipelineResult run(// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized RunnerApi.Pipeline pipeline, @UnknownKeyFor @NonNull @Initialized JobInfo jobInfo) {
        RunnerApi.Pipeline pipelineWithSdfExpanded = ProtoOverrides.updateTransform((String)"beam:transform:pardo:v1", (RunnerApi.Pipeline)pipeline, (ProtoOverrides.TransformReplacement)SplittableParDoExpander.createSizedReplacement());
        RunnerApi.Pipeline fusedPipeline = GreedyPipelineFuser.fuse((RunnerApi.Pipeline)pipelineWithSdfExpanded).toPipeline();
        LOG.info("Portable pipeline to run:");
        LOG.info(PipelineDotRenderer.toDotString((RunnerApi.Pipeline)fusedPipeline));
        this.options.setRunner(SamzaRunner.class);
        try {
            SamzaRunner runner = SamzaRunner.fromOptions(this.options);
            return runner.runPortablePipeline(fusedPipeline);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to invoke samza job", e);
        }
    }

    public SamzaPipelineRunner(@UnknownKeyFor @NonNull @Initialized SamzaPipelineOptions options) {
        this.options = options;
    }
}

