/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.samza.runtime;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.List;
import org.apache.beam.runners.core.StateNamespace;
import org.apache.beam.runners.core.StateNamespaces;
import org.apache.beam.runners.core.TimerInternals;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.CoderException;
import org.apache.beam.sdk.coders.InstantCoder;
import org.apache.beam.sdk.coders.StringUtf8Coder;
import org.apache.beam.sdk.coders.StructuredCoder;
import org.apache.beam.sdk.state.TimeDomain;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.joda.time.Instant;

public class KeyedTimerData<K>
implements Comparable<KeyedTimerData<K>> {
    private final byte[] keyBytes;
    private final K key;
    private final TimerInternals.TimerData timerData;

    public KeyedTimerData(byte[] keyBytes, K key, TimerInternals.TimerData timerData) {
        this.keyBytes = keyBytes;
        this.key = key;
        this.timerData = timerData;
    }

    public K getKey() {
        return this.key;
    }

    public byte[] getKeyBytes() {
        return this.keyBytes;
    }

    public TimerInternals.TimerData getTimerData() {
        return this.timerData;
    }

    @Override
    public int compareTo(KeyedTimerData<K> other) {
        int timerCompare = this.getTimerData().compareTo(other.getTimerData());
        if (timerCompare != 0) {
            return timerCompare;
        }
        if (this.keyBytes == null) {
            return other.keyBytes == null ? 0 : -1;
        }
        if (other.keyBytes == null) {
            return 1;
        }
        if (this.keyBytes.length < other.keyBytes.length) {
            return -1;
        }
        if (this.keyBytes.length > other.keyBytes.length) {
            return 1;
        }
        for (int i = 0; i < this.keyBytes.length; ++i) {
            char b1 = (char)this.keyBytes[i];
            char b2 = (char)other.keyBytes[i];
            if (b1 == b2) continue;
            return b1 - b2;
        }
        return 0;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        KeyedTimerData that = (KeyedTimerData)o;
        return Arrays.equals(this.keyBytes, that.keyBytes) && this.timerData.equals(that.timerData);
    }

    public int hashCode() {
        int result = Arrays.hashCode(this.keyBytes);
        result = 31 * result + this.timerData.hashCode();
        return result;
    }

    public static class KeyedTimerDataCoder<K>
    extends StructuredCoder<KeyedTimerData<K>> {
        private static final StringUtf8Coder STRING_CODER = StringUtf8Coder.of();
        private static final InstantCoder INSTANT_CODER = InstantCoder.of();
        private final Coder<K> keyCoder;
        private final Coder<? extends BoundedWindow> windowCoder;

        KeyedTimerDataCoder(Coder<K> keyCoder, Coder<? extends BoundedWindow> windowCoder) {
            this.keyCoder = keyCoder;
            this.windowCoder = windowCoder;
        }

        public void encode(KeyedTimerData<K> value, OutputStream outStream) throws CoderException, IOException {
            TimerInternals.TimerData timer = value.getTimerData();
            INSTANT_CODER.encode(timer.getTimestamp(), outStream);
            STRING_CODER.encode(timer.getTimerId(), outStream);
            STRING_CODER.encode(timer.getNamespace().stringKey(), outStream);
            STRING_CODER.encode(timer.getDomain().name(), outStream);
            if (this.keyCoder != null) {
                this.keyCoder.encode(((KeyedTimerData)value).key, outStream);
            }
        }

        public KeyedTimerData<K> decode(InputStream inStream) throws CoderException, IOException {
            Instant timestamp = INSTANT_CODER.decode(inStream);
            String timerId = STRING_CODER.decode(inStream);
            StateNamespace namespace = StateNamespaces.fromString((String)STRING_CODER.decode(inStream), this.windowCoder);
            TimeDomain domain = TimeDomain.valueOf((String)STRING_CODER.decode(inStream));
            TimerInternals.TimerData timer = TimerInternals.TimerData.of((String)timerId, (StateNamespace)namespace, (Instant)timestamp, (Instant)timestamp, (TimeDomain)domain);
            byte[] keyBytes = null;
            Object key = null;
            if (this.keyCoder != null) {
                key = this.keyCoder.decode(inStream);
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                try {
                    this.keyCoder.encode(key, (OutputStream)baos);
                }
                catch (IOException e) {
                    throw new RuntimeException("Could not encode key: " + key, e);
                }
                keyBytes = baos.toByteArray();
            }
            return new KeyedTimerData<Object>(keyBytes, key, timer);
        }

        public List<? extends Coder<?>> getCoderArguments() {
            return Arrays.asList(this.keyCoder, this.windowCoder);
        }

        public void verifyDeterministic() throws Coder.NonDeterministicException {
        }
    }
}

