/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.samza.runtime;

import org.apache.beam.sdk.util.WindowedValue;
import org.joda.time.Instant;

public class OpMessage<T> {
    private final Type type;
    private final WindowedValue<T> element;
    private final String viewId;
    private final WindowedValue<? extends Iterable<?>> viewElements;
    private final Instant sideInputWatermark;

    public static <T> OpMessage<T> ofElement(WindowedValue<T> element) {
        return new OpMessage<T>(Type.ELEMENT, element, null, null, null);
    }

    public static <T, ElemT> OpMessage<T> ofSideInput(String viewId, WindowedValue<? extends Iterable<ElemT>> elements) {
        return new OpMessage<T>(Type.SIDE_INPUT, null, viewId, elements, null);
    }

    public static <T, ElemT> OpMessage<T> ofSideInputWatermark(Instant watermark) {
        return new OpMessage<T>(Type.SIDE_INPUT_WATERMARK, null, null, null, watermark);
    }

    private OpMessage(Type type, WindowedValue<T> element, String viewId, WindowedValue<? extends Iterable<?>> viewElements, Instant sideInputWatermark) {
        this.type = type;
        this.element = element;
        this.viewId = viewId;
        this.viewElements = viewElements;
        this.sideInputWatermark = sideInputWatermark;
    }

    public Type getType() {
        return this.type;
    }

    public WindowedValue<T> getElement() {
        this.ensureType(Type.ELEMENT, "getElement");
        return this.element;
    }

    public String getViewId() {
        this.ensureType(Type.SIDE_INPUT, "getViewId");
        return this.viewId;
    }

    public WindowedValue<? extends Iterable<?>> getViewElements() {
        this.ensureType(Type.SIDE_INPUT, "getViewElements");
        return this.viewElements;
    }

    public Instant getSideInputWatermark() {
        return this.sideInputWatermark;
    }

    private void ensureType(Type type, String method) {
        if (this.type != type) {
            throw new IllegalStateException(String.format("Calling %s requires type %s, but was type %s", new Object[]{method, type, this.type}));
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OpMessage opMessage = (OpMessage)o;
        if (this.type != opMessage.type) {
            return false;
        }
        if (this.element != null ? !this.element.equals(opMessage.element) : opMessage.element != null) {
            return false;
        }
        if (this.viewId != null ? !this.viewId.equals(opMessage.viewId) : opMessage.viewId != null) {
            return false;
        }
        return this.viewElements != null ? this.viewElements.equals(opMessage.viewElements) : opMessage.viewElements == null;
    }

    public int hashCode() {
        int result = this.type.hashCode();
        result = 31 * result + (this.element != null ? this.element.hashCode() : 0);
        result = 31 * result + (this.viewId != null ? this.viewId.hashCode() : 0);
        result = 31 * result + (this.viewElements != null ? this.viewElements.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "OpMessage{type=" + (Object)((Object)this.type) + ", element=" + this.element + ", viewId='" + this.viewId + '\'' + ", viewElements=" + this.viewElements + '}';
    }

    public static enum Type {
        ELEMENT,
        SIDE_INPUT,
        SIDE_INPUT_WATERMARK;

    }
}

