/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.samza.metrics;

import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import org.apache.beam.runners.core.metrics.MetricsContainerStepMap;
import org.apache.beam.sdk.metrics.GaugeResult;
import org.apache.beam.sdk.metrics.MetricQueryResults;
import org.apache.beam.sdk.metrics.MetricResult;
import org.apache.beam.sdk.metrics.MetricResults;
import org.apache.beam.sdk.metrics.MetricsContainer;
import org.apache.samza.metrics.Counter;
import org.apache.samza.metrics.Gauge;
import org.apache.samza.metrics.Metric;
import org.apache.samza.metrics.MetricsRegistryMap;

public class SamzaMetricsContainer {
    private static final String BEAM_METRICS_GROUP = "BeamMetrics";
    private static final String DELIMITER = "-";
    private final MetricsContainerStepMap metricsContainers = new MetricsContainerStepMap();
    private final MetricsRegistryMap metricsRegistry;

    public SamzaMetricsContainer(MetricsRegistryMap metricsRegistry) {
        this.metricsRegistry = metricsRegistry;
        this.metricsRegistry.metrics().put(BEAM_METRICS_GROUP, new ConcurrentHashMap());
    }

    public MetricsContainer getContainer(String stepName) {
        return this.metricsContainers.getContainer(stepName);
    }

    public MetricsContainerStepMap getContainers() {
        return this.metricsContainers;
    }

    public void updateMetrics() {
        assert (this.metricsRegistry != null);
        MetricResults metricResults = MetricsContainerStepMap.asAttemptedOnlyMetricResults((MetricsContainerStepMap)this.metricsContainers);
        MetricQueryResults results = metricResults.allMetrics();
        CounterUpdater updateCounter = new CounterUpdater();
        results.getCounters().forEach(updateCounter);
        GaugeUpdater updateGauge = new GaugeUpdater();
        results.getGauges().forEach(updateGauge);
    }

    private Metric getSamzaMetricFor(String metricName) {
        return (Metric)this.metricsRegistry.getGroup(BEAM_METRICS_GROUP).get(metricName);
    }

    private static String getMetricName(MetricResult<?> metricResult) {
        return metricResult.getKey().toString();
    }

    private class GaugeUpdater
    implements Consumer<MetricResult<GaugeResult>> {
        private GaugeUpdater() {
        }

        @Override
        public void accept(MetricResult<GaugeResult> metricResult) {
            String metricName = SamzaMetricsContainer.getMetricName(metricResult);
            Gauge gauge = (Gauge)SamzaMetricsContainer.this.getSamzaMetricFor(metricName);
            if (gauge == null) {
                gauge = SamzaMetricsContainer.this.metricsRegistry.newGauge(SamzaMetricsContainer.BEAM_METRICS_GROUP, metricName, (Object)0L);
            }
            gauge.set((Object)((GaugeResult)metricResult.getAttempted()).getValue());
        }
    }

    private class CounterUpdater
    implements Consumer<MetricResult<Long>> {
        private CounterUpdater() {
        }

        @Override
        public void accept(MetricResult<Long> metricResult) {
            String metricName = SamzaMetricsContainer.getMetricName(metricResult);
            Counter counter = (Counter)SamzaMetricsContainer.this.getSamzaMetricFor(metricName);
            if (counter == null) {
                counter = SamzaMetricsContainer.this.metricsRegistry.newCounter(SamzaMetricsContainer.BEAM_METRICS_GROUP, metricName);
            }
            counter.dec(counter.getCount());
            counter.inc(((Long)metricResult.getAttempted()).longValue());
        }
    }
}

