/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.samza.runtime;

import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.transforms.windowing.WindowFn;
import org.apache.beam.sdk.util.WindowedValue;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Iterables;
import org.joda.time.Instant;

class SamzaAssignContext<InT, W extends BoundedWindow>
extends WindowFn.AssignContext {
    private final WindowedValue<InT> value;

    public SamzaAssignContext(WindowFn<InT, W> fn, WindowedValue<InT> value) {
        super(fn);
        this.value = value;
        if (value.getWindows().size() != 1) {
            throw new IllegalArgumentException(String.format("Only single windowed value allowed for assignment. Windows: %s", value.getWindows()));
        }
    }

    public InT element() {
        return (InT)this.value.getValue();
    }

    public Instant timestamp() {
        return this.value.getTimestamp();
    }

    public BoundedWindow window() {
        return (BoundedWindow)Iterables.getOnlyElement((Iterable)this.value.getWindows());
    }
}

