/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.dataflow;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.api.client.googleapis.json.GoogleJsonResponseException;
import com.google.api.services.dataflow.model.DataflowPackage;
import com.google.api.services.dataflow.model.Job;
import com.google.api.services.dataflow.model.ListJobsResponse;
import com.google.api.services.dataflow.model.SdkHarnessContainerImage;
import com.google.api.services.dataflow.model.WorkerPool;
import com.google.auto.service.AutoService;
import com.google.auto.value.AutoValue;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.beam.model.pipeline.v1.RunnerApi;
import org.apache.beam.runners.dataflow.AutoValue_DataflowRunner_EnvironmentInfo;
import org.apache.beam.runners.dataflow.BatchStatefulParDoOverrides;
import org.apache.beam.runners.dataflow.BatchViewOverrides;
import org.apache.beam.runners.dataflow.CreateDataflowView;
import org.apache.beam.runners.dataflow.DataflowClient;
import org.apache.beam.runners.dataflow.DataflowJobAlreadyExistsException;
import org.apache.beam.runners.dataflow.DataflowJobAlreadyUpdatedException;
import org.apache.beam.runners.dataflow.DataflowPTransformMatchers;
import org.apache.beam.runners.dataflow.DataflowPipelineJob;
import org.apache.beam.runners.dataflow.DataflowPipelineTranslator;
import org.apache.beam.runners.dataflow.DataflowRunnerHooks;
import org.apache.beam.runners.dataflow.DataflowRunnerInfo;
import org.apache.beam.runners.dataflow.GroupIntoBatchesOverride;
import org.apache.beam.runners.dataflow.PrimitiveParDoSingleFactory;
import org.apache.beam.runners.dataflow.ReadTranslator;
import org.apache.beam.runners.dataflow.RedistributeByKeyOverrideFactory;
import org.apache.beam.runners.dataflow.ReshuffleOverrideFactory;
import org.apache.beam.runners.dataflow.SplittableParDoOverrides;
import org.apache.beam.runners.dataflow.StreamingViewOverrides;
import org.apache.beam.runners.dataflow.TransformTranslator;
import org.apache.beam.runners.dataflow.options.DataflowPipelineDebugOptions;
import org.apache.beam.runners.dataflow.options.DataflowPipelineOptions;
import org.apache.beam.runners.dataflow.options.DataflowPipelineWorkerPoolOptions;
import org.apache.beam.runners.dataflow.options.DataflowStreamingPipelineOptions;
import org.apache.beam.runners.dataflow.util.DataflowTemplateJob;
import org.apache.beam.runners.dataflow.util.MonitoringUtil;
import org.apache.beam.runners.dataflow.util.PackageUtil;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.PipelineResult;
import org.apache.beam.sdk.PipelineRunner;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.KvCoder;
import org.apache.beam.sdk.coders.VoidCoder;
import org.apache.beam.sdk.extensions.gcp.options.GcpOptions;
import org.apache.beam.sdk.extensions.gcp.storage.PathValidator;
import org.apache.beam.sdk.io.BoundedSource;
import org.apache.beam.sdk.io.FileBasedSink;
import org.apache.beam.sdk.io.FileSystems;
import org.apache.beam.sdk.io.Read;
import org.apache.beam.sdk.io.UnboundedSource;
import org.apache.beam.sdk.io.WriteFiles;
import org.apache.beam.sdk.io.WriteFilesResult;
import org.apache.beam.sdk.io.fs.ResolveOptions;
import org.apache.beam.sdk.io.fs.ResourceId;
import org.apache.beam.sdk.io.gcp.bigquery.StorageApiLoads;
import org.apache.beam.sdk.io.gcp.bigquery.StreamingWriteTables;
import org.apache.beam.sdk.io.gcp.pubsub.PubsubMessage;
import org.apache.beam.sdk.io.gcp.pubsub.PubsubMessageWithAttributesAndMessageIdCoder;
import org.apache.beam.sdk.io.gcp.pubsub.PubsubMessageWithAttributesCoder;
import org.apache.beam.sdk.io.gcp.pubsub.PubsubUnboundedSink;
import org.apache.beam.sdk.io.gcp.pubsub.PubsubUnboundedSource;
import org.apache.beam.sdk.io.gcp.pubsublite.internal.SubscribeTransform;
import org.apache.beam.sdk.io.kafka.KafkaIO;
import org.apache.beam.sdk.options.ExperimentalOptions;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.options.PipelineOptionsValidator;
import org.apache.beam.sdk.options.SdkHarnessOptions;
import org.apache.beam.sdk.options.ValueProvider;
import org.apache.beam.sdk.runners.AppliedPTransform;
import org.apache.beam.sdk.runners.PTransformMatcher;
import org.apache.beam.sdk.runners.PTransformOverride;
import org.apache.beam.sdk.runners.PTransformOverrideFactory;
import org.apache.beam.sdk.state.MapState;
import org.apache.beam.sdk.state.MultimapState;
import org.apache.beam.sdk.state.SetState;
import org.apache.beam.sdk.transforms.Combine;
import org.apache.beam.sdk.transforms.Create;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.GroupIntoBatches;
import org.apache.beam.sdk.transforms.Impulse;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.transforms.Redistribute;
import org.apache.beam.sdk.transforms.Reshuffle;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.transforms.SimpleFunction;
import org.apache.beam.sdk.transforms.View;
import org.apache.beam.sdk.transforms.WithKeys;
import org.apache.beam.sdk.transforms.reflect.DoFnSignatures;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.transforms.windowing.GlobalWindow;
import org.apache.beam.sdk.util.CoderUtils;
import org.apache.beam.sdk.util.InstanceBuilder;
import org.apache.beam.sdk.util.NameUtils;
import org.apache.beam.sdk.util.ReleaseInfo;
import org.apache.beam.sdk.util.SerializableUtils;
import org.apache.beam.sdk.util.StringUtils;
import org.apache.beam.sdk.util.common.ReflectHelpers;
import org.apache.beam.sdk.util.construction.BeamUrns;
import org.apache.beam.sdk.util.construction.DeduplicatedFlattenFactory;
import org.apache.beam.sdk.util.construction.EmptyFlattenAsCreateFactory;
import org.apache.beam.sdk.util.construction.Environments;
import org.apache.beam.sdk.util.construction.External;
import org.apache.beam.sdk.util.construction.ExternalTranslationOptions;
import org.apache.beam.sdk.util.construction.PTransformMatchers;
import org.apache.beam.sdk.util.construction.PTransformReplacements;
import org.apache.beam.sdk.util.construction.PTransformTranslation;
import org.apache.beam.sdk.util.construction.PipelineTranslation;
import org.apache.beam.sdk.util.construction.ReplacementOutputs;
import org.apache.beam.sdk.util.construction.SdkComponents;
import org.apache.beam.sdk.util.construction.SingleInputOutputOverrideFactory;
import org.apache.beam.sdk.util.construction.SplittableParDo;
import org.apache.beam.sdk.util.construction.SplittableParDoNaiveBounded;
import org.apache.beam.sdk.util.construction.TransformPayloadTranslatorRegistrar;
import org.apache.beam.sdk.util.construction.UnboundedReadFromBoundedSource;
import org.apache.beam.sdk.util.construction.UnconsumedReads;
import org.apache.beam.sdk.util.construction.WriteFilesTranslation;
import org.apache.beam.sdk.util.construction.graph.ProjectionPushdownOptimizer;
import org.apache.beam.sdk.util.construction.resources.PipelineResources;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.PBegin;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PCollectionView;
import org.apache.beam.sdk.values.PDone;
import org.apache.beam.sdk.values.PInput;
import org.apache.beam.sdk.values.PValue;
import org.apache.beam.sdk.values.TupleTag;
import org.apache.beam.sdk.values.TypeDescriptors;
import org.apache.beam.sdk.values.ValueWithRecordId;
import org.apache.beam.sdk.values.WindowedValues;
import org.apache.beam.sdk.values.WindowingStrategy;
import org.apache.beam.vendor.grpc.v1p69p0.com.google.protobuf.ByteString;
import org.apache.beam.vendor.grpc.v1p69p0.com.google.protobuf.InvalidProtocolBufferException;
import org.apache.beam.vendor.grpc.v1p69p0.com.google.protobuf.MessageOrBuilder;
import org.apache.beam.vendor.grpc.v1p69p0.com.google.protobuf.ProtocolMessageEnum;
import org.apache.beam.vendor.grpc.v1p69p0.com.google.protobuf.TextFormat;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.annotations.VisibleForTesting;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Joiner;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.MoreObjects;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Strings;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.ImmutableList;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.ImmutableMap;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.Iterables;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.Maps;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.hash.HashCode;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.hash.Hashing;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.io.ByteStreams;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.io.Files;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.KeyForBottom;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.dataflow.qual.SideEffectFree;
import org.joda.time.DateTimeUtils;
import org.joda.time.DateTimeZone;
import org.joda.time.format.DateTimeFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataflowRunner
extends PipelineRunner<DataflowPipelineJob> {
    public static final @UnknownKeyFor @NonNull @Initialized String UNSAFELY_ATTEMPT_TO_PROCESS_UNBOUNDED_DATA_IN_BATCH_MODE = "unsafely_attempt_to_process_unbounded_data_in_batch_mode";
    private static final @UnknownKeyFor @NonNull @Initialized Logger LOG = LoggerFactory.getLogger(DataflowRunner.class);
    private final @UnknownKeyFor @NonNull @Initialized DataflowPipelineOptions options;
    private final @UnknownKeyFor @NonNull @Initialized DataflowClient dataflowClient;
    private final @UnknownKeyFor @NonNull @Initialized DataflowPipelineTranslator translator;
    private @UnknownKeyFor @NonNull @Initialized DataflowRunnerHooks hooks;
    private static final @UnknownKeyFor @NonNull @Initialized int CREATE_JOB_REQUEST_LIMIT_BYTES = 0xA00000;
    @VisibleForTesting
    static final @UnknownKeyFor @NonNull @Initialized int GCS_UPLOAD_BUFFER_SIZE_BYTES_DEFAULT = 0x100000;
    @VisibleForTesting
    static final @UnknownKeyFor @NonNull @Initialized String PIPELINE_FILE_NAME = "pipeline.pb";
    @VisibleForTesting
    static final @UnknownKeyFor @NonNull @Initialized String DATAFLOW_GRAPH_FILE_NAME = "dataflow_graph.json";
    private static final @UnknownKeyFor @NonNull @Initialized ObjectMapper MAPPER = new ObjectMapper();
    private static final @UnknownKeyFor @NonNull @Initialized ObjectMapper MAPPER_WITH_MODULES = new ObjectMapper().registerModules((Iterable)ObjectMapper.findModules((ClassLoader)ReflectHelpers.findClassLoader()));
    private final /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Set<@UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> pcollectionsRequiringIndexedFormat;
    private final /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Set<@UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> pCollectionsPreservedKeys;
    private final /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Set<@UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> pcollectionsRequiringAutoSharding;
    public static final @UnknownKeyFor @NonNull @Initialized String PROJECT_ID_REGEXP = "[a-z][-a-z0-9:.]+[a-z0-9]";
    static final @UnknownKeyFor @NonNull @Initialized String ENDPOINT_REGEXP = "https://[\\S]*googleapis\\.com[/]?";
    private static final @UnknownKeyFor @NonNull @Initialized Random RANDOM = new Random();
    private /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Set<@UnknownKeyFor @NonNull @Initialized PTransform<@UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?>> ptransformViewsWithNonDeterministicKeyCoders;

    public static @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> replaceGcsFilesWithLocalFiles(@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> filesToStage) {
        ArrayList<String> processedFiles = new ArrayList<String>();
        for (String fileToStage : filesToStage) {
            String localPath;
            if (fileToStage.contains("=")) {
                String[] components = fileToStage.split("=", 2);
                String stagingName = components[0];
                String filePath = components[1];
                if (filePath.startsWith("gs://")) {
                    try {
                        String gcsFileName = filePath.substring(filePath.lastIndexOf(47) + 1);
                        File tempDir = Files.createTempDir();
                        tempDir.deleteOnExit();
                        File tempFile = new File(tempDir, gcsFileName);
                        tempFile.deleteOnExit();
                        LOG.info("Downloading GCS file {} to local temp file {}", (Object)filePath, (Object)tempFile.getAbsolutePath());
                        ResourceId source = FileSystems.matchNewResource((String)filePath, (boolean)false);
                        try (ReadableByteChannel reader = FileSystems.open((ResourceId)source);
                             FileOutputStream writer = new FileOutputStream(tempFile);){
                            ByteStreams.copy((InputStream)Channels.newInputStream(reader), (OutputStream)writer);
                        }
                        localPath = stagingName + "=" + tempFile.getAbsolutePath();
                        LOG.info("Replaced GCS path {} with local path {}", (Object)fileToStage, (Object)localPath);
                    }
                    catch (IOException e) {
                        throw new RuntimeException("Failed to copy GCS file locally: " + filePath, e);
                    }
                }
                localPath = fileToStage;
            } else {
                if (fileToStage.startsWith("gs://")) {
                    try {
                        String gcsFileName = fileToStage.substring(fileToStage.lastIndexOf(47) + 1);
                        File tempDir = Files.createTempDir();
                        tempDir.deleteOnExit();
                        File tempFile = new File(tempDir, gcsFileName);
                        tempFile.deleteOnExit();
                        LOG.info("Downloading GCS file {} to local temp file {}", (Object)fileToStage, (Object)tempFile.getAbsolutePath());
                        ResourceId source = FileSystems.matchNewResource((String)fileToStage, (boolean)false);
                        try (ReadableByteChannel reader = FileSystems.open((ResourceId)source);
                             FileOutputStream writer = new FileOutputStream(tempFile);){
                            ByteStreams.copy((InputStream)Channels.newInputStream(reader), (OutputStream)writer);
                        }
                        localPath = tempFile.getAbsolutePath();
                        LOG.info("Replaced GCS path {} with local path {}", (Object)fileToStage, (Object)localPath);
                    }
                    catch (IOException e) {
                        throw new RuntimeException("Failed to copy GCS file locally: " + fileToStage, e);
                    }
                }
                localPath = fileToStage;
            }
            processedFiles.add(localPath);
        }
        return processedFiles;
    }

    public static @UnknownKeyFor @NonNull @Initialized DataflowRunner fromOptions(@UnknownKeyFor @NonNull @Initialized PipelineOptions options) {
        String stagingLocation;
        String gcpTempLocation;
        DataflowPipelineOptions dataflowOptions = (DataflowPipelineOptions)PipelineOptionsValidator.validate(DataflowPipelineOptions.class, (PipelineOptions)options);
        ArrayList<String> missing = new ArrayList<String>();
        if (dataflowOptions.getAppName() == null) {
            missing.add("appName");
        }
        if (Strings.isNullOrEmpty((String)dataflowOptions.getRegion()) && DataflowRunner.isServiceEndpoint(dataflowOptions.getDataflowEndpoint())) {
            missing.add("region");
        }
        if (missing.size() > 0) {
            throw new IllegalArgumentException("Missing required pipeline options: " + Joiner.on((char)',').join(missing));
        }
        DataflowRunner.validateWorkerSettings((DataflowPipelineWorkerPoolOptions)PipelineOptionsValidator.validate(DataflowPipelineWorkerPoolOptions.class, (PipelineOptions)options));
        PathValidator validator = dataflowOptions.getPathValidator();
        try {
            gcpTempLocation = dataflowOptions.getGcpTempLocation();
        }
        catch (Exception e) {
            throw new IllegalArgumentException("DataflowRunner requires gcpTempLocation, but failed to retrieve a value from PipelineOptions", e);
        }
        validator.validateOutputFilePrefixSupported(gcpTempLocation);
        try {
            stagingLocation = dataflowOptions.getStagingLocation();
        }
        catch (Exception e) {
            throw new IllegalArgumentException("DataflowRunner requires stagingLocation, but failed to retrieve a value from PipelineOptions", e);
        }
        validator.validateOutputFilePrefixSupported(stagingLocation);
        if (!Strings.isNullOrEmpty((String)dataflowOptions.getSaveProfilesToGcs())) {
            validator.validateOutputFilePrefixSupported(dataflowOptions.getSaveProfilesToGcs());
        }
        if (dataflowOptions.getFilesToStage() != null) {
            dataflowOptions.setFilesToStage(DataflowRunner.replaceGcsFilesWithLocalFiles(dataflowOptions.getFilesToStage()));
            dataflowOptions.getFilesToStage().stream().forEach(stagedFileSpec -> {
                File localFile;
                if (stagedFileSpec.contains("=")) {
                    String[] components = stagedFileSpec.split("=", 2);
                    localFile = new File(components[1]);
                } else {
                    localFile = new File((String)stagedFileSpec);
                }
                if (!localFile.exists()) {
                    throw new RuntimeException(String.format("Non-existent files specified in filesToStage: %s", localFile));
                }
            });
        } else {
            dataflowOptions.setFilesToStage(PipelineResources.detectClassPathResourcesToStage((ClassLoader)DataflowRunner.class.getClassLoader(), (PipelineOptions)options));
            if (dataflowOptions.getFilesToStage().isEmpty()) {
                throw new IllegalArgumentException("No files to stage has been found.");
            }
            LOG.info("PipelineOptions.filesToStage was not specified. Defaulting to files from the classpath: will stage {} files. Enable logging at DEBUG level to see which files will be staged.", (Object)dataflowOptions.getFilesToStage().size());
            LOG.debug("Classpath elements: {}", (Object)dataflowOptions.getFilesToStage());
        }
        String jobName = dataflowOptions.getJobName().toLowerCase();
        Preconditions.checkArgument((boolean)jobName.matches("[a-z]([-a-z0-9]*[a-z0-9])?"), (Object)"JobName invalid; the name must consist of only the characters [-a-z0-9], starting with a letter and ending with a letter or number");
        if (!jobName.equals(dataflowOptions.getJobName())) {
            LOG.info("PipelineOptions.jobName did not match the service requirements. Using {} instead of {}.", (Object)jobName, (Object)dataflowOptions.getJobName());
        }
        dataflowOptions.setJobName(jobName);
        String project = dataflowOptions.getProject();
        if (project.matches("[0-9]*")) {
            throw new IllegalArgumentException("Project ID '" + project + "' invalid. Please make sure you specified the Project ID, not project number.");
        }
        if (!project.matches(PROJECT_ID_REGEXP)) {
            throw new IllegalArgumentException("Project ID '" + project + "' invalid. Please make sure you specified the Project ID, not project description.");
        }
        DataflowPipelineDebugOptions debugOptions = (DataflowPipelineDebugOptions)dataflowOptions.as(DataflowPipelineDebugOptions.class);
        if (debugOptions.getNumberOfWorkerHarnessThreads() < 0) {
            throw new IllegalArgumentException("Number of worker harness threads '" + debugOptions.getNumberOfWorkerHarnessThreads() + "' invalid. Please make sure the value is non-negative.");
        }
        if (dataflowOptions.isStreaming() && dataflowOptions.getGcsUploadBufferSizeBytes() == null) {
            dataflowOptions.setGcsUploadBufferSizeBytes(0x100000);
        }
        String agentJavaVer = String.format("(JRE %s environment)", Environments.getJavaVersion().specification());
        DataflowRunnerInfo dataflowRunnerInfo = DataflowRunnerInfo.getDataflowRunnerInfo();
        String userAgentName = dataflowRunnerInfo.getName();
        Preconditions.checkArgument((!userAgentName.equals("") ? 1 : 0) != 0, (Object)"Dataflow runner's `name` property cannot be empty.");
        String userAgentVersion = dataflowRunnerInfo.getVersion();
        Preconditions.checkArgument((!userAgentVersion.equals("") ? 1 : 0) != 0, (Object)"Dataflow runner's `version` property cannot be empty.");
        String userAgent = String.format("%s/%s%s", userAgentName, userAgentVersion, agentJavaVer).replace(" ", "_");
        dataflowOptions.setUserAgent(userAgent);
        return new DataflowRunner(dataflowOptions);
    }

    static @UnknownKeyFor @NonNull @Initialized boolean isServiceEndpoint(@UnknownKeyFor @NonNull @Initialized String endpoint) {
        return Strings.isNullOrEmpty((String)endpoint) || Pattern.matches(ENDPOINT_REGEXP, endpoint);
    }

    static void validateSdkContainerImageOptions(@UnknownKeyFor @NonNull @Initialized DataflowPipelineWorkerPoolOptions workerOptions) {
        String sdkContainerOption = workerOptions.getSdkContainerImage();
        String workerHarnessOption = workerOptions.getWorkerHarnessContainerImage();
        Preconditions.checkArgument((sdkContainerOption == null || workerHarnessOption == null || sdkContainerOption.equals(workerHarnessOption) ? 1 : 0) != 0, (Object)"Cannot use legacy option workerHarnessContainerImage with sdkContainerImage. Prefer sdkContainerImage.");
        String containerImage = workerOptions.getSdkContainerImage();
        if (workerOptions.getWorkerHarnessContainerImage() != null && workerOptions.getSdkContainerImage() == null) {
            LOG.warn("Prefer --sdkContainerImage over deprecated legacy option --workerHarnessContainerImage.");
            containerImage = workerOptions.getWorkerHarnessContainerImage();
        }
        workerOptions.setSdkContainerImage(containerImage);
        workerOptions.setWorkerHarnessContainerImage(containerImage);
    }

    @VisibleForTesting
    static void validateWorkerSettings(@UnknownKeyFor @NonNull @Initialized DataflowPipelineWorkerPoolOptions workerOptions) {
        DataflowPipelineOptions dataflowOptions = (DataflowPipelineOptions)workerOptions.as(DataflowPipelineOptions.class);
        DataflowRunner.validateSdkContainerImageOptions(workerOptions);
        GcpOptions gcpOptions = (GcpOptions)workerOptions.as(GcpOptions.class);
        Preconditions.checkArgument((gcpOptions.getZone() == null || gcpOptions.getWorkerRegion() == null ? 1 : 0) != 0, (Object)"Cannot use option zone with workerRegion. Prefer either workerZone or workerRegion.");
        Preconditions.checkArgument((gcpOptions.getZone() == null || gcpOptions.getWorkerZone() == null ? 1 : 0) != 0, (Object)"Cannot use option zone with workerZone. Prefer workerZone.");
        Preconditions.checkArgument((gcpOptions.getWorkerRegion() == null || gcpOptions.getWorkerZone() == null ? 1 : 0) != 0, (Object)"workerRegion and workerZone options are mutually exclusive.");
        boolean hasExperimentWorkerRegion = false;
        if (dataflowOptions.getExperiments() != null) {
            for (String experiment : dataflowOptions.getExperiments()) {
                if (!experiment.startsWith("worker_region")) continue;
                hasExperimentWorkerRegion = true;
                break;
            }
        }
        Preconditions.checkArgument((!hasExperimentWorkerRegion || gcpOptions.getWorkerRegion() == null ? 1 : 0) != 0, (Object)"Experiment worker_region and option workerRegion are mutually exclusive.");
        Preconditions.checkArgument((!hasExperimentWorkerRegion || gcpOptions.getWorkerZone() == null ? 1 : 0) != 0, (Object)"Experiment worker_region and option workerZone are mutually exclusive.");
        if (gcpOptions.getZone() != null) {
            LOG.warn("Option --zone is deprecated. Please use --workerZone instead.");
            gcpOptions.setWorkerZone(gcpOptions.getZone());
            gcpOptions.setZone(null);
        }
    }

    @VisibleForTesting
    protected DataflowRunner(@UnknownKeyFor @NonNull @Initialized DataflowPipelineOptions options) {
        this.options = options;
        this.dataflowClient = DataflowClient.create(options);
        this.translator = DataflowPipelineTranslator.fromOptions(options);
        this.pcollectionsRequiringIndexedFormat = new HashSet();
        this.pCollectionsPreservedKeys = new HashSet();
        this.pcollectionsRequiringAutoSharding = new HashSet();
        this.ptransformViewsWithNonDeterministicKeyCoders = new HashSet();
    }

    private @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized PTransformOverride> getOverrides(@UnknownKeyFor @NonNull @Initialized boolean streaming) {
        ImmutableList.Builder overridesBuilder = ImmutableList.builder();
        overridesBuilder.add((Object)PTransformOverride.of((PTransformMatcher)PTransformMatchers.flattenWithDuplicateInputs(), (PTransformOverrideFactory)DeduplicatedFlattenFactory.create())).add((Object)PTransformOverride.of((PTransformMatcher)PTransformMatchers.emptyFlatten(), (PTransformOverrideFactory)EmptyFlattenAsCreateFactory.instance()));
        if (streaming) {
            overridesBuilder.add((Object)PTransformOverride.of((PTransformMatcher)PTransformMatchers.classEqualTo(Create.Values.class), new AlwaysCreateViaRead()));
        }
        overridesBuilder.add((Object)PTransformOverride.of((PTransformMatcher)PTransformMatchers.splittableParDoSingle(), new ReflectiveOneToOneOverrideFactory(SplittableParDoOverrides.ParDoSingleViaMulti.class, this))).add((Object)PTransformOverride.of((PTransformMatcher)PTransformMatchers.splittableParDoMulti(), new SplittableParDoOverrides.SplittableParDoOverrideFactory()));
        if (streaming) {
            if (!DataflowRunner.hasExperiment(this.options, "enable_custom_pubsub_source")) {
                overridesBuilder.add((Object)PTransformOverride.of((PTransformMatcher)PTransformMatchers.classEqualTo(PubsubUnboundedSource.class), (PTransformOverrideFactory)new StreamingPubsubIOReadOverrideFactory()));
            }
            if (!DataflowRunner.hasExperiment(this.options, "enable_custom_pubsub_sink")) {
                overridesBuilder.add((Object)PTransformOverride.of((PTransformMatcher)PTransformMatchers.classEqualTo(PubsubUnboundedSink.class), (PTransformOverrideFactory)new StreamingPubsubIOWriteOverrideFactory(this)));
            }
            try {
                overridesBuilder.add((Object)KafkaIO.Read.KAFKA_READ_OVERRIDE);
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
                // empty catch block
            }
            overridesBuilder.add((Object)SubscribeTransform.V1_READ_OVERRIDE);
            if (!DataflowRunner.hasExperiment(this.options, "enable_file_dynamic_sharding")) {
                overridesBuilder.add((Object)PTransformOverride.of((PTransformMatcher)PTransformMatchers.writeWithRunnerDeterminedSharding(), new StreamingShardedWriteFactory(this.options)));
            }
            overridesBuilder.add((Object)PTransformOverride.of((PTransformMatcher)PTransformMatchers.groupIntoBatches(), new GroupIntoBatchesOverride.StreamingGroupIntoBatchesOverrideFactory(this)));
            overridesBuilder.add((Object)PTransformOverride.of((PTransformMatcher)PTransformMatchers.groupWithShardableStates(), new GroupIntoBatchesOverride.StreamingGroupIntoBatchesWithShardedKeyOverrideFactory(this)));
            overridesBuilder.add((Object)PTransformOverride.of((PTransformMatcher)PTransformMatchers.classEqualTo(Read.Bounded.class), new StreamingBoundedReadOverrideFactory())).add((Object)PTransformOverride.of((PTransformMatcher)PTransformMatchers.classEqualTo(Read.Unbounded.class), new StreamingUnboundedReadOverrideFactory()));
            overridesBuilder.add((Object)PTransformOverride.of((PTransformMatcher)PTransformMatchers.classEqualTo(View.CreatePCollectionView.class), new StreamingViewOverrides.StreamingCreatePCollectionViewFactory()));
        } else {
            overridesBuilder.add((Object)SplittableParDo.PRIMITIVE_BOUNDED_READ_OVERRIDE);
            overridesBuilder.add((Object)PTransformOverride.of((PTransformMatcher)PTransformMatchers.classEqualTo(GroupIntoBatches.class), new GroupIntoBatchesOverride.BatchGroupIntoBatchesOverrideFactory(this))).add((Object)PTransformOverride.of((PTransformMatcher)PTransformMatchers.classEqualTo(GroupIntoBatches.WithShardedKey.class), new GroupIntoBatchesOverride.BatchGroupIntoBatchesWithShardedKeyOverrideFactory(this)));
            overridesBuilder.add((Object)PTransformOverride.of((PTransformMatcher)PTransformMatchers.stateOrTimerParDoMulti(), BatchStatefulParDoOverrides.multiOutputOverrideFactory(this.options))).add((Object)PTransformOverride.of((PTransformMatcher)PTransformMatchers.stateOrTimerParDoSingle(), BatchStatefulParDoOverrides.singleOutputOverrideFactory()));
            overridesBuilder.add((Object)PTransformOverride.of((PTransformMatcher)PTransformMatchers.splittableProcessKeyedBounded(), (PTransformOverrideFactory)new SplittableParDoNaiveBounded.OverrideFactory()));
            overridesBuilder.add((Object)PTransformOverride.of((PTransformMatcher)PTransformMatchers.classEqualTo(View.AsMap.class), new ReflectiveViewOverrideFactory(BatchViewOverrides.BatchViewAsMap.class, this))).add((Object)PTransformOverride.of((PTransformMatcher)PTransformMatchers.classEqualTo(View.AsMultimap.class), new ReflectiveViewOverrideFactory(BatchViewOverrides.BatchViewAsMultimap.class, this))).add((Object)PTransformOverride.of((PTransformMatcher)PTransformMatchers.classEqualTo(Combine.GloballyAsSingletonView.class), new CombineGloballyAsSingletonViewOverrideFactory(this))).add((Object)PTransformOverride.of((PTransformMatcher)PTransformMatchers.classEqualTo(View.AsList.class), new ReflectiveViewOverrideFactory(BatchViewOverrides.BatchViewAsList.class, this))).add((Object)PTransformOverride.of((PTransformMatcher)PTransformMatchers.classEqualTo(View.AsIterable.class), new ReflectiveViewOverrideFactory(BatchViewOverrides.BatchViewAsIterable.class, this)));
        }
        overridesBuilder.add((Object)PTransformOverride.of((PTransformMatcher)PTransformMatchers.classEqualTo(Reshuffle.class), new ReshuffleOverrideFactory())).add((Object)PTransformOverride.of((PTransformMatcher)new DataflowPTransformMatchers.CombineValuesWithoutSideInputsPTransformMatcher(), new PrimitiveCombineGroupedValuesOverrideFactory())).add((Object)PTransformOverride.of((PTransformMatcher)PTransformMatchers.classEqualTo(ParDo.SingleOutput.class), new PrimitiveParDoSingleFactory()));
        boolean usesAtLeastOnceStreamingMode = this.options.getDataflowServiceOptions() != null && this.options.getDataflowServiceOptions().contains("streaming_mode_at_least_once");
        overridesBuilder.add((Object)PTransformOverride.of((PTransformMatcher)PTransformMatchers.classEqualTo(Redistribute.RedistributeByKey.class), new RedistributeByKeyOverrideFactory(usesAtLeastOnceStreamingMode)));
        if (streaming) {
            overridesBuilder.add((Object)PTransformOverride.of((PTransformMatcher)PTransformMatchers.classEqualTo(Create.Values.class), new AlwaysCreateViaRead())).add((Object)PTransformOverride.of((PTransformMatcher)PTransformMatchers.classEqualTo(Read.Bounded.class), new StreamingBoundedReadOverrideFactory())).add((Object)PTransformOverride.of((PTransformMatcher)PTransformMatchers.classEqualTo(Read.Unbounded.class), new StreamingUnboundedReadOverrideFactory())).add((Object)PTransformOverride.of((PTransformMatcher)PTransformMatchers.classEqualTo(ParDo.SingleOutput.class), new PrimitiveParDoSingleFactory()));
        }
        return overridesBuilder.build();
    }

    private // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized RunnerApi.Pipeline resolveAnyOfEnvironments(// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized RunnerApi.Pipeline pipeline) {
        RunnerApi.Pipeline.Builder pipelineBuilder = pipeline.toBuilder();
        RunnerApi.Components.Builder componentsBuilder = pipelineBuilder.getComponentsBuilder();
        componentsBuilder.clearEnvironments();
        for (Map.Entry entry : pipeline.getComponents().getEnvironmentsMap().entrySet()) {
            componentsBuilder.putEnvironments((String)entry.getKey(), Environments.resolveAnyOfEnvironment((RunnerApi.Environment)((RunnerApi.Environment)entry.getValue()), (String[])new String[]{BeamUrns.getUrn((ProtocolMessageEnum)RunnerApi.StandardEnvironments.Environments.DOCKER)}));
        }
        return pipelineBuilder.build();
    }

    protected // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized RunnerApi.Pipeline applySdkEnvironmentOverrides(// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized RunnerApi.Pipeline pipeline, @UnknownKeyFor @NonNull @Initialized DataflowPipelineOptions options) {
        String[] overrides;
        String sdkHarnessContainerImageOverrides = options.getSdkHarnessContainerImageOverrides();
        String[] stringArray = overrides = Strings.isNullOrEmpty((String)sdkHarnessContainerImageOverrides) ? new String[]{} : sdkHarnessContainerImageOverrides.split(",", -1);
        if (overrides.length % 2 != 0) {
            throw new RuntimeException("invalid syntax for SdkHarnessContainerImageOverrides: " + options.getSdkHarnessContainerImageOverrides());
        }
        RunnerApi.Pipeline.Builder pipelineBuilder = pipeline.toBuilder();
        RunnerApi.Components.Builder componentsBuilder = pipelineBuilder.getComponentsBuilder();
        componentsBuilder.clearEnvironments();
        for (Map.Entry entry : pipeline.getComponents().getEnvironmentsMap().entrySet()) {
            RunnerApi.Environment.Builder environmentBuilder = ((RunnerApi.Environment)entry.getValue()).toBuilder();
            if (BeamUrns.getUrn((ProtocolMessageEnum)RunnerApi.StandardEnvironments.Environments.DOCKER).equals(environmentBuilder.getUrn())) {
                RunnerApi.DockerPayload dockerPayload;
                try {
                    dockerPayload = RunnerApi.DockerPayload.parseFrom((ByteString)environmentBuilder.getPayload());
                }
                catch (InvalidProtocolBufferException e) {
                    throw new RuntimeException("Error parsing environment docker payload.", e);
                }
                String containerImage = dockerPayload.getContainerImage();
                boolean updated = false;
                for (int i = 0; i < overrides.length; i += 2) {
                    if ((containerImage = containerImage.replaceAll(overrides[i], overrides[i + 1])).equals(dockerPayload.getContainerImage())) continue;
                    updated = true;
                }
                if (containerImage.startsWith("apache/beam") && !updated && !containerImage.equals(DataflowRunner.getContainerImageForJob(options))) {
                    containerImage = DataflowRunnerInfo.getDataflowRunnerInfo().getContainerImageBaseRepository() + containerImage.substring(containerImage.lastIndexOf("/"));
                }
                environmentBuilder.setPayload(RunnerApi.DockerPayload.newBuilder().setContainerImage(containerImage).build().toByteString());
            }
            componentsBuilder.putEnvironments((String)entry.getKey(), environmentBuilder.build());
        }
        return pipelineBuilder.build();
    }

    @VisibleForTesting
    protected // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized RunnerApi.Pipeline resolveArtifacts(// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized RunnerApi.Pipeline pipeline) {
        RunnerApi.Pipeline.Builder pipelineBuilder = pipeline.toBuilder();
        RunnerApi.Components.Builder componentsBuilder = pipelineBuilder.getComponentsBuilder();
        componentsBuilder.clearEnvironments();
        for (Map.Entry entry : pipeline.getComponents().getEnvironmentsMap().entrySet()) {
            RunnerApi.Environment.Builder environmentBuilder = ((RunnerApi.Environment)entry.getValue()).toBuilder();
            environmentBuilder.clearDependencies();
            for (RunnerApi.ArtifactInformation info : ((RunnerApi.Environment)entry.getValue()).getDependenciesList()) {
                String stagedName;
                RunnerApi.ArtifactFilePayload filePayload;
                if (!BeamUrns.getUrn((ProtocolMessageEnum)RunnerApi.StandardArtifacts.Types.FILE).equals(info.getTypeUrn())) {
                    throw new RuntimeException(String.format("unsupported artifact type %s", info.getTypeUrn()));
                }
                try {
                    filePayload = RunnerApi.ArtifactFilePayload.parseFrom((ByteString)info.getTypePayload());
                }
                catch (InvalidProtocolBufferException e) {
                    throw new RuntimeException("Error parsing artifact file payload.", e);
                }
                if (BeamUrns.getUrn((ProtocolMessageEnum)RunnerApi.StandardArtifacts.Roles.STAGING_TO).equals(info.getRoleUrn())) {
                    try {
                        RunnerApi.ArtifactStagingToRolePayload stagingPayload = RunnerApi.ArtifactStagingToRolePayload.parseFrom((ByteString)info.getRolePayload());
                        stagedName = stagingPayload.getStagedName();
                    }
                    catch (InvalidProtocolBufferException e) {
                        throw new RuntimeException("Error parsing artifact staging_to role payload.", e);
                    }
                }
                try {
                    File source = new File(filePayload.getPath());
                    HashCode hashCode = Files.asByteSource((File)source).hash(Hashing.sha256());
                    stagedName = Environments.createStagingFileName((File)source, (HashCode)hashCode);
                }
                catch (IOException e) {
                    throw new RuntimeException(String.format("Error creating staged name for artifact %s", filePayload.getPath()), e);
                }
                environmentBuilder.addDependencies(info.toBuilder().setTypeUrn(BeamUrns.getUrn((ProtocolMessageEnum)RunnerApi.StandardArtifacts.Types.URL)).setTypePayload(RunnerApi.ArtifactUrlPayload.newBuilder().setUrl(FileSystems.matchNewResource((String)this.options.getStagingLocation(), (boolean)true).resolve(stagedName, (ResolveOptions)ResolveOptions.StandardResolveOptions.RESOLVE_FILE).toString()).setSha256(filePayload.getSha256()).build().toByteString()));
            }
            componentsBuilder.putEnvironments((String)entry.getKey(), environmentBuilder.build());
        }
        return pipelineBuilder.build();
    }

    protected @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized DataflowPackage> stageArtifacts(// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized RunnerApi.Pipeline pipeline) {
        ImmutableList.Builder filesToStageBuilder = ImmutableList.builder();
        HashSet<String> stagedNames = new HashSet<String>();
        for (Map.Entry entry : pipeline.getComponents().getEnvironmentsMap().entrySet()) {
            for (RunnerApi.ArtifactInformation info : ((RunnerApi.Environment)entry.getValue()).getDependenciesList()) {
                String stagedName;
                RunnerApi.ArtifactFilePayload filePayload;
                if (!BeamUrns.getUrn((ProtocolMessageEnum)RunnerApi.StandardArtifacts.Types.FILE).equals(info.getTypeUrn())) {
                    throw new RuntimeException(String.format("unsupported artifact type %s", info.getTypeUrn()));
                }
                try {
                    filePayload = RunnerApi.ArtifactFilePayload.parseFrom((ByteString)info.getTypePayload());
                }
                catch (InvalidProtocolBufferException e) {
                    throw new RuntimeException("Error parsing artifact file payload.", e);
                }
                if (BeamUrns.getUrn((ProtocolMessageEnum)RunnerApi.StandardArtifacts.Roles.STAGING_TO).equals(info.getRoleUrn())) {
                    try {
                        RunnerApi.ArtifactStagingToRolePayload stagingPayload = RunnerApi.ArtifactStagingToRolePayload.parseFrom((ByteString)info.getRolePayload());
                        stagedName = stagingPayload.getStagedName();
                    }
                    catch (InvalidProtocolBufferException e) {
                        throw new RuntimeException("Error parsing artifact staging_to role payload.", e);
                    }
                }
                try {
                    File source = new File(filePayload.getPath());
                    HashCode hashCode = Files.asByteSource((File)source).hash(Hashing.sha256());
                    stagedName = Environments.createStagingFileName((File)source, (HashCode)hashCode);
                }
                catch (IOException e) {
                    throw new RuntimeException(String.format("Error creating staged name for artifact %s", filePayload.getPath()), e);
                }
                if (stagedNames.contains(stagedName)) continue;
                stagedNames.add(stagedName);
                filesToStageBuilder.add((Object)PackageUtil.StagedFile.of(filePayload.getPath(), filePayload.getSha256(), stagedName));
            }
        }
        return this.options.getStager().stageFiles((List<PackageUtil.StagedFile>)filesToStageBuilder.build());
    }

    private @UnknownKeyFor @NonNull @Initialized List<// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized RunnerApi.ArtifactInformation> getDefaultArtifacts() {
        ImmutableList.Builder pathsToStageBuilder = ImmutableList.builder();
        String windmillBinary = ((DataflowStreamingPipelineOptions)this.options.as(DataflowStreamingPipelineOptions.class)).getOverrideWindmillBinary();
        String dataflowWorkerJar = this.options.getDataflowWorkerJar();
        if (dataflowWorkerJar != null && !dataflowWorkerJar.isEmpty() && !DataflowRunner.useUnifiedWorker(this.options)) {
            pathsToStageBuilder.add((Object)("dataflow-worker.jar=" + dataflowWorkerJar));
        }
        pathsToStageBuilder.addAll((Iterable)this.options.getFilesToStage());
        if (windmillBinary != null) {
            pathsToStageBuilder.add((Object)("windmill_main=" + windmillBinary));
        }
        return Environments.getArtifacts((List)pathsToStageBuilder.build());
    }

    @VisibleForTesting
    static @UnknownKeyFor @NonNull @Initialized boolean isMultiLanguagePipeline(@UnknownKeyFor @NonNull @Initialized Pipeline pipeline) {
        class IsMultiLanguageVisitor
        extends Pipeline.PipelineVisitor.Defaults {
            private @UnknownKeyFor @NonNull @Initialized boolean isMultiLanguage = false;

            IsMultiLanguageVisitor() {
            }

            private void performMultiLanguageTest(// Could not load outer class - annotation placement on inner may be incorrect
             @UnknownKeyFor @NonNull @Initialized TransformHierarchy. @UnknownKeyFor @NonNull @Initialized Node node) {
                if (node.getTransform() instanceof External.ExpandableTransform) {
                    this.isMultiLanguage = true;
                }
            }

            public // Could not load outer class - annotation placement on inner may be incorrect
            @UnknownKeyFor @NonNull @Initialized Pipeline.PipelineVisitor.CompositeBehavior enterCompositeTransform(// Could not load outer class - annotation placement on inner may be incorrect
             @UnknownKeyFor @NonNull @Initialized TransformHierarchy. @UnknownKeyFor @NonNull @Initialized Node node) {
                this.performMultiLanguageTest(node);
                return super.enterCompositeTransform(node);
            }

            public void visitPrimitiveTransform(// Could not load outer class - annotation placement on inner may be incorrect
             @UnknownKeyFor @NonNull @Initialized TransformHierarchy. @UnknownKeyFor @NonNull @Initialized Node node) {
                this.performMultiLanguageTest(node);
                super.visitPrimitiveTransform(node);
            }
        }
        IsMultiLanguageVisitor visitor = new IsMultiLanguageVisitor();
        pipeline.traverseTopologically((Pipeline.PipelineVisitor)visitor);
        return visitor.isMultiLanguage;
    }

    private static @UnknownKeyFor @NonNull @Initialized boolean includesTransformUpgrades(@UnknownKeyFor @NonNull @Initialized Pipeline pipeline) {
        return ((ExternalTranslationOptions)pipeline.getOptions().as(ExternalTranslationOptions.class)).getTransformsToOverride().size() > 0;
    }

    public @UnknownKeyFor @NonNull @Initialized DataflowPipelineJob run(@UnknownKeyFor @NonNull @Initialized Pipeline pipeline) {
        Job jobResult;
        ArrayList experiments;
        byte[] jobGraphBytes;
        int jobGraphByteSize;
        List experiments2;
        ArrayList<String> experiments3;
        if ((DataflowRunner.isMultiLanguagePipeline(pipeline) || DataflowRunner.includesTransformUpgrades(pipeline)) && !(experiments3 = (ArrayList<String>)MoreObjects.firstNonNull((Object)this.options.getExperiments(), Collections.emptyList())).contains("use_runner_v2")) {
            LOG.info("Automatically enabling Dataflow Runner v2 since the pipeline used cross-language transforms or pipeline needed a transform upgrade.");
            this.options.setExperiments((List)ImmutableList.builder().addAll((Iterable)experiments3).add((Object)"use_runner_v2").build());
        }
        if (DataflowRunner.useUnifiedWorker(this.options)) {
            if (DataflowRunner.hasExperiment(this.options, "disable_runner_v2") || DataflowRunner.hasExperiment(this.options, "disable_runner_v2_until_2023") || DataflowRunner.hasExperiment(this.options, "disable_prime_runner_v2")) {
                throw new IllegalArgumentException("Runner V2 both disabled and enabled: at least one of ['beam_fn_api', 'use_unified_worker', 'use_runner_v2', 'use_portable_job_submission'] is set and also one of ['disable_runner_v2', 'disable_runner_v2_until_2023', 'disable_prime_runner_v2'] is set.");
            }
            experiments3 = new ArrayList<String>(this.options.getExperiments());
            if (!experiments3.contains("use_runner_v2")) {
                experiments3.add("use_runner_v2");
            }
            if (!experiments3.contains("use_unified_worker")) {
                experiments3.add("use_unified_worker");
            }
            if (!experiments3.contains("beam_fn_api")) {
                experiments3.add("beam_fn_api");
            }
            if (!experiments3.contains("use_portable_job_submission")) {
                experiments3.add("use_portable_job_submission");
            }
            this.options.setExperiments((List)ImmutableList.copyOf(experiments3));
            ((SdkHarnessOptions)this.options.as(SdkHarnessOptions.class)).setEnableLogViaFnApi(true);
        }
        this.logWarningIfPCollectionViewHasNonDeterministicKeyCoder(pipeline);
        this.logWarningIfBigqueryDLQUnused(pipeline);
        if (this.shouldActAsStreaming(pipeline)) {
            this.options.setStreaming(true);
            if (DataflowRunner.useUnifiedWorker(this.options)) {
                this.options.setEnableStreamingEngine(true);
                experiments3 = new ArrayList(this.options.getExperiments());
                if (!experiments3.contains("enable_streaming_engine")) {
                    experiments3.add("enable_streaming_engine");
                }
                if (!experiments3.contains("enable_windmill_service")) {
                    experiments3.add("enable_windmill_service");
                }
            }
        }
        if (!ExperimentalOptions.hasExperiment((PipelineOptions)this.options, (String)"disable_projection_pushdown")) {
            ProjectionPushdownOptimizer.optimize((Pipeline)pipeline);
        }
        LOG.info("Executing pipeline on the Dataflow Service, which will have billing implications related to Google Compute Engine usage and other Google Cloud Services.");
        DataflowPipelineOptions dataflowOptions = (DataflowPipelineOptions)this.options.as(DataflowPipelineOptions.class);
        String workerHarnessContainerImageURL = DataflowRunner.getContainerImageForJob(dataflowOptions);
        RunnerApi.Environment defaultEnvironmentForDataflow = Environments.createDockerEnvironment((String)workerHarnessContainerImageURL);
        SdkComponents portableComponents = SdkComponents.create();
        portableComponents.registerEnvironment(defaultEnvironmentForDataflow.toBuilder().addAllDependencies(this.getDefaultArtifacts()).addAllCapabilities((Iterable)Environments.getJavaCapabilities()).build());
        RunnerApi.Pipeline portablePipelineProto = PipelineTranslation.toProto((Pipeline)pipeline, (SdkComponents)portableComponents, (boolean)false);
        portablePipelineProto = this.resolveAnyOfEnvironments(portablePipelineProto);
        List<DataflowPackage> packages = this.stageArtifacts(portablePipelineProto);
        portablePipelineProto = this.resolveArtifacts(portablePipelineProto);
        portablePipelineProto = this.applySdkEnvironmentOverrides(portablePipelineProto, this.options);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Portable pipeline proto:\n{}", (Object)TextFormat.printer().printToString((MessageOrBuilder)portablePipelineProto));
        }
        LOG.info("Staging portable pipeline proto to {}", (Object)this.options.getStagingLocation());
        byte[] serializedProtoPipeline = portablePipelineProto.toByteArray();
        DataflowPackage stagedPipeline = this.options.getStager().stageToFile(serializedProtoPipeline, PIPELINE_FILE_NAME);
        dataflowOptions.setPipelineUrl(stagedPipeline.getLocation());
        if (DataflowRunner.useUnifiedWorker(this.options)) {
            LOG.info("Skipping v1 transform replacements since job will run on v2.");
        } else {
            this.replaceV1Transforms(pipeline);
        }
        SdkComponents dataflowV1Components = SdkComponents.create();
        dataflowV1Components.registerEnvironment(defaultEnvironmentForDataflow.toBuilder().addAllDependencies(this.getDefaultArtifacts()).addAllCapabilities((Iterable)Environments.getJavaCapabilities()).build());
        RunnerApi.Pipeline dataflowV1PipelineProto = PipelineTranslation.toProto((Pipeline)pipeline, (SdkComponents)dataflowV1Components, (boolean)true, (boolean)false);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Dataflow v1 pipeline proto:\n{}", (Object)TextFormat.printer().printToString((MessageOrBuilder)dataflowV1PipelineProto));
        }
        int randomNum = RANDOM.nextInt(9000) + 1000;
        String requestId = DateTimeFormat.forPattern((String)"YYYYMMddHHmmssmmm").withZone(DateTimeZone.UTC).print(DateTimeUtils.currentTimeMillis()) + "_" + randomNum;
        DataflowPipelineTranslator.JobSpecification jobSpecification = this.translator.translate(pipeline, dataflowV1PipelineProto, dataflowV1Components, this, packages);
        if (!(Strings.isNullOrEmpty((String)dataflowOptions.getDataflowWorkerJar()) || DataflowRunner.useUnifiedWorker(this.options) || (experiments2 = (List)MoreObjects.firstNonNull((Object)dataflowOptions.getExperiments(), Collections.emptyList())).contains("use_staged_dataflow_worker_jar"))) {
            dataflowOptions.setExperiments((List)ImmutableList.builder().addAll((Iterable)experiments2).add((Object)"use_staged_dataflow_worker_jar").build());
        }
        Job newJob = jobSpecification.getJob();
        try {
            newJob.getEnvironment().setSdkPipelineOptions((Map)MAPPER.readValue(MAPPER_WITH_MODULES.writeValueAsBytes((Object)this.options), Map.class));
        }
        catch (IOException e) {
            throw new IllegalArgumentException("PipelineOptions specified failed to serialize to JSON.", e);
        }
        newJob.setClientRequestId(requestId);
        DataflowRunnerInfo dataflowRunnerInfo = DataflowRunnerInfo.getDataflowRunnerInfo();
        String version = dataflowRunnerInfo.getVersion();
        Preconditions.checkState((!"${pom.version}".equals(version) ? 1 : 0) != 0, (Object)"Unable to submit a job to the Dataflow service with unset version ${pom.version}");
        LOG.info("Dataflow SDK version: {}", (Object)version);
        newJob.getEnvironment().setUserAgent(dataflowRunnerInfo.getProperties());
        if (!Strings.isNullOrEmpty((String)this.options.getGcpTempLocation())) {
            newJob.getEnvironment().setTempStoragePrefix(dataflowOptions.getPathValidator().verifyPath(this.options.getGcpTempLocation()));
        }
        newJob.getEnvironment().setDataset(this.options.getTempDatasetId());
        if (this.options.getWorkerRegion() != null) {
            newJob.getEnvironment().setWorkerRegion(this.options.getWorkerRegion());
        }
        if (this.options.getWorkerZone() != null) {
            newJob.getEnvironment().setWorkerZone(this.options.getWorkerZone());
        }
        if (this.options.getFlexRSGoal() == DataflowPipelineOptions.FlexResourceSchedulingGoal.COST_OPTIMIZED) {
            newJob.getEnvironment().setFlexResourceSchedulingGoal("FLEXRS_COST_OPTIMIZED");
        } else if (this.options.getFlexRSGoal() == DataflowPipelineOptions.FlexResourceSchedulingGoal.SPEED_OPTIMIZED) {
            newJob.getEnvironment().setFlexResourceSchedulingGoal("FLEXRS_SPEED_OPTIMIZED");
        }
        if (!Strings.isNullOrEmpty((String)dataflowOptions.getMinCpuPlatform())) {
            List experiments4 = (List)MoreObjects.firstNonNull((Object)dataflowOptions.getExperiments(), Collections.emptyList());
            List minCpuFlags = experiments4.stream().filter(p -> p.startsWith("min_cpu_platform")).collect(Collectors.toList());
            if (minCpuFlags.isEmpty()) {
                dataflowOptions.setExperiments((List)ImmutableList.builder().addAll((Iterable)experiments4).add((Object)("min_cpu_platform=" + dataflowOptions.getMinCpuPlatform())).build());
            } else {
                LOG.warn("Flag min_cpu_platform is defined in both top level PipelineOption, as well as under experiments. Proceed using {}.", minCpuFlags.get(0));
            }
        }
        newJob.getEnvironment().setExperiments((List)ImmutableList.copyOf((Collection)((Collection)MoreObjects.firstNonNull((Object)dataflowOptions.getExperiments(), Collections.emptyList()))));
        String containerImage = DataflowRunner.getContainerImageForJob(this.options);
        for (WorkerPool workerPool : newJob.getEnvironment().getWorkerPools()) {
            workerPool.setWorkerHarnessContainerImage(containerImage);
        }
        DataflowRunner.configureSdkHarnessContainerImages(this.options, portablePipelineProto, newJob);
        newJob.getEnvironment().setVersion(DataflowRunner.getEnvironmentVersion(this.options));
        if (this.hooks != null) {
            this.hooks.modifyEnvironmentBeforeSubmission(newJob.getEnvironment());
        }
        if ((jobGraphByteSize = (jobGraphBytes = DataflowPipelineTranslator.jobToString(newJob).getBytes(StandardCharsets.UTF_8)).length) >= 0xA00000 && !DataflowRunner.hasExperiment(this.options, "upload_graph") && !DataflowRunner.useUnifiedWorker(this.options)) {
            experiments = (ArrayList)MoreObjects.firstNonNull((Object)this.options.getExperiments(), Collections.emptyList());
            this.options.setExperiments((List)ImmutableList.builder().addAll(experiments).add((Object)"upload_graph").build());
            LOG.info("The job graph size ({} in bytes) is larger than {}. Automatically add the upload_graph option to experiments.", (Object)jobGraphByteSize, (Object)0xA00000);
        }
        if (DataflowRunner.hasExperiment(this.options, "upload_graph") && DataflowRunner.useUnifiedWorker(this.options)) {
            experiments = new ArrayList(this.options.getExperiments());
            while (experiments.remove("upload_graph")) {
            }
            this.options.setExperiments(experiments);
            LOG.warn("The upload_graph experiment was specified, but it does not apply to runner v2 jobs. Option has been automatically removed.");
        }
        if (DataflowRunner.hasExperiment(this.options, "upload_graph")) {
            DataflowPackage stagedGraph = this.options.getStager().stageToFile(jobGraphBytes, DATAFLOW_GRAPH_FILE_NAME);
            newJob.getSteps().clear();
            newJob.setStepsLocation(stagedGraph.getLocation());
        }
        if (!Strings.isNullOrEmpty((String)this.options.getDataflowJobFile()) || !Strings.isNullOrEmpty((String)this.options.getTemplateLocation())) {
            String fileLocation;
            boolean isTemplate;
            boolean bl = isTemplate = !Strings.isNullOrEmpty((String)this.options.getTemplateLocation());
            if (isTemplate) {
                Preconditions.checkArgument((boolean)Strings.isNullOrEmpty((String)this.options.getDataflowJobFile()), (Object)"--dataflowJobFile and --templateLocation are mutually exclusive.");
            }
            Preconditions.checkArgument(((fileLocation = (String)MoreObjects.firstNonNull((Object)this.options.getTemplateLocation(), (Object)this.options.getDataflowJobFile())).startsWith("/") || fileLocation.startsWith("gs://") ? 1 : 0) != 0, (String)"Location must be local or on Cloud Storage, got %s.", (Object)fileLocation);
            try {
                DataflowRunner.printWorkSpecJsonToFile(fileLocation, newJob);
                LOG.info("Printed job specification to {}", (Object)fileLocation);
            }
            catch (IOException ex) {
                String error = String.format("Cannot create output file at %s", fileLocation);
                if (isTemplate) {
                    throw new RuntimeException(error, ex);
                }
                LOG.warn(error, (Throwable)ex);
            }
            if (isTemplate) {
                LOG.info("Template successfully created.");
                return new DataflowTemplateJob();
            }
        }
        String jobIdToUpdate = null;
        if (this.options.isUpdate()) {
            jobIdToUpdate = this.getJobIdFromName(this.options.getJobName());
            newJob.setTransformNameMapping(this.options.getTransformNameMapping());
            newJob.setReplaceJobId(jobIdToUpdate);
        }
        if (this.options.getCreateFromSnapshot() != null && !this.options.getCreateFromSnapshot().isEmpty()) {
            newJob.setTransformNameMapping(this.options.getTransformNameMapping());
            newJob.setCreatedFromSnapshotId(this.options.getCreateFromSnapshot());
        }
        try {
            jobResult = this.dataflowClient.createJob(newJob);
        }
        catch (GoogleJsonResponseException e) {
            String errorMessages = "Unexpected errors";
            if (e.getDetails() != null) {
                errorMessages = jobGraphByteSize >= 0xA00000 ? "The size of the serialized JSON representation of the pipeline exceeds the allowable limit. For more information, please see the documentation on job submission:\nhttps://cloud.google.com/dataflow/docs/guides/deploying-a-pipeline#jobs" : e.getDetails().getMessage();
            }
            throw new RuntimeException("Failed to create a workflow job: " + errorMessages, e);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to create a workflow job", e);
        }
        DataflowPipelineJob dataflowPipelineJob = new DataflowPipelineJob(DataflowClient.create(this.options), jobResult.getId(), this.options, jobSpecification != null ? jobSpecification.getStepNames() : Collections.emptyMap(), portablePipelineProto);
        if (jobResult.getClientRequestId() != null && !jobResult.getClientRequestId().isEmpty() && !jobResult.getClientRequestId().equals(requestId)) {
            if (this.options.isUpdate()) {
                throw new DataflowJobAlreadyUpdatedException(dataflowPipelineJob, String.format("The job named %s with id: %s has already been updated into job id: %s and cannot be updated again.", newJob.getName(), jobIdToUpdate, jobResult.getId()));
            }
            throw new DataflowJobAlreadyExistsException(dataflowPipelineJob, String.format("There is already an active job named %s with id: %s. If you want to submit a second job, try again by setting a different name using --jobName.", newJob.getName(), jobResult.getId()));
        }
        LOG.info("To access the Dataflow monitoring console, please navigate to {}", (Object)MonitoringUtil.getJobMonitoringPageURL(this.options.getProject(), this.options.getRegion(), jobResult.getId()));
        LOG.info("Submitted job: {}", (Object)jobResult.getId());
        LOG.info("To cancel the job using the 'gcloud' tool, run:\n> {}", (Object)MonitoringUtil.getGcloudCancelCommand(this.options, jobResult.getId()));
        return dataflowPipelineJob;
    }

    private static void printWorkSpecJsonToFile(@UnknownKeyFor @NonNull @Initialized String fileLocation, @UnknownKeyFor @NonNull @Initialized Job job) throws @UnknownKeyFor @NonNull @Initialized IOException {
        String workSpecJson = DataflowPipelineTranslator.jobToString(job);
        ResourceId fileResource = FileSystems.matchNewResource((String)fileLocation, (boolean)false);
        try (OutputStreamWriter writer = new OutputStreamWriter(Channels.newOutputStream(FileSystems.create((ResourceId)fileResource, (String)"text/plain")), StandardCharsets.UTF_8);){
            writer.write(workSpecJson);
        }
    }

    private static @UnknownKeyFor @NonNull @Initialized EnvironmentInfo getEnvironmentInfoFromEnvironmentId(@UnknownKeyFor @NonNull @Initialized String environmentId, // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized RunnerApi.Pipeline pipelineProto) {
        RunnerApi.DockerPayload dockerPayload;
        RunnerApi.Environment environment = (RunnerApi.Environment)pipelineProto.getComponents().getEnvironmentsMap().get(environmentId);
        if (!BeamUrns.getUrn((ProtocolMessageEnum)RunnerApi.StandardEnvironments.Environments.DOCKER).equals(environment.getUrn())) {
            throw new RuntimeException("Dataflow can only execute pipeline steps in Docker environments: " + environment.getUrn());
        }
        try {
            dockerPayload = RunnerApi.DockerPayload.parseFrom((ByteString)environment.getPayload());
        }
        catch (InvalidProtocolBufferException e) {
            throw new RuntimeException("Error parsing docker payload.", e);
        }
        return EnvironmentInfo.create(environmentId, dockerPayload.getContainerImage(), (List<String>)environment.getCapabilitiesList());
    }

    private static @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized EnvironmentInfo> getAllEnvironmentInfo(// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized RunnerApi.Pipeline pipelineProto) {
        return pipelineProto.getComponents().getTransformsMap().values().stream().map(transform -> transform.getEnvironmentId()).filter(environmentId -> !environmentId.isEmpty()).distinct().map(environmentId -> DataflowRunner.getEnvironmentInfoFromEnvironmentId(environmentId, pipelineProto)).collect(Collectors.toList());
    }

    static void configureSdkHarnessContainerImages(@UnknownKeyFor @NonNull @Initialized DataflowPipelineOptions options, // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized RunnerApi.Pipeline pipelineProto, @UnknownKeyFor @NonNull @Initialized Job newJob) {
        List sdkContainerList = DataflowRunner.getAllEnvironmentInfo(pipelineProto).stream().map(environmentInfo -> {
            SdkHarnessContainerImage image = new SdkHarnessContainerImage();
            image.setEnvironmentId(environmentInfo.environmentId());
            image.setContainerImage(environmentInfo.containerUrl());
            if (!environmentInfo.capabilities().contains(BeamUrns.getUrn((ProtocolMessageEnum)RunnerApi.StandardProtocols.Enum.MULTI_CORE_BUNDLE_PROCESSING))) {
                image.setUseSingleCorePerContainer(Boolean.valueOf(true));
            }
            image.setCapabilities(environmentInfo.capabilities());
            return image;
        }).collect(Collectors.toList());
        for (WorkerPool workerPool : newJob.getEnvironment().getWorkerPools()) {
            workerPool.setSdkHarnessContainerImages(sdkContainerList);
        }
    }

    public static @UnknownKeyFor @NonNull @Initialized boolean hasExperiment(@UnknownKeyFor @NonNull @Initialized DataflowPipelineDebugOptions options, @UnknownKeyFor @NonNull @Initialized String experiment) {
        List experiments = (List)MoreObjects.firstNonNull((Object)options.getExperiments(), Collections.emptyList());
        return experiments.contains(experiment);
    }

    private static @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Object> getEnvironmentVersion(@UnknownKeyFor @NonNull @Initialized DataflowPipelineOptions options) {
        String jobType;
        String majorVersion;
        DataflowRunnerInfo runnerInfo = DataflowRunnerInfo.getDataflowRunnerInfo();
        if (DataflowRunner.useUnifiedWorker(options)) {
            majorVersion = runnerInfo.getFnApiEnvironmentMajorVersion();
            jobType = options.isStreaming() ? "FNAPI_STREAMING" : "FNAPI_BATCH";
        } else {
            majorVersion = runnerInfo.getLegacyEnvironmentMajorVersion();
            jobType = options.isStreaming() ? "STREAMING" : "JAVA_BATCH_AUTOSCALING";
        }
        return ImmutableMap.of((Object)"major", (Object)majorVersion, (Object)"job_type", (Object)jobType);
    }

    @VisibleForTesting
    protected void replaceV1Transforms(@UnknownKeyFor @NonNull @Initialized Pipeline pipeline) {
        boolean streaming = this.shouldActAsStreaming(pipeline);
        UnconsumedReads.ensureAllReadsConsumed((Pipeline)pipeline);
        pipeline.replaceAll(this.getOverrides(streaming));
    }

    private @UnknownKeyFor @NonNull @Initialized boolean shouldActAsStreaming(@UnknownKeyFor @NonNull @Initialized Pipeline p) {
        class BoundednessVisitor
        extends Pipeline.PipelineVisitor.Defaults {
            final @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized PCollection> unboundedPCollections = new ArrayList<PCollection>();

            BoundednessVisitor() {
            }

            public void visitValue(@UnknownKeyFor @NonNull @Initialized PValue value, // Could not load outer class - annotation placement on inner may be incorrect
             @UnknownKeyFor @NonNull @Initialized TransformHierarchy. @UnknownKeyFor @NonNull @Initialized Node producer) {
                PCollection pc;
                if (value instanceof PCollection && (pc = (PCollection)value).isBounded() == PCollection.IsBounded.UNBOUNDED) {
                    this.unboundedPCollections.add(pc);
                }
            }
        }
        BoundednessVisitor visitor = new BoundednessVisitor();
        p.traverseTopologically((Pipeline.PipelineVisitor)visitor);
        if (visitor.unboundedPCollections.isEmpty()) {
            if (this.options.isStreaming()) {
                LOG.warn("No unbounded PCollection(s) found in a streaming pipeline! You might consider using 'streaming=false'!");
                return true;
            }
            return false;
        }
        if (this.options.isStreaming()) {
            return true;
        }
        if (DataflowRunner.hasExperiment(this.options, UNSAFELY_ATTEMPT_TO_PROCESS_UNBOUNDED_DATA_IN_BATCH_MODE)) {
            LOG.info("Turning a batch pipeline into streaming due to unbounded PCollection(s) has been avoided! Unbounded PCollection(s): {}", visitor.unboundedPCollections);
            return false;
        }
        LOG.warn("Unbounded PCollection(s) found in a batch pipeline! You might consider using 'streaming=true'! Unbounded PCollection(s): {}", visitor.unboundedPCollections);
        return true;
    }

    public @UnknownKeyFor @NonNull @Initialized DataflowPipelineTranslator getTranslator() {
        return this.translator;
    }

    public void setHooks(@UnknownKeyFor @NonNull @Initialized DataflowRunnerHooks hooks) {
        this.hooks = hooks;
    }

    private void logWarningIfBigqueryDLQUnused(@UnknownKeyFor @NonNull @Initialized Pipeline pipeline) {
        final HashMap unconsumedDLQ = Maps.newHashMap();
        pipeline.traverseTopologically((Pipeline.PipelineVisitor)new Pipeline.PipelineVisitor.Defaults(){

            public // Could not load outer class - annotation placement on inner may be incorrect
            @UnknownKeyFor @NonNull @Initialized Pipeline.PipelineVisitor.CompositeBehavior enterCompositeTransform(// Could not load outer class - annotation placement on inner may be incorrect
             @UnknownKeyFor @NonNull @Initialized TransformHierarchy. @UnknownKeyFor @NonNull @Initialized Node node) {
                PTransform transform = node.getTransform();
                if (transform != null) {
                    PCollection dlq;
                    TupleTag failedTag = null;
                    String rootBigQueryTransform = "";
                    if (transform.getClass().equals(StorageApiLoads.class)) {
                        StorageApiLoads storageLoads = (StorageApiLoads)transform;
                        if (!storageLoads.usesErrorHandler()) {
                            failedTag = storageLoads.getFailedRowsTag();
                        }
                        rootBigQueryTransform = node.getEnclosingNode().getFullName();
                    } else if (transform.getClass().equals(StreamingWriteTables.class)) {
                        StreamingWriteTables streamingInserts = (StreamingWriteTables)transform;
                        failedTag = streamingInserts.getFailedRowsTupleTag();
                        rootBigQueryTransform = node.getEnclosingNode().getEnclosingNode().getFullName();
                    }
                    if (failedTag != null && (dlq = (PCollection)node.getOutputs().get(failedTag)) != null) {
                        unconsumedDLQ.put(dlq, rootBigQueryTransform);
                    }
                }
                for (PCollection input : node.getInputs().values()) {
                    unconsumedDLQ.remove(input);
                }
                return Pipeline.PipelineVisitor.CompositeBehavior.ENTER_TRANSFORM;
            }

            public void visitPrimitiveTransform(// Could not load outer class - annotation placement on inner may be incorrect
             @UnknownKeyFor @NonNull @Initialized TransformHierarchy. @UnknownKeyFor @NonNull @Initialized Node node) {
                for (PCollection input : node.getInputs().values()) {
                    unconsumedDLQ.remove(input);
                }
            }
        });
        for (String unconsumed : unconsumedDLQ.values()) {
            LOG.warn("No transform processes the failed-inserts output from BigQuery sink: " + unconsumed + "! Not processing failed inserts means that those rows will be lost.");
        }
    }

    private void logWarningIfPCollectionViewHasNonDeterministicKeyCoder(@UnknownKeyFor @NonNull @Initialized Pipeline pipeline) {
        if (!this.ptransformViewsWithNonDeterministicKeyCoders.isEmpty()) {
            final TreeSet ptransformViewNamesWithNonDeterministicKeyCoders = new TreeSet();
            pipeline.traverseTopologically((Pipeline.PipelineVisitor)new Pipeline.PipelineVisitor.Defaults(){

                public void visitValue(@UnknownKeyFor @NonNull @Initialized PValue value, // Could not load outer class - annotation placement on inner may be incorrect
                 @UnknownKeyFor @NonNull @Initialized TransformHierarchy. @UnknownKeyFor @NonNull @Initialized Node producer) {
                }

                public void visitPrimitiveTransform(// Could not load outer class - annotation placement on inner may be incorrect
                 @UnknownKeyFor @NonNull @Initialized TransformHierarchy. @UnknownKeyFor @NonNull @Initialized Node node) {
                    if (DataflowRunner.this.ptransformViewsWithNonDeterministicKeyCoders.contains(node.getTransform())) {
                        ptransformViewNamesWithNonDeterministicKeyCoders.add(node.getFullName());
                    }
                }

                public // Could not load outer class - annotation placement on inner may be incorrect
                @UnknownKeyFor @NonNull @Initialized Pipeline.PipelineVisitor.CompositeBehavior enterCompositeTransform(// Could not load outer class - annotation placement on inner may be incorrect
                 @UnknownKeyFor @NonNull @Initialized TransformHierarchy. @UnknownKeyFor @NonNull @Initialized Node node) {
                    if (node.getTransform() instanceof View.AsMap || node.getTransform() instanceof View.AsMultimap) {
                        PCollection input = (PCollection)Iterables.getOnlyElement(node.getInputs().values());
                        KvCoder inputCoder = (KvCoder)input.getCoder();
                        try {
                            inputCoder.getKeyCoder().verifyDeterministic();
                        }
                        catch (Coder.NonDeterministicException e) {
                            ptransformViewNamesWithNonDeterministicKeyCoders.add(node.getFullName());
                        }
                    }
                    if (DataflowRunner.this.ptransformViewsWithNonDeterministicKeyCoders.contains(node.getTransform())) {
                        ptransformViewNamesWithNonDeterministicKeyCoders.add(node.getFullName());
                    }
                    return Pipeline.PipelineVisitor.CompositeBehavior.ENTER_TRANSFORM;
                }

                public void leaveCompositeTransform(// Could not load outer class - annotation placement on inner may be incorrect
                 @UnknownKeyFor @NonNull @Initialized TransformHierarchy. @UnknownKeyFor @NonNull @Initialized Node node) {
                }
            });
            LOG.warn("Unable to use indexed implementation for View.AsMap and View.AsMultimap for {} because the key coder is not deterministic. Falling back to singleton implementation which may cause memory and/or performance problems. Future major versions of Dataflow will require deterministic key coders.", ptransformViewNamesWithNonDeterministicKeyCoders);
        }
    }

    @UnknownKeyFor @NonNull @Initialized boolean doesPCollectionRequireIndexedFormat(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> pcol) {
        return this.pcollectionsRequiringIndexedFormat.contains(pcol);
    }

    void addPCollectionRequiringIndexedFormat(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> pcol) {
        this.pcollectionsRequiringIndexedFormat.add(pcol);
    }

    void maybeRecordPCollectionPreservedKeys(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> pcol) {
        this.pCollectionsPreservedKeys.add(pcol);
    }

    void maybeRecordPCollectionWithAutoSharding(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> pcol) {
        Preconditions.checkArgument((boolean)this.options.isEnableStreamingEngine(), (Object)"Runner determined sharding not available in Dataflow for GroupIntoBatches for non-Streaming-Engine jobs. In order to use runner determined sharding, please use --streaming --experiments=enable_streaming_engine");
        this.pCollectionsPreservedKeys.add(pcol);
        this.pcollectionsRequiringAutoSharding.add(pcol);
    }

    @UnknownKeyFor @NonNull @Initialized boolean doesPCollectionPreserveKeys(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> pcol) {
        return this.pCollectionsPreservedKeys.contains(pcol);
    }

    @UnknownKeyFor @NonNull @Initialized boolean doesPCollectionRequireAutoSharding(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> pcol) {
        return this.pcollectionsRequiringAutoSharding.contains(pcol);
    }

    void recordViewUsesNonDeterministicKeyCoder(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized PTransform<@UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?> ptransform) {
        this.ptransformViewsWithNonDeterministicKeyCoders.add(ptransform);
    }

    private static void translateOverriddenPubsubSourceStep(@UnknownKeyFor @NonNull @Initialized PubsubUnboundedSource overriddenTransform, @UnknownKeyFor @NonNull @Initialized TransformTranslator.StepTranslationContext stepTranslationContext) {
        stepTranslationContext.addInput("format", "pubsub");
        if (overriddenTransform.getTopicProvider() != null) {
            if (overriddenTransform.getTopicProvider().isAccessible()) {
                stepTranslationContext.addInput("pubsub_topic", overriddenTransform.getTopic().getFullPath());
            } else {
                stepTranslationContext.addInput("pubsub_topic_runtime_override", ((ValueProvider.NestedValueProvider)overriddenTransform.getTopicProvider()).propertyName());
            }
        }
        if (overriddenTransform.getSubscriptionProvider() != null) {
            if (overriddenTransform.getSubscriptionProvider().isAccessible()) {
                stepTranslationContext.addInput("pubsub_subscription", overriddenTransform.getSubscription().getFullPath());
            } else {
                stepTranslationContext.addInput("pubsub_subscription_runtime_override", ((ValueProvider.NestedValueProvider)overriddenTransform.getSubscriptionProvider()).propertyName());
            }
        }
        if (overriddenTransform.getTimestampAttribute() != null) {
            stepTranslationContext.addInput("pubsub_timestamp_label", overriddenTransform.getTimestampAttribute());
        }
        if (overriddenTransform.getIdAttribute() != null) {
            stepTranslationContext.addInput("pubsub_id_label", overriddenTransform.getIdAttribute());
        }
        if (overriddenTransform.getNeedsAttributes() || overriddenTransform.getNeedsMessageId()) {
            stepTranslationContext.addInput("pubsub_serialized_attributes_fn", StringUtils.byteArrayToJsonString((byte[])SerializableUtils.serializeToByteArray((Serializable)((Object)new IdentityMessageFn()))));
        }
    }

    @SideEffectFree
    public @UnknownKeyFor @NonNull @Initialized String toString() {
        return "DataflowRunner#" + this.options.getJobName();
    }

    private @UnknownKeyFor @NonNull @Initialized String getJobIdFromName(@UnknownKeyFor @NonNull @Initialized String jobName) {
        try {
            String token = null;
            do {
                ListJobsResponse listResult = this.dataflowClient.listJobs(token);
                token = listResult.getNextPageToken();
                for (Job job : listResult.getJobs()) {
                    if (!job.getName().equals(jobName) || !MonitoringUtil.toState(job.getCurrentState()).equals((Object)PipelineResult.State.RUNNING)) continue;
                    return job.getId();
                }
            } while (token != null);
        }
        catch (GoogleJsonResponseException e) {
            throw new RuntimeException("Got error while looking up jobs: " + (e.getDetails() != null ? e.getDetails().getMessage() : e), e);
        }
        catch (IOException e) {
            throw new RuntimeException("Got error while looking up jobs: ", e);
        }
        throw new IllegalArgumentException("Could not find running job named " + jobName);
    }

    @VisibleForTesting
    static @UnknownKeyFor @NonNull @Initialized String getContainerImageForJob(@UnknownKeyFor @NonNull @Initialized DataflowPipelineOptions options) {
        String containerImage = options.getSdkContainerImage();
        if (containerImage == null) {
            return DataflowRunner.getDefaultContainerImageUrl(options);
        }
        if (containerImage.contains("IMAGE")) {
            return containerImage.replace("IMAGE", DataflowRunner.getDefaultContainerImageNameForJob(options));
        }
        return containerImage;
    }

    static @UnknownKeyFor @NonNull @Initialized String getDefaultContainerImageUrl(@UnknownKeyFor @NonNull @Initialized DataflowPipelineOptions options) {
        DataflowRunnerInfo dataflowRunnerInfo = DataflowRunnerInfo.getDataflowRunnerInfo();
        return String.format("%s/%s:%s", dataflowRunnerInfo.getContainerImageBaseRepository(), DataflowRunner.getDefaultContainerImageNameForJob(options), DataflowRunner.getDefaultContainerVersion(options));
    }

    static @UnknownKeyFor @NonNull @Initialized String getDefaultContainerImageNameForJob(@UnknownKeyFor @NonNull @Initialized DataflowPipelineOptions options) {
        Environments.JavaVersion javaVersion = Environments.getJavaVersion();
        if (DataflowRunner.useUnifiedWorker(options)) {
            return String.format("beam_%s_sdk", javaVersion.name());
        }
        if (options.isStreaming()) {
            return String.format("beam-%s-streaming", javaVersion.legacyName());
        }
        return String.format("beam-%s-batch", javaVersion.legacyName());
    }

    static @UnknownKeyFor @NonNull @Initialized String getDefaultContainerVersion(@UnknownKeyFor @NonNull @Initialized DataflowPipelineOptions options) {
        DataflowRunnerInfo dataflowRunnerInfo = DataflowRunnerInfo.getDataflowRunnerInfo();
        ReleaseInfo releaseInfo = ReleaseInfo.getReleaseInfo();
        if (releaseInfo.isDevSdkVersion()) {
            if (DataflowRunner.useUnifiedWorker(options)) {
                return dataflowRunnerInfo.getFnApiDevContainerVersion();
            }
            return dataflowRunnerInfo.getLegacyDevContainerVersion();
        }
        return releaseInfo.getSdkVersion();
    }

    static @UnknownKeyFor @NonNull @Initialized boolean useUnifiedWorker(@UnknownKeyFor @NonNull @Initialized DataflowPipelineOptions options) {
        return DataflowRunner.hasExperiment(options, "beam_fn_api") || DataflowRunner.hasExperiment(options, "use_runner_v2") || DataflowRunner.hasExperiment(options, "use_unified_worker") || DataflowRunner.hasExperiment(options, "use_portable_job_submission");
    }

    static void verifyDoFnSupported(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized DoFn<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> fn, @UnknownKeyFor @NonNull @Initialized boolean streaming, @UnknownKeyFor @NonNull @Initialized DataflowPipelineOptions options) {
        if (!streaming && DoFnSignatures.usesMultimapState(fn)) {
            throw new UnsupportedOperationException(String.format("%s does not currently support %s in batch mode", DataflowRunner.class.getSimpleName(), MultimapState.class.getSimpleName()));
        }
        if (streaming && DoFnSignatures.requiresTimeSortedInput(fn)) {
            throw new UnsupportedOperationException(String.format("%s does not currently support @RequiresTimeSortedInput in streaming mode.", DataflowRunner.class.getSimpleName()));
        }
        boolean isUnifiedWorker = DataflowRunner.useUnifiedWorker(options);
        if (DoFnSignatures.usesMultimapState(fn) && isUnifiedWorker) {
            throw new UnsupportedOperationException(String.format("%s does not currently support %s running using streaming on unified worker", DataflowRunner.class.getSimpleName(), MultimapState.class.getSimpleName()));
        }
        if (DoFnSignatures.usesSetState(fn) && streaming && isUnifiedWorker) {
            throw new UnsupportedOperationException(String.format("%s does not currently support %s when using streaming on unified worker", DataflowRunner.class.getSimpleName(), SetState.class.getSimpleName()));
        }
        if (DoFnSignatures.usesMapState(fn) && streaming && isUnifiedWorker) {
            throw new UnsupportedOperationException(String.format("%s does not currently support %s when using streaming on unified worker", DataflowRunner.class.getSimpleName(), MapState.class.getSimpleName()));
        }
        if (DoFnSignatures.usesBundleFinalizer(fn) && !isUnifiedWorker) {
            throw new UnsupportedOperationException(String.format("%s does not currently support %s when not using unified worker because it uses BundleFinalizers in its implementation. Set the `--experiments=use_runner_v2` option to use this DoFn.", DataflowRunner.class.getSimpleName(), fn.getClass().getSimpleName()));
        }
    }

    static void verifyStateSupportForWindowingStrategy(@UnknownKeyFor @NonNull @Initialized WindowingStrategy strategy) {
        if (strategy.needsMerge()) {
            throw new UnsupportedOperationException(String.format("%s does not currently support state or timers with merging windows", DataflowRunner.class.getSimpleName()));
        }
    }

    static {
        DataflowPipelineTranslator.registerTransformTranslator(External.SingleOutputExpandableTransform.class, new SingleOutputExpandableTransformTranslator());
        DataflowPipelineTranslator.registerTransformTranslator(External.MultiOutputExpandableTransform.class, new MultiOutputExpandableTransformTranslator());
        DataflowPipelineTranslator.registerTransformTranslator(Impulse.class, new ImpulseTranslator());
    }

    @AutoService(value={TransformPayloadTranslatorRegistrar.class})
    public static class DataflowTransformTranslator
    implements TransformPayloadTranslatorRegistrar {
        public @UnknownKeyFor @NonNull @Initialized Map<@KeyForBottom @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized PTransform>, @KeyForBottom @NonNull @Initialized ? extends // Could not load outer class - annotation placement on inner may be incorrect
         @UnknownKeyFor @NonNull @Initialized PTransformTranslation.TransformPayloadTranslator> getTransformPayloadTranslators() {
            DataflowPayloadTranslator dummyTranslator = new DataflowPayloadTranslator();
            return ImmutableMap.builder().put(CreateDataflowView.class, (Object)dummyTranslator).put(BatchViewOverrides.GroupByKeyAndSortValuesOnly.class, (Object)dummyTranslator).put(StreamingPubsubIORead.class, (Object)dummyTranslator).put(StreamingUnboundedRead.ReadWithIds.class, (Object)dummyTranslator).put(CombineGroupedValues.class, (Object)dummyTranslator).build();
        }
    }

    private static class DataflowPayloadTranslator
    implements PTransformTranslation.TransformPayloadTranslator<PTransform<?, ?>> {
        private DataflowPayloadTranslator() {
        }

        public @UnknownKeyFor @NonNull @Initialized String getUrn(@UnknownKeyFor @NonNull @Initialized PTransform transform) {
            return "dataflow_stub:" + transform.getClass().getName();
        }

        public @UnknownKeyFor @NonNull @Initialized String getUrn() {
            throw new UnsupportedOperationException("URN of DataflowPayloadTranslator depends on the transform. Please use 'getUrn(PTransform transform)' instead.");
        }

        public // Could not load outer class - annotation placement on inner may be incorrect
         @UnknownKeyFor @NonNull @Initialized RunnerApi.FunctionSpec translate(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized AppliedPTransform<@UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?, @UnknownKeyFor @NonNull @Initialized PTransform<@UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?>> application, @UnknownKeyFor @NonNull @Initialized SdkComponents components) throws @UnknownKeyFor @NonNull @Initialized IOException {
            return RunnerApi.FunctionSpec.newBuilder().setUrn(this.getUrn(application.getTransform())).build();
        }
    }

    @VisibleForTesting
    static class StreamingShardedWriteFactory<@UnknownKeyFor UserT, @UnknownKeyFor DestinationT, @UnknownKeyFor OutputT>
    implements PTransformOverrideFactory<PCollection<UserT>, WriteFilesResult<DestinationT>, WriteFiles<UserT, DestinationT, OutputT>> {
        static final @UnknownKeyFor @NonNull @Initialized int DEFAULT_NUM_SHARDS = 10;
        @UnknownKeyFor @NonNull @Initialized DataflowPipelineWorkerPoolOptions options;

        StreamingShardedWriteFactory(@UnknownKeyFor @NonNull @Initialized PipelineOptions options) {
            this.options = (DataflowPipelineWorkerPoolOptions)options.as(DataflowPipelineWorkerPoolOptions.class);
        }

        public // Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized PTransformOverrideFactory.PTransformReplacement<@UnknownKeyFor @NonNull @Initialized PCollection<UserT>, @UnknownKeyFor @NonNull @Initialized WriteFilesResult<DestinationT>> getReplacementTransform(@UnknownKeyFor @NonNull @Initialized AppliedPTransform<@UnknownKeyFor @NonNull @Initialized PCollection<UserT>, @UnknownKeyFor @NonNull @Initialized WriteFilesResult<DestinationT>, @UnknownKeyFor @NonNull @Initialized WriteFiles<UserT, DestinationT, OutputT>> transform) {
            int numShards = this.options.getMaxNumWorkers() > 0 ? this.options.getMaxNumWorkers() * 2 : (this.options.getNumWorkers() > 0 ? this.options.getNumWorkers() * 2 : 10);
            try {
                List sideInputs = WriteFilesTranslation.getDynamicDestinationSideInputs(transform);
                FileBasedSink sink = WriteFilesTranslation.getSink(transform);
                WriteFiles replacement = WriteFiles.to((FileBasedSink)sink).withSideInputs(sideInputs);
                if (WriteFilesTranslation.isWindowedWrites(transform)) {
                    replacement = replacement.withWindowedWrites();
                }
                if (WriteFilesTranslation.isAutoSharded(transform)) {
                    replacement = replacement.withAutoSharding();
                    return PTransformOverrideFactory.PTransformReplacement.of((PInput)PTransformReplacements.getSingletonMainInput(transform), (PTransform)replacement);
                }
                return PTransformOverrideFactory.PTransformReplacement.of((PInput)PTransformReplacements.getSingletonMainInput(transform), (PTransform)replacement.withNumShards(numShards));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        public /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>, // Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized PTransformOverrideFactory.ReplacementOutput> mapOutputs(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized TupleTag<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>, @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> outputs, @UnknownKeyFor @NonNull @Initialized WriteFilesResult<DestinationT> newOutput) {
            return ReplacementOutputs.tagged(outputs, newOutput);
        }
    }

    private static class StreamingPubsubIOWriteOverrideFactory
    implements PTransformOverrideFactory<PCollection<PubsubMessage>, PDone, PubsubUnboundedSink> {
        private final @UnknownKeyFor @NonNull @Initialized DataflowRunner runner;

        private StreamingPubsubIOWriteOverrideFactory(@UnknownKeyFor @NonNull @Initialized DataflowRunner runner) {
            this.runner = runner;
        }

        public // Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized PTransformOverrideFactory.PTransformReplacement<@UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized PubsubMessage>, @UnknownKeyFor @NonNull @Initialized PDone> getReplacementTransform(@UnknownKeyFor @NonNull @Initialized AppliedPTransform<@UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized PubsubMessage>, @UnknownKeyFor @NonNull @Initialized PDone, @UnknownKeyFor @NonNull @Initialized PubsubUnboundedSink> transform) {
            return PTransformOverrideFactory.PTransformReplacement.of((PInput)PTransformReplacements.getSingletonMainInput(transform), (PTransform)new StreamingPubsubIOWrite(this.runner, (PubsubUnboundedSink)transform.getTransform()));
        }

        public /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>, // Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized PTransformOverrideFactory.ReplacementOutput> mapOutputs(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized TupleTag<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>, @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> outputs, @UnknownKeyFor @NonNull @Initialized PDone newOutput) {
            return Collections.emptyMap();
        }
    }

    private static class PrimitiveCombineGroupedValuesOverrideFactory<@UnknownKeyFor K, @UnknownKeyFor InputT, @UnknownKeyFor OutputT>
    implements PTransformOverrideFactory<PCollection<KV<K, Iterable<InputT>>>, PCollection<KV<K, OutputT>>, Combine.GroupedValues<K, InputT, OutputT>> {
        private PrimitiveCombineGroupedValuesOverrideFactory() {
        }

        public // Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized PTransformOverrideFactory.PTransformReplacement<@UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized KV<K, @UnknownKeyFor @NonNull @Initialized Iterable<InputT>>>, @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized KV<K, OutputT>>> getReplacementTransform(@UnknownKeyFor @NonNull @Initialized AppliedPTransform<@UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized KV<K, @UnknownKeyFor @NonNull @Initialized Iterable<InputT>>>, @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized KV<K, OutputT>>, // Could not load outer class - annotation placement on inner may be incorrect
         @UnknownKeyFor @NonNull @Initialized Combine.GroupedValues<K, InputT, OutputT>> transform) {
            return PTransformOverrideFactory.PTransformReplacement.of((PInput)PTransformReplacements.getSingletonMainInput(transform), new CombineGroupedValues((Combine.GroupedValues)transform.getTransform(), PTransformReplacements.getSingletonMainOutput(transform).getCoder()));
        }

        public /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>, // Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized PTransformOverrideFactory.ReplacementOutput> mapOutputs(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized TupleTag<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>, @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> outputs, @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized KV<K, OutputT>> newOutput) {
            return ReplacementOutputs.singleton(outputs, newOutput);
        }
    }

    static class CombineGroupedValues<@UnknownKeyFor K, @UnknownKeyFor InputT, @UnknownKeyFor OutputT>
    extends PTransform<PCollection<KV<K, Iterable<InputT>>>, PCollection<KV<K, OutputT>>> {
        private final // Could not load outer class - annotation placement on inner may be incorrect
         @UnknownKeyFor @NonNull @Initialized Combine.GroupedValues<K, InputT, OutputT> original;
        private final @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @NonNull @Initialized KV<K, OutputT>> outputCoder;

        CombineGroupedValues(// Could not load outer class - annotation placement on inner may be incorrect
         @UnknownKeyFor @NonNull @Initialized Combine.GroupedValues<K, InputT, OutputT> original, @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @NonNull @Initialized KV<K, OutputT>> outputCoder) {
            this.original = original;
            this.outputCoder = outputCoder;
        }

        public @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized KV<K, OutputT>> expand(@UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized KV<K, @UnknownKeyFor @NonNull @Initialized Iterable<InputT>>> input) {
            return PCollection.createPrimitiveOutputInternal((Pipeline)input.getPipeline(), (WindowingStrategy)input.getWindowingStrategy(), (PCollection.IsBounded)input.isBounded(), this.outputCoder);
        }

        public // Could not load outer class - annotation placement on inner may be incorrect
         @UnknownKeyFor @NonNull @Initialized Combine.GroupedValues<K, InputT, OutputT> getOriginalCombine() {
            return this.original;
        }
    }

    public static class StreamingPCollectionViewWriterFn<@UnknownKeyFor T>
    extends DoFn<Iterable<T>, T> {
        private final /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized PCollectionView<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> view;
        private final @UnknownKeyFor @NonNull @Initialized Coder<T> dataCoder;

        public static <T> @UnknownKeyFor @NonNull @Initialized StreamingPCollectionViewWriterFn<T> create(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized PCollectionView<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> view, @UnknownKeyFor @NonNull @Initialized Coder<T> dataCoder) {
            return new StreamingPCollectionViewWriterFn<T>(view, dataCoder);
        }

        private StreamingPCollectionViewWriterFn(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized PCollectionView<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> view, @UnknownKeyFor @NonNull @Initialized Coder<T> dataCoder) {
            this.view = view;
            this.dataCoder = dataCoder;
        }

        public /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized PCollectionView<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> getView() {
            return this.view;
        }

        public @UnknownKeyFor @NonNull @Initialized Coder<T> getDataCoder() {
            return this.dataCoder;
        }

        @DoFn.ProcessElement
        public void processElement(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        // Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized DoFn. @UnknownKeyFor @NonNull @Initialized ProcessContext c, @UnknownKeyFor @NonNull @Initialized BoundedWindow w) throws @UnknownKeyFor @NonNull @Initialized Exception {
            throw new UnsupportedOperationException(String.format("%s is a marker class only and should never be executed.", ((Object)((Object)this)).getClass().getName()));
        }
    }

    private static class StreamingBoundedRead<@UnknownKeyFor T>
    extends PTransform<PBegin, PCollection<T>> {
        private final @UnknownKeyFor @NonNull @Initialized BoundedSource<T> source;

        public StreamingBoundedRead(// Could not load outer class - annotation placement on inner may be incorrect
         @UnknownKeyFor @NonNull @Initialized Read.Bounded<T> transform) {
            this.source = transform.getSource();
        }

        public final @UnknownKeyFor @NonNull @Initialized PCollection<T> expand(@UnknownKeyFor @NonNull @Initialized PBegin input) {
            this.source.validate();
            return ((PCollection)Pipeline.applyTransform((PInput)input, (PTransform)new UnboundedReadFromBoundedSource(this.source))).setIsBoundedInternal(PCollection.IsBounded.BOUNDED);
        }
    }

    private static class StreamingBoundedReadOverrideFactory<@UnknownKeyFor T>
    implements PTransformOverrideFactory<PBegin, PCollection<T>, Read.Bounded<T>> {
        private StreamingBoundedReadOverrideFactory() {
        }

        public // Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized PTransformOverrideFactory.PTransformReplacement<@UnknownKeyFor @NonNull @Initialized PBegin, @UnknownKeyFor @NonNull @Initialized PCollection<T>> getReplacementTransform(@UnknownKeyFor @NonNull @Initialized AppliedPTransform<@UnknownKeyFor @NonNull @Initialized PBegin, @UnknownKeyFor @NonNull @Initialized PCollection<T>, // Could not load outer class - annotation placement on inner may be incorrect
         @UnknownKeyFor @NonNull @Initialized Read.Bounded<T>> transform) {
            return PTransformOverrideFactory.PTransformReplacement.of((PInput)transform.getPipeline().begin(), new StreamingBoundedRead((Read.Bounded)transform.getTransform()));
        }

        public /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>, // Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized PTransformOverrideFactory.ReplacementOutput> mapOutputs(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized TupleTag<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>, @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> outputs, @UnknownKeyFor @NonNull @Initialized PCollection<T> newOutput) {
            return ReplacementOutputs.singleton(outputs, newOutput);
        }
    }

    private static class Deduplicate<@UnknownKeyFor T>
    extends PTransform<PCollection<ValueWithRecordId<T>>, PCollection<T>> {
        private static final @UnknownKeyFor @NonNull @Initialized int NUM_RESHARD_KEYS = 10000;

        private Deduplicate() {
        }

        public @UnknownKeyFor @NonNull @Initialized PCollection<T> expand(@UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized ValueWithRecordId<T>> input) {
            return (PCollection)((PCollection)((PCollection)input.apply((PTransform)WithKeys.of((SerializableFunction & Serializable)value -> Arrays.hashCode(value.getId()) % 10000).withKeyType(TypeDescriptors.integers()))).apply((PTransform)Reshuffle.of())).apply("StripIds", (PTransform)ParDo.of((DoFn)new DoFn<KV<Integer, ValueWithRecordId<T>>, T>(){

                @DoFn.ProcessElement
                public void processElement(/*
                 * Issues handling annotations - annotations may be inaccurate
                 */
                // Could not load outer class - annotation placement on inner may be incorrect
                @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized DoFn. @UnknownKeyFor @NonNull @Initialized ProcessContext c) {
                    c.output(((ValueWithRecordId)((KV)c.element()).getValue()).getValue());
                }
            }));
        }
    }

    private static class StreamingUnboundedRead<@UnknownKeyFor T>
    extends PTransform<PBegin, PCollection<T>> {
        private final /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized UnboundedSource<T, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?> source;

        public StreamingUnboundedRead(// Could not load outer class - annotation placement on inner may be incorrect
         @UnknownKeyFor @NonNull @Initialized Read.Unbounded<T> transform) {
            this.source = transform.getSource();
        }

        public final @UnknownKeyFor @NonNull @Initialized PCollection<T> expand(@UnknownKeyFor @NonNull @Initialized PBegin input) {
            this.source.validate();
            if (this.source.requiresDeduping()) {
                return (PCollection)((PCollection)Pipeline.applyTransform((PInput)input, new ReadWithIds(this.source))).apply(new Deduplicate());
            }
            return (PCollection)((PCollection)Pipeline.applyTransform((PInput)input, new ReadWithIds(this.source))).apply("StripIds", (PTransform)ParDo.of((DoFn)new ValueWithRecordId.StripIdsDoFn()));
        }

        public @UnknownKeyFor @NonNull @Initialized String getKindString() {
            return String.format("Read(%s)", NameUtils.approximateSimpleName(this.source));
        }

        static {
            DataflowPipelineTranslator.registerTransformTranslator(ReadWithIds.class, new ReadWithIdsTranslator());
        }

        private static class ReadWithIdsTranslator
        implements TransformTranslator<ReadWithIds<?>> {
            private ReadWithIdsTranslator() {
            }

            @Override
            public void translate(/*
             * Issues handling annotations - annotations may be inaccurate
             */
            @UnknownKeyFor @NonNull @Initialized ReadWithIds<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> transform, @UnknownKeyFor @NonNull @Initialized TransformTranslator.TranslationContext context) {
                ReadTranslator.translateReadHelper(transform.getSource(), transform, context);
            }
        }

        private static class ReadWithIds<@UnknownKeyFor T>
        extends PTransform<PInput, PCollection<ValueWithRecordId<T>>> {
            private final /*
             * Issues handling annotations - annotations may be inaccurate
             */
            @UnknownKeyFor @NonNull @Initialized UnboundedSource<T, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?> source;

            private ReadWithIds(/*
             * Issues handling annotations - annotations may be inaccurate
             */
            @UnknownKeyFor @NonNull @Initialized UnboundedSource<T, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?> source) {
                this.source = source;
            }

            public final @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized ValueWithRecordId<T>> expand(@UnknownKeyFor @NonNull @Initialized PInput input) {
                return PCollection.createPrimitiveOutputInternal((Pipeline)input.getPipeline(), (WindowingStrategy)WindowingStrategy.globalDefault(), (PCollection.IsBounded)PCollection.IsBounded.UNBOUNDED, (Coder)ValueWithRecordId.ValueWithRecordIdCoder.of((Coder)this.source.getOutputCoder()));
            }

            public void populateDisplayData(// Could not load outer class - annotation placement on inner may be incorrect
             @UnknownKeyFor @NonNull @Initialized DisplayData.Builder builder) {
                builder.delegate(this.source);
            }

            public /*
             * Issues handling annotations - annotations may be inaccurate
             */
            @UnknownKeyFor @NonNull @Initialized UnboundedSource<T, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?> getSource() {
                return this.source;
            }
        }
    }

    private static class StreamingUnboundedReadOverrideFactory<@UnknownKeyFor T>
    implements PTransformOverrideFactory<PBegin, PCollection<T>, Read.Unbounded<T>> {
        private StreamingUnboundedReadOverrideFactory() {
        }

        public // Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized PTransformOverrideFactory.PTransformReplacement<@UnknownKeyFor @NonNull @Initialized PBegin, @UnknownKeyFor @NonNull @Initialized PCollection<T>> getReplacementTransform(@UnknownKeyFor @NonNull @Initialized AppliedPTransform<@UnknownKeyFor @NonNull @Initialized PBegin, @UnknownKeyFor @NonNull @Initialized PCollection<T>, // Could not load outer class - annotation placement on inner may be incorrect
         @UnknownKeyFor @NonNull @Initialized Read.Unbounded<T>> transform) {
            return PTransformOverrideFactory.PTransformReplacement.of((PInput)transform.getPipeline().begin(), new StreamingUnboundedRead((Read.Unbounded)transform.getTransform()));
        }

        public /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>, // Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized PTransformOverrideFactory.ReplacementOutput> mapOutputs(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized TupleTag<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>, @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> outputs, @UnknownKeyFor @NonNull @Initialized PCollection<T> newOutput) {
            return ReplacementOutputs.singleton(outputs, newOutput);
        }
    }

    private static class ImpulseTranslator
    implements TransformTranslator<Impulse> {
        private ImpulseTranslator() {
        }

        @Override
        public void translate(@UnknownKeyFor @NonNull @Initialized Impulse transform, @UnknownKeyFor @NonNull @Initialized TransformTranslator.TranslationContext context) {
            if (context.getPipelineOptions().isStreaming()) {
                TransformTranslator.StepTranslationContext stepContext = context.addStep((PTransform<?, ?>)transform, "ParallelRead");
                stepContext.addInput("format", "pubsub");
                stepContext.addInput("pubsub_subscription", "_starting_signal/");
                stepContext.addOutput("output", (PCollection)context.getOutput(transform));
            } else {
                byte[] encodedImpulse;
                TransformTranslator.StepTranslationContext stepContext = context.addStep((PTransform<?, ?>)transform, "ParallelRead");
                stepContext.addInput("format", "impulse");
                WindowedValues.FullWindowedValueCoder coder = WindowedValues.getFullCoder((Coder)((PCollection)context.getOutput(transform)).getCoder(), (Coder)GlobalWindow.Coder.INSTANCE);
                try {
                    encodedImpulse = CoderUtils.encodeToByteArray((Coder)coder, (Object)WindowedValues.valueInGlobalWindow((Object)new byte[0]));
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
                stepContext.addInput("impulse_element", StringUtils.byteArrayToJsonString((byte[])encodedImpulse));
                stepContext.addOutput("output", (PCollection)context.getOutput(transform));
            }
        }
    }

    private static class MultiOutputExpandableTransformTranslator
    implements TransformTranslator<External.MultiOutputExpandableTransform> {
        private MultiOutputExpandableTransformTranslator() {
        }

        @Override
        public void translate(// Could not load outer class - annotation placement on inner may be incorrect
         @UnknownKeyFor @NonNull @Initialized External.MultiOutputExpandableTransform transform, @UnknownKeyFor @NonNull @Initialized TransformTranslator.TranslationContext context) {
            TransformTranslator.StepTranslationContext stepContext = context.addStep((PTransform<?, ?>)transform, "ExternalTransform");
            Map<TupleTag<?>, PCollection<?>> outputs = context.getOutputs(transform);
            for (Map.Entry<TupleTag<?>, PCollection<?>> taggedOutput : outputs.entrySet()) {
                TupleTag<?> tag = taggedOutput.getKey();
                stepContext.addOutput(tag.getId(), taggedOutput.getValue());
            }
        }
    }

    private static class SingleOutputExpandableTransformTranslator
    implements TransformTranslator<External.SingleOutputExpandableTransform> {
        private SingleOutputExpandableTransformTranslator() {
        }

        @Override
        public void translate(// Could not load outer class - annotation placement on inner may be incorrect
         @UnknownKeyFor @NonNull @Initialized External.SingleOutputExpandableTransform transform, @UnknownKeyFor @NonNull @Initialized TransformTranslator.TranslationContext context) {
            TransformTranslator.StepTranslationContext stepContext = context.addStep((PTransform<?, ?>)transform, "ExternalTransform");
            PCollection output = (PCollection)context.getOutput(transform);
            stepContext.addOutput("output", output);
        }
    }

    private static class StreamingPubsubSinkTranslators {
        private StreamingPubsubSinkTranslators() {
        }

        private static void translate(@UnknownKeyFor @NonNull @Initialized PubsubUnboundedSink overriddenTransform, @UnknownKeyFor @NonNull @Initialized TransformTranslator.StepTranslationContext stepContext, @UnknownKeyFor @NonNull @Initialized PCollection input) {
            if (overriddenTransform.getPublishBatchWithOrderingKey()) {
                throw new UnsupportedOperationException(String.format("The DataflowRunner does not currently support publishing to Pubsub with ordering keys. %s is required to support publishing with ordering keys. Set the pipeline option --experiments=%s to use this PTransform. See https://issuetracker.google.com/issues/200955424 for current status.", PubsubUnboundedSink.class.getSimpleName(), "enable_custom_pubsub_sink"));
            }
            stepContext.addInput("format", "pubsub");
            if (overriddenTransform.getTopicProvider() != null) {
                if (overriddenTransform.getTopicProvider().isAccessible()) {
                    stepContext.addInput("pubsub_topic", overriddenTransform.getTopic().getFullPath());
                } else {
                    stepContext.addInput("pubsub_topic_runtime_override", ((ValueProvider.NestedValueProvider)overriddenTransform.getTopicProvider()).propertyName());
                }
            } else {
                stepContext.addInput("pubsub_with_dynamic_destinations", true);
            }
            if (overriddenTransform.getTimestampAttribute() != null) {
                stepContext.addInput("pubsub_timestamp_label", overriddenTransform.getTimestampAttribute());
            }
            if (overriddenTransform.getIdAttribute() != null) {
                stepContext.addInput("pubsub_id_label", overriddenTransform.getIdAttribute());
            }
            stepContext.addInput("pubsub_serialized_attributes_fn", StringUtils.byteArrayToJsonString((byte[])SerializableUtils.serializeToByteArray((Serializable)((Object)new IdentityMessageFn()))));
            stepContext.addEncodingInput((Coder<?>)WindowedValues.getFullCoder((Coder)VoidCoder.of(), (Coder)GlobalWindow.Coder.INSTANCE));
            stepContext.addInput("parallel_input", (PInput)input);
        }

        static class StreamingPubsubIOWriteTranslator
        implements TransformTranslator<StreamingPubsubIOWrite> {
            StreamingPubsubIOWriteTranslator() {
            }

            @Override
            public void translate(@UnknownKeyFor @NonNull @Initialized StreamingPubsubIOWrite transform, @UnknownKeyFor @NonNull @Initialized TransformTranslator.TranslationContext context) {
                Preconditions.checkArgument((boolean)context.getPipelineOptions().isStreaming(), (Object)"StreamingPubsubIOWrite is only for streaming pipelines.");
                TransformTranslator.StepTranslationContext stepContext = context.addStep(transform, "ParallelWrite");
                StreamingPubsubSinkTranslators.translate(transform.getOverriddenTransform(), stepContext, context.getInput(transform));
            }
        }
    }

    static class StreamingPubsubIOWrite
    extends PTransform<PCollection<PubsubMessage>, PDone> {
        private final @UnknownKeyFor @NonNull @Initialized PubsubUnboundedSink transform;

        public StreamingPubsubIOWrite(@UnknownKeyFor @NonNull @Initialized DataflowRunner runner, @UnknownKeyFor @NonNull @Initialized PubsubUnboundedSink transform) {
            this.transform = transform;
        }

        @UnknownKeyFor @NonNull @Initialized PubsubUnboundedSink getOverriddenTransform() {
            return this.transform;
        }

        public @UnknownKeyFor @NonNull @Initialized PDone expand(@UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized PubsubMessage> input) {
            return PDone.in((Pipeline)input.getPipeline());
        }

        protected @UnknownKeyFor @NonNull @Initialized String getKindString() {
            return "StreamingPubsubIOWrite";
        }

        static {
            DataflowPipelineTranslator.registerTransformTranslator(StreamingPubsubIOWrite.class, new StreamingPubsubSinkTranslators.StreamingPubsubIOWriteTranslator());
        }
    }

    private static class IdentityMessageFn
    extends SimpleFunction<PubsubMessage, PubsubMessage> {
        private IdentityMessageFn() {
        }

        public @UnknownKeyFor @NonNull @Initialized PubsubMessage apply(@UnknownKeyFor @NonNull @Initialized PubsubMessage input) {
            return input;
        }
    }

    private static class StreamingPubsubIOReadTranslator
    implements TransformTranslator<StreamingPubsubIORead> {
        private StreamingPubsubIOReadTranslator() {
        }

        @Override
        public void translate(@UnknownKeyFor @NonNull @Initialized StreamingPubsubIORead transform, @UnknownKeyFor @NonNull @Initialized TransformTranslator.TranslationContext context) {
            Preconditions.checkArgument((boolean)context.getPipelineOptions().isStreaming(), (Object)"StreamingPubsubIORead is only for streaming pipelines.");
            TransformTranslator.StepTranslationContext stepContext = context.addStep(transform, "ParallelRead");
            DataflowRunner.translateOverriddenPubsubSourceStep(transform.getOverriddenTransform(), stepContext);
            stepContext.addOutput("output", context.getOutput(transform));
        }
    }

    private static class StreamingPubsubIORead
    extends PTransform<PBegin, PCollection<PubsubMessage>> {
        private final @UnknownKeyFor @NonNull @Initialized PubsubUnboundedSource transform;

        public StreamingPubsubIORead(@UnknownKeyFor @NonNull @Initialized PubsubUnboundedSource transform) {
            this.transform = transform;
        }

        public @UnknownKeyFor @NonNull @Initialized PubsubUnboundedSource getOverriddenTransform() {
            return this.transform;
        }

        public @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized PubsubMessage> expand(@UnknownKeyFor @NonNull @Initialized PBegin input) {
            PubsubMessageWithAttributesAndMessageIdCoder coder = this.transform.getNeedsMessageId() ? new PubsubMessageWithAttributesAndMessageIdCoder() : new PubsubMessageWithAttributesCoder();
            return PCollection.createPrimitiveOutputInternal((Pipeline)input.getPipeline(), (WindowingStrategy)WindowingStrategy.globalDefault(), (PCollection.IsBounded)PCollection.IsBounded.UNBOUNDED, (Coder)coder);
        }

        protected @UnknownKeyFor @NonNull @Initialized String getKindString() {
            return "StreamingPubsubIORead";
        }

        static {
            DataflowPipelineTranslator.registerTransformTranslator(StreamingPubsubIORead.class, new StreamingPubsubIOReadTranslator());
        }
    }

    private static class StreamingPubsubIOReadOverrideFactory
    implements PTransformOverrideFactory<PBegin, PCollection<PubsubMessage>, PubsubUnboundedSource> {
        private StreamingPubsubIOReadOverrideFactory() {
        }

        public // Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized PTransformOverrideFactory.PTransformReplacement<@UnknownKeyFor @NonNull @Initialized PBegin, @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized PubsubMessage>> getReplacementTransform(@UnknownKeyFor @NonNull @Initialized AppliedPTransform<@UnknownKeyFor @NonNull @Initialized PBegin, @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized PubsubMessage>, @UnknownKeyFor @NonNull @Initialized PubsubUnboundedSource> transform) {
            return PTransformOverrideFactory.PTransformReplacement.of((PInput)transform.getPipeline().begin(), (PTransform)new StreamingPubsubIORead((PubsubUnboundedSource)transform.getTransform()));
        }

        public /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>, // Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized PTransformOverrideFactory.ReplacementOutput> mapOutputs(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized TupleTag<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>, @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> outputs, @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized PubsubMessage> newOutput) {
            return ReplacementOutputs.singleton(outputs, newOutput);
        }
    }

    @AutoValue
    static abstract class EnvironmentInfo {
        EnvironmentInfo() {
        }

        static @UnknownKeyFor @NonNull @Initialized EnvironmentInfo create(@UnknownKeyFor @NonNull @Initialized String environmentId, @UnknownKeyFor @NonNull @Initialized String containerUrl, @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> capabilities) {
            return new AutoValue_DataflowRunner_EnvironmentInfo(environmentId, containerUrl, capabilities);
        }

        abstract @UnknownKeyFor @NonNull @Initialized String environmentId();

        abstract @UnknownKeyFor @NonNull @Initialized String containerUrl();

        abstract @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> capabilities();
    }

    private static class ReflectiveOneToOneOverrideFactory<@UnknownKeyFor InputT, @UnknownKeyFor OutputT, @UnknownKeyFor TransformT extends @UnknownKeyFor @NonNull @Initialized PTransform<@UnknownKeyFor @NonNull @Initialized PCollection<InputT>, @UnknownKeyFor @NonNull @Initialized PCollection<OutputT>>>
    extends SingleInputOutputOverrideFactory<PCollection<InputT>, PCollection<OutputT>, TransformT> {
        private final @UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @NonNull @Initialized PTransform<@UnknownKeyFor @NonNull @Initialized PCollection<InputT>, @UnknownKeyFor @NonNull @Initialized PCollection<OutputT>>> replacement;
        private final @UnknownKeyFor @NonNull @Initialized DataflowRunner runner;

        private ReflectiveOneToOneOverrideFactory(@UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @NonNull @Initialized PTransform<@UnknownKeyFor @NonNull @Initialized PCollection<InputT>, @UnknownKeyFor @NonNull @Initialized PCollection<OutputT>>> replacement, @UnknownKeyFor @NonNull @Initialized DataflowRunner runner) {
            this.replacement = replacement;
            this.runner = runner;
        }

        public // Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized PTransformOverrideFactory.PTransformReplacement<@UnknownKeyFor @NonNull @Initialized PCollection<InputT>, @UnknownKeyFor @NonNull @Initialized PCollection<OutputT>> getReplacementTransform(@UnknownKeyFor @NonNull @Initialized AppliedPTransform<@UnknownKeyFor @NonNull @Initialized PCollection<InputT>, @UnknownKeyFor @NonNull @Initialized PCollection<OutputT>, TransformT> transform) {
            PTransform rep = (PTransform)InstanceBuilder.ofType(this.replacement).withArg(DataflowRunner.class, (Object)this.runner).withArg(transform.getTransform().getClass(), (Object)transform.getTransform()).build();
            return PTransformOverrideFactory.PTransformReplacement.of((PInput)PTransformReplacements.getSingletonMainInput(transform), (PTransform)rep);
        }
    }

    private static class ReflectiveViewOverrideFactory<@UnknownKeyFor InputT, @UnknownKeyFor ViewT>
    implements PTransformOverrideFactory<PCollection<InputT>, PCollectionView<ViewT>, PTransform<PCollection<InputT>, PCollectionView<ViewT>>> {
        final @UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @NonNull @Initialized PTransform<@UnknownKeyFor @NonNull @Initialized PCollection<InputT>, @UnknownKeyFor @NonNull @Initialized PCollectionView<ViewT>>> replacement;
        final @UnknownKeyFor @NonNull @Initialized DataflowRunner runner;

        private ReflectiveViewOverrideFactory(@UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @NonNull @Initialized PTransform<@UnknownKeyFor @NonNull @Initialized PCollection<InputT>, @UnknownKeyFor @NonNull @Initialized PCollectionView<ViewT>>> replacement, @UnknownKeyFor @NonNull @Initialized DataflowRunner runner) {
            this.replacement = replacement;
            this.runner = runner;
        }

        // Could not load outer class - annotation placement on inner may be incorrect
         @UnknownKeyFor @NonNull @Initialized View.CreatePCollectionView<ViewT, ViewT> findCreatePCollectionView(final @UnknownKeyFor @NonNull @Initialized AppliedPTransform<@UnknownKeyFor @NonNull @Initialized PCollection<InputT>, @UnknownKeyFor @NonNull @Initialized PCollectionView<ViewT>, @UnknownKeyFor @NonNull @Initialized PTransform<@UnknownKeyFor @NonNull @Initialized PCollection<InputT>, @UnknownKeyFor @NonNull @Initialized PCollectionView<ViewT>>> transform) {
            final AtomicReference viewTransformRef = new AtomicReference();
            transform.getPipeline().traverseTopologically((Pipeline.PipelineVisitor)new Pipeline.PipelineVisitor.Defaults(){
                private @UnknownKeyFor @NonNull @Initialized boolean tracking = false;

                public // Could not load outer class - annotation placement on inner may be incorrect
                @UnknownKeyFor @NonNull @Initialized Pipeline.PipelineVisitor.CompositeBehavior enterCompositeTransform(// Could not load outer class - annotation placement on inner may be incorrect
                 @UnknownKeyFor @NonNull @Initialized TransformHierarchy. @UnknownKeyFor @NonNull @Initialized Node node) {
                    if (transform.getTransform() == node.getTransform()) {
                        this.tracking = true;
                    }
                    return super.enterCompositeTransform(node);
                }

                public void visitPrimitiveTransform(// Could not load outer class - annotation placement on inner may be incorrect
                 @UnknownKeyFor @NonNull @Initialized TransformHierarchy. @UnknownKeyFor @NonNull @Initialized Node node) {
                    if (this.tracking && node.getTransform() instanceof View.CreatePCollectionView) {
                        Preconditions.checkState((boolean)viewTransformRef.compareAndSet(null, (View.CreatePCollectionView)node.getTransform()), (String)"Found more than one instance of a CreatePCollectionView when attempting to replace %s, found [%s, %s]", replacement, viewTransformRef.get(), (Object)node.getTransform());
                    }
                }

                public void leaveCompositeTransform(// Could not load outer class - annotation placement on inner may be incorrect
                 @UnknownKeyFor @NonNull @Initialized TransformHierarchy. @UnknownKeyFor @NonNull @Initialized Node node) {
                    if (transform.getTransform() == node.getTransform()) {
                        this.tracking = false;
                    }
                }
            });
            Preconditions.checkState((viewTransformRef.get() != null ? 1 : 0) != 0, (String)"Expected to find CreatePCollectionView contained within %s", (Object)transform.getTransform());
            return (View.CreatePCollectionView)viewTransformRef.get();
        }

        public // Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized PTransformOverrideFactory.PTransformReplacement<@UnknownKeyFor @NonNull @Initialized PCollection<InputT>, @UnknownKeyFor @NonNull @Initialized PCollectionView<ViewT>> getReplacementTransform(@UnknownKeyFor @NonNull @Initialized AppliedPTransform<@UnknownKeyFor @NonNull @Initialized PCollection<InputT>, @UnknownKeyFor @NonNull @Initialized PCollectionView<ViewT>, @UnknownKeyFor @NonNull @Initialized PTransform<@UnknownKeyFor @NonNull @Initialized PCollection<InputT>, @UnknownKeyFor @NonNull @Initialized PCollectionView<ViewT>>> transform) {
            PTransform rep = (PTransform)InstanceBuilder.ofType(this.replacement).withArg(DataflowRunner.class, (Object)this.runner).withArg(View.CreatePCollectionView.class, this.findCreatePCollectionView(transform)).build();
            return PTransformOverrideFactory.PTransformReplacement.of((PInput)PTransformReplacements.getSingletonMainInput(transform), (PTransform)rep);
        }

        public /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>, // Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized PTransformOverrideFactory.ReplacementOutput> mapOutputs(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized TupleTag<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>, @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> outputs, @UnknownKeyFor @NonNull @Initialized PCollectionView<ViewT> newOutput) {
            return ReplacementOutputs.singleton(outputs, newOutput);
        }
    }

    private static class CombineGloballyAsSingletonViewOverrideFactory<@UnknownKeyFor InputT, @UnknownKeyFor ViewT>
    extends ReflectiveViewOverrideFactory<InputT, ViewT> {
        private CombineGloballyAsSingletonViewOverrideFactory(@UnknownKeyFor @NonNull @Initialized DataflowRunner runner) {
            super(BatchViewOverrides.BatchViewAsSingleton.class, runner);
        }

        @Override
        public // Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized PTransformOverrideFactory.PTransformReplacement<@UnknownKeyFor @NonNull @Initialized PCollection<InputT>, @UnknownKeyFor @NonNull @Initialized PCollectionView<ViewT>> getReplacementTransform(@UnknownKeyFor @NonNull @Initialized AppliedPTransform<@UnknownKeyFor @NonNull @Initialized PCollection<InputT>, @UnknownKeyFor @NonNull @Initialized PCollectionView<ViewT>, @UnknownKeyFor @NonNull @Initialized PTransform<@UnknownKeyFor @NonNull @Initialized PCollection<InputT>, @UnknownKeyFor @NonNull @Initialized PCollectionView<ViewT>>> transform) {
            Combine.GloballyAsSingletonView combineTransform = (Combine.GloballyAsSingletonView)transform.getTransform();
            return PTransformOverrideFactory.PTransformReplacement.of((PInput)PTransformReplacements.getSingletonMainInput(transform), new BatchViewOverrides.BatchViewAsSingleton<ViewT>(this.runner, this.findCreatePCollectionView(transform), (Combine.CombineFn)combineTransform.getCombineFn(), combineTransform.getFanout()));
        }
    }

    private static class AlwaysCreateViaRead<@UnknownKeyFor T>
    implements PTransformOverrideFactory<PBegin, PCollection<T>, Create.Values<T>> {
        private AlwaysCreateViaRead() {
        }

        public // Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized PTransformOverrideFactory.PTransformReplacement<@UnknownKeyFor @NonNull @Initialized PBegin, @UnknownKeyFor @NonNull @Initialized PCollection<T>> getReplacementTransform(@UnknownKeyFor @NonNull @Initialized AppliedPTransform<@UnknownKeyFor @NonNull @Initialized PBegin, @UnknownKeyFor @NonNull @Initialized PCollection<T>, // Could not load outer class - annotation placement on inner may be incorrect
         @UnknownKeyFor @NonNull @Initialized Create.Values<T>> appliedTransform) {
            return PTransformOverrideFactory.PTransformReplacement.of((PInput)appliedTransform.getPipeline().begin(), (PTransform)((Create.Values)appliedTransform.getTransform()).alwaysUseRead());
        }

        public final /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>, // Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized PTransformOverrideFactory.ReplacementOutput> mapOutputs(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized TupleTag<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>, @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> outputs, @UnknownKeyFor @NonNull @Initialized PCollection<T> newOutput) {
            return ReplacementOutputs.singleton(outputs, newOutput);
        }
    }
}

