/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.dataflow.util;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Objects;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.beam.sdk.coders.AtomicCoder;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.CoderException;
import org.apache.beam.sdk.util.VarInt;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.MoreObjects;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.io.ByteStreams;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.primitives.UnsignedBytes;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.EnsuresNonNullIf;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.dataflow.qual.Pure;
import org.checkerframework.dataflow.qual.SideEffectFree;

@NotThreadSafe
public class RandomAccessData {
    public static final @UnknownKeyFor @NonNull @Initialized UnsignedLexicographicalComparator UNSIGNED_LEXICOGRAPHICAL_COMPARATOR = new UnsignedLexicographicalComparator();
    static final @UnknownKeyFor @NonNull @Initialized RandomAccessData POSITIVE_INFINITY = new RandomAccessData(0);
    private static final @UnknownKeyFor @NonNull @Initialized int DEFAULT_INITIAL_BUFFER_SIZE = 128;
    private @UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] buffer;
    private @UnknownKeyFor @NonNull @Initialized int size;
    private final @UnknownKeyFor @NonNull @Initialized OutputStream outputStream = new OutputStream(){

        @Override
        public void write(@UnknownKeyFor @NonNull @Initialized int b) throws @UnknownKeyFor @NonNull @Initialized IOException {
            RandomAccessData.this.ensureCapacity(RandomAccessData.this.size + 1);
            ((RandomAccessData)RandomAccessData.this).buffer[((RandomAccessData)RandomAccessData.this).size] = (byte)b;
            RandomAccessData.this.size += 1;
        }

        @Override
        public void write(@UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] b, @UnknownKeyFor @NonNull @Initialized int offset, @UnknownKeyFor @NonNull @Initialized int length) throws @UnknownKeyFor @NonNull @Initialized IOException {
            RandomAccessData.this.ensureCapacity(RandomAccessData.this.size + length);
            System.arraycopy(b, offset, RandomAccessData.this.buffer, RandomAccessData.this.size, length);
            RandomAccessData.this.size += length;
        }
    };

    public @UnknownKeyFor @NonNull @Initialized RandomAccessData increment() throws @UnknownKeyFor @NonNull @Initialized IOException {
        RandomAccessData copy = this.copy();
        for (int i = copy.size - 1; i >= 0; --i) {
            if (copy.buffer[i] == -1) continue;
            copy.buffer[i] = UnsignedBytes.checkedCast((long)((long)UnsignedBytes.toInt((byte)copy.buffer[i]) + 1L));
            return copy;
        }
        return POSITIVE_INFINITY;
    }

    public RandomAccessData() {
        this(128);
    }

    public RandomAccessData(@UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] initialBuffer) {
        Preconditions.checkNotNull((Object)initialBuffer);
        this.buffer = initialBuffer;
        this.size = initialBuffer.length;
    }

    public RandomAccessData(@UnknownKeyFor @NonNull @Initialized int initialBufferSize) {
        Preconditions.checkArgument((initialBufferSize >= 0 ? 1 : 0) != 0, (Object)"Expected initial buffer size to be greater than zero.");
        this.buffer = new byte[initialBufferSize];
    }

    public @UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] array() {
        return this.buffer;
    }

    public @UnknownKeyFor @NonNull @Initialized int size() {
        return this.size;
    }

    public void resetTo(@UnknownKeyFor @NonNull @Initialized int position) {
        this.ensureCapacity(position);
        this.size = position;
    }

    public @UnknownKeyFor @NonNull @Initialized OutputStream asOutputStream() {
        return this.outputStream;
    }

    public @UnknownKeyFor @NonNull @Initialized InputStream asInputStream(@UnknownKeyFor @NonNull @Initialized int offset, @UnknownKeyFor @NonNull @Initialized int length) {
        return new ByteArrayInputStream(this.buffer, offset, length);
    }

    public void writeTo(@UnknownKeyFor @NonNull @Initialized OutputStream out, @UnknownKeyFor @NonNull @Initialized int offset, @UnknownKeyFor @NonNull @Initialized int length) throws @UnknownKeyFor @NonNull @Initialized IOException {
        out.write(this.buffer, offset, length);
    }

    public void readFrom(@UnknownKeyFor @NonNull @Initialized InputStream inStream, @UnknownKeyFor @NonNull @Initialized int offset, @UnknownKeyFor @NonNull @Initialized int length) throws @UnknownKeyFor @NonNull @Initialized IOException {
        this.ensureCapacity(offset + length);
        ByteStreams.readFully((InputStream)inStream, (byte[])this.buffer, (int)offset, (int)length);
        this.size = offset + length;
    }

    public @UnknownKeyFor @NonNull @Initialized RandomAccessData copy() throws @UnknownKeyFor @NonNull @Initialized IOException {
        RandomAccessData copy = new RandomAccessData(this.size);
        this.writeTo(copy.asOutputStream(), 0, this.size);
        return copy;
    }

    @EnsuresNonNullIf(expression={"#1"}, result=true)
    @Pure
    public @UnknownKeyFor @NonNull @Initialized boolean equals(@Nullable @UnknownKeyFor @Initialized Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof RandomAccessData)) {
            return false;
        }
        return UNSIGNED_LEXICOGRAPHICAL_COMPARATOR.compare(this, (RandomAccessData)other) == 0;
    }

    @Pure
    public @UnknownKeyFor @NonNull @Initialized int hashCode() {
        int result = 1;
        for (int i = 0; i < this.size; ++i) {
            result = 31 * result + this.buffer[i];
        }
        return result;
    }

    @SideEffectFree
    public @UnknownKeyFor @NonNull @Initialized String toString() {
        return MoreObjects.toStringHelper((Object)this).add("buffer", (Object)Arrays.copyOf(this.buffer, this.size)).add("size", this.size).toString();
    }

    private void ensureCapacity(@UnknownKeyFor @NonNull @Initialized int minCapacity) {
        if (minCapacity <= this.buffer.length) {
            return;
        }
        int newCapacity = (int)Math.min(0x7FFFFFF7L, (long)this.buffer.length * 2L);
        if (newCapacity < minCapacity) {
            newCapacity = minCapacity;
        }
        this.buffer = Arrays.copyOf(this.buffer, newCapacity);
    }

    public static final class UnsignedLexicographicalComparator
    implements Comparator<RandomAccessData>,
    Serializable {
        private UnsignedLexicographicalComparator() {
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized int compare(@UnknownKeyFor @NonNull @Initialized RandomAccessData o1, @UnknownKeyFor @NonNull @Initialized RandomAccessData o2) {
            return this.compare(o1, o2, 0);
        }

        public @UnknownKeyFor @NonNull @Initialized int compare(@UnknownKeyFor @NonNull @Initialized RandomAccessData o1, @UnknownKeyFor @NonNull @Initialized RandomAccessData o2, @UnknownKeyFor @NonNull @Initialized int startOffset) {
            if (o1 == o2) {
                return 0;
            }
            if (o1 == POSITIVE_INFINITY) {
                return 1;
            }
            if (o2 == POSITIVE_INFINITY) {
                return -1;
            }
            int minBytesLen = Math.min(o1.size, o2.size);
            for (int i = startOffset; i < minBytesLen; ++i) {
                int b2;
                int b1 = o1.buffer[i] & 0xFF;
                if (b1 == (b2 = o2.buffer[i] & 0xFF)) continue;
                return b1 - b2;
            }
            return o1.size - o2.size;
        }

        public @UnknownKeyFor @NonNull @Initialized int commonPrefixLength(@UnknownKeyFor @NonNull @Initialized RandomAccessData o1, @UnknownKeyFor @NonNull @Initialized RandomAccessData o2) {
            int minBytesLen = Math.min(o1.size, o2.size);
            for (int i = 0; i < minBytesLen; ++i) {
                int b2;
                int b1 = o1.buffer[i] & 0xFF;
                if (b1 == (b2 = o2.buffer[i] & 0xFF)) continue;
                return i;
            }
            return minBytesLen;
        }
    }

    public static class RandomAccessDataCoder
    extends AtomicCoder<RandomAccessData> {
        private static final @UnknownKeyFor @NonNull @Initialized RandomAccessDataCoder INSTANCE = new RandomAccessDataCoder();

        public static @UnknownKeyFor @NonNull @Initialized RandomAccessDataCoder of() {
            return INSTANCE;
        }

        public void encode(@UnknownKeyFor @NonNull @Initialized RandomAccessData value, @UnknownKeyFor @NonNull @Initialized OutputStream outStream) throws @UnknownKeyFor @NonNull @Initialized CoderException, @UnknownKeyFor @NonNull @Initialized IOException {
            this.encode(value, outStream, Coder.Context.NESTED);
        }

        public void encode(@UnknownKeyFor @NonNull @Initialized RandomAccessData value, @UnknownKeyFor @NonNull @Initialized OutputStream outStream, // Could not load outer class - annotation placement on inner may be incorrect
         @UnknownKeyFor @NonNull @Initialized Coder.Context context) throws @UnknownKeyFor @NonNull @Initialized CoderException, @UnknownKeyFor @NonNull @Initialized IOException {
            if (Objects.equals(value, POSITIVE_INFINITY)) {
                throw new CoderException("Positive infinity can not be encoded.");
            }
            if (!context.isWholeStream) {
                VarInt.encode((int)value.size, (OutputStream)outStream);
            }
            value.writeTo(outStream, 0, value.size);
        }

        public @UnknownKeyFor @NonNull @Initialized RandomAccessData decode(@UnknownKeyFor @NonNull @Initialized InputStream inStream) throws @UnknownKeyFor @NonNull @Initialized CoderException, @UnknownKeyFor @NonNull @Initialized IOException {
            return this.decode(inStream, Coder.Context.NESTED);
        }

        public @UnknownKeyFor @NonNull @Initialized RandomAccessData decode(@UnknownKeyFor @NonNull @Initialized InputStream inStream, // Could not load outer class - annotation placement on inner may be incorrect
         @UnknownKeyFor @NonNull @Initialized Coder.Context context) throws @UnknownKeyFor @NonNull @Initialized CoderException, @UnknownKeyFor @NonNull @Initialized IOException {
            RandomAccessData rval = new RandomAccessData();
            if (!context.isWholeStream) {
                int length = VarInt.decodeInt((InputStream)inStream);
                rval.readFrom(inStream, 0, length);
            } else {
                ByteStreams.copy((InputStream)inStream, (OutputStream)rval.asOutputStream());
            }
            return rval;
        }

        public void verifyDeterministic() {
        }

        public @UnknownKeyFor @NonNull @Initialized boolean consistentWithEquals() {
            return true;
        }

        public @UnknownKeyFor @NonNull @Initialized boolean isRegisterByteSizeObserverCheap(@UnknownKeyFor @NonNull @Initialized RandomAccessData value) {
            return true;
        }

        protected @UnknownKeyFor @NonNull @Initialized long getEncodedElementByteSize(@UnknownKeyFor @NonNull @Initialized RandomAccessData value) throws @UnknownKeyFor @NonNull @Initialized Exception {
            if (value == null) {
                throw new CoderException("cannot encode a null in memory stream");
            }
            return (long)VarInt.getLength((int)value.size) + (long)value.size;
        }
    }
}

