/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.dataflow;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Map;
import java.util.UUID;
import org.apache.beam.runners.core.construction.PTransformReplacements;
import org.apache.beam.runners.core.construction.ReplacementOutputs;
import org.apache.beam.runners.dataflow.DataflowRunner;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.KvCoder;
import org.apache.beam.sdk.runners.AppliedPTransform;
import org.apache.beam.sdk.runners.PTransformOverrideFactory;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.GroupByKey;
import org.apache.beam.sdk.transforms.GroupIntoBatches;
import org.apache.beam.sdk.transforms.MapElements;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.transforms.SimpleFunction;
import org.apache.beam.sdk.util.ShardedKey;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PInput;
import org.apache.beam.sdk.values.TupleTag;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Lists;

public class GroupIntoBatchesOverride {
    private static final UUID workerUuid = UUID.randomUUID();

    private static <K, V> PCollection<KV<ShardedKey<K>, V>> shardKeys(PCollection<KV<K, V>> input) {
        KvCoder inputCoder = (KvCoder)input.getCoder();
        Coder keyCoder = (Coder)inputCoder.getCoderArguments().get(0);
        Coder valueCoder = (Coder)inputCoder.getCoderArguments().get(1);
        return ((PCollection)input.apply("Shard Keys", (PTransform)MapElements.via((SimpleFunction)new SimpleFunction<KV<K, V>, KV<ShardedKey<K>, V>>(){

            public KV<ShardedKey<K>, V> apply(KV<K, V> input) {
                long tid = Thread.currentThread().getId();
                ByteBuffer buffer = ByteBuffer.allocate(24);
                buffer.putLong(workerUuid.getMostSignificantBits());
                buffer.putLong(workerUuid.getLeastSignificantBits());
                buffer.putLong(tid);
                return KV.of((Object)ShardedKey.of((Object)input.getKey(), (byte[])buffer.array()), (Object)input.getValue());
            }
        }))).setCoder((Coder)KvCoder.of((Coder)ShardedKey.Coder.of((Coder)keyCoder), (Coder)valueCoder));
    }

    static class StreamingGroupIntoBatchesWithShardedKey<K, V>
    extends PTransform<PCollection<KV<K, V>>, PCollection<KV<ShardedKey<K>, Iterable<V>>>> {
        private final transient DataflowRunner runner;
        private final GroupIntoBatches.WithShardedKey originalTransform;
        private final transient PCollection<KV<ShardedKey<K>, Iterable<V>>> originalOutput;

        public StreamingGroupIntoBatchesWithShardedKey(DataflowRunner runner, GroupIntoBatches.WithShardedKey original, PCollection<KV<ShardedKey<K>, Iterable<V>>> output) {
            this.runner = runner;
            this.originalTransform = original;
            this.originalOutput = output;
        }

        public PCollection<KV<ShardedKey<K>, Iterable<V>>> expand(PCollection<KV<K, V>> input) {
            this.runner.maybeRecordPCollectionWithAutoSharding(this.originalOutput);
            return (PCollection)input.apply((PTransform)this.originalTransform);
        }
    }

    static class StreamingGroupIntoBatchesWithShardedKeyOverrideFactory<K, V>
    implements PTransformOverrideFactory<PCollection<KV<K, V>>, PCollection<KV<ShardedKey<K>, Iterable<V>>>, GroupIntoBatches.WithShardedKey> {
        private final DataflowRunner runner;

        StreamingGroupIntoBatchesWithShardedKeyOverrideFactory(DataflowRunner runner) {
            this.runner = runner;
        }

        public PTransformOverrideFactory.PTransformReplacement<PCollection<KV<K, V>>, PCollection<KV<ShardedKey<K>, Iterable<V>>>> getReplacementTransform(AppliedPTransform<PCollection<KV<K, V>>, PCollection<KV<ShardedKey<K>, Iterable<V>>>, GroupIntoBatches.WithShardedKey> transform) {
            return PTransformOverrideFactory.PTransformReplacement.of((PInput)PTransformReplacements.getSingletonMainInput(transform), new StreamingGroupIntoBatchesWithShardedKey(this.runner, (GroupIntoBatches.WithShardedKey)transform.getTransform(), PTransformReplacements.getSingletonMainOutput(transform)));
        }

        public Map<PCollection<?>, PTransformOverrideFactory.ReplacementOutput> mapOutputs(Map<TupleTag<?>, PCollection<?>> outputs, PCollection<KV<ShardedKey<K>, Iterable<V>>> newOutput) {
            return ReplacementOutputs.singleton(outputs, newOutput);
        }
    }

    static class BatchGroupIntoBatchesWithShardedKey<K, V>
    extends PTransform<PCollection<KV<K, V>>, PCollection<KV<ShardedKey<K>, Iterable<V>>>> {
        private final GroupIntoBatches.BatchingParams<V> batchingParams;

        private BatchGroupIntoBatchesWithShardedKey(GroupIntoBatches.BatchingParams<V> batchingParams) {
            this.batchingParams = batchingParams;
        }

        public PCollection<KV<ShardedKey<K>, Iterable<V>>> expand(PCollection<KV<K, V>> input) {
            return (PCollection)GroupIntoBatchesOverride.shardKeys(input).apply(new BatchGroupIntoBatches(this.batchingParams));
        }
    }

    static class BatchGroupIntoBatchesWithShardedKeyOverrideFactory<K, V>
    implements PTransformOverrideFactory<PCollection<KV<K, V>>, PCollection<KV<ShardedKey<K>, Iterable<V>>>, GroupIntoBatches.WithShardedKey> {
        BatchGroupIntoBatchesWithShardedKeyOverrideFactory() {
        }

        public PTransformOverrideFactory.PTransformReplacement<PCollection<KV<K, V>>, PCollection<KV<ShardedKey<K>, Iterable<V>>>> getReplacementTransform(AppliedPTransform<PCollection<KV<K, V>>, PCollection<KV<ShardedKey<K>, Iterable<V>>>, GroupIntoBatches.WithShardedKey> transform) {
            return PTransformOverrideFactory.PTransformReplacement.of((PInput)PTransformReplacements.getSingletonMainInput(transform), new BatchGroupIntoBatchesWithShardedKey(((GroupIntoBatches.WithShardedKey)transform.getTransform()).getBatchingParams()));
        }

        public Map<PCollection<?>, PTransformOverrideFactory.ReplacementOutput> mapOutputs(Map<TupleTag<?>, PCollection<?>> outputs, PCollection<KV<ShardedKey<K>, Iterable<V>>> newOutput) {
            return ReplacementOutputs.singleton(outputs, newOutput);
        }
    }

    static class BatchGroupIntoBatches<K, V>
    extends PTransform<PCollection<KV<K, V>>, PCollection<KV<K, Iterable<V>>>> {
        private final GroupIntoBatches.BatchingParams<V> batchingParams;

        private BatchGroupIntoBatches(GroupIntoBatches.BatchingParams<V> batchingParams) {
            this.batchingParams = batchingParams;
        }

        public PCollection<KV<K, Iterable<V>>> expand(PCollection<KV<K, V>> input) {
            KvCoder inputCoder = (KvCoder)input.getCoder();
            Coder valueCoder = (Coder)inputCoder.getCoderArguments().get(1);
            final SerializableFunction weigher = this.batchingParams.getWeigher(valueCoder);
            final long maxBatchSizeElements = this.batchingParams.getBatchSize();
            final long maxBatchSizeBytes = this.batchingParams.getBatchSizeBytes();
            return (PCollection)((PCollection)input.apply("GroupAll", (PTransform)GroupByKey.create())).apply("SplitIntoBatches", (PTransform)ParDo.of((DoFn)new DoFn<KV<K, Iterable<V>>, KV<K, Iterable<V>>>(){

                @DoFn.ProcessElement
                public void process(DoFn.ProcessContext c) {
                    ArrayList currentBatch = Lists.newArrayList();
                    long batchSizeBytes = 0L;
                    for (Object element : (Iterable)((KV)c.element()).getValue()) {
                        currentBatch.add(element);
                        if (weigher != null) {
                            batchSizeBytes += ((Long)weigher.apply(element)).longValue();
                        }
                        if ((long)currentBatch.size() != maxBatchSizeElements && (maxBatchSizeBytes == Long.MAX_VALUE || batchSizeBytes < maxBatchSizeBytes)) continue;
                        c.output((Object)KV.of((Object)((KV)c.element()).getKey(), (Object)currentBatch));
                        currentBatch = Lists.newArrayList();
                        batchSizeBytes = 0L;
                    }
                    if (!currentBatch.isEmpty()) {
                        c.output((Object)KV.of((Object)((KV)c.element()).getKey(), (Object)currentBatch));
                    }
                }
            }));
        }
    }

    static class BatchGroupIntoBatchesOverrideFactory<K, V>
    implements PTransformOverrideFactory<PCollection<KV<K, V>>, PCollection<KV<K, Iterable<V>>>, GroupIntoBatches<K, V>> {
        BatchGroupIntoBatchesOverrideFactory() {
        }

        public PTransformOverrideFactory.PTransformReplacement<PCollection<KV<K, V>>, PCollection<KV<K, Iterable<V>>>> getReplacementTransform(AppliedPTransform<PCollection<KV<K, V>>, PCollection<KV<K, Iterable<V>>>, GroupIntoBatches<K, V>> transform) {
            return PTransformOverrideFactory.PTransformReplacement.of((PInput)PTransformReplacements.getSingletonMainInput(transform), new BatchGroupIntoBatches(((GroupIntoBatches)transform.getTransform()).getBatchingParams()));
        }

        public Map<PCollection<?>, PTransformOverrideFactory.ReplacementOutput> mapOutputs(Map<TupleTag<?>, PCollection<?>> outputs, PCollection<KV<K, Iterable<V>>> newOutput) {
            return ReplacementOutputs.singleton(outputs, newOutput);
        }
    }
}

