/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.schemas.logicaltypes;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.schemas.SchemaTranslation;
import org.apache.beam.sdk.schemas.logicaltypes.EnumerationType;
import org.apache.beam.sdk.util.Preconditions;
import org.apache.beam.sdk.values.Row;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.EnsuresNonNullIf;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.dataflow.qual.Pure;
import org.checkerframework.dataflow.qual.SideEffectFree;

public class OneOfType
implements Schema.LogicalType<Value, Row> {
    public static final @UnknownKeyFor @NonNull @Initialized String IDENTIFIER = "OneOf";
    private final @UnknownKeyFor @NonNull @Initialized Schema oneOfSchema;
    private final @UnknownKeyFor @NonNull @Initialized EnumerationType enumerationType;
    private final @UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] schemaProtoRepresentation;

    private OneOfType(@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized Schema.Field> fields) {
        this(fields, null);
    }

    private OneOfType(@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized Schema.Field> fields, @Nullable @UnknownKeyFor @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Integer> enumMap) {
        List<Schema.Field> nullableFields = fields.stream().map(f -> f.withNullable(true)).collect(Collectors.toList());
        if (enumMap != null) {
            nullableFields.stream().forEach(f -> org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions.checkArgument((boolean)enumMap.containsKey(f.getName())));
            this.enumerationType = EnumerationType.create(enumMap);
        } else {
            List<String> enumValues = nullableFields.stream().map(Schema.Field::getName).collect(Collectors.toList());
            this.enumerationType = EnumerationType.create(enumValues);
        }
        this.oneOfSchema = Schema.builder().addFields(nullableFields).build();
        this.schemaProtoRepresentation = SchemaTranslation.schemaToProto(this.oneOfSchema, false, false).toByteArray();
    }

    public static @UnknownKeyFor @NonNull @Initialized OneOfType create(Schema.Field ... fields) {
        return OneOfType.create(Arrays.asList(fields));
    }

    public static @UnknownKeyFor @NonNull @Initialized OneOfType create(@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized Schema.Field> fields) {
        return new OneOfType(fields);
    }

    public static @UnknownKeyFor @NonNull @Initialized OneOfType create(@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized Schema.Field> fields, @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Integer> enumValues) {
        return new OneOfType(fields, enumValues);
    }

    public @UnknownKeyFor @NonNull @Initialized Schema getOneOfSchema() {
        return this.oneOfSchema;
    }

    public @UnknownKeyFor @NonNull @Initialized EnumerationType getCaseEnumType() {
        return this.enumerationType;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized String getIdentifier() {
        return IDENTIFIER;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized Schema.FieldType getArgumentType() {
        return Schema.FieldType.BYTES;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] getArgument() {
        return this.schemaProtoRepresentation;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized Schema.FieldType getBaseType() {
        return Schema.FieldType.row(this.oneOfSchema);
    }

    public <T> @UnknownKeyFor @NonNull @Initialized Value createValue(@UnknownKeyFor @NonNull @Initialized String caseValue, T value) {
        return this.createValue(this.getCaseEnumType().valueOf(caseValue), value);
    }

    public <T> @UnknownKeyFor @NonNull @Initialized Value createValue(@UnknownKeyFor @NonNull @Initialized int caseValue, T value) {
        return this.createValue(this.getCaseEnumType().valueOf(caseValue), value);
    }

    public <T> @UnknownKeyFor @NonNull @Initialized Value createValue(@UnknownKeyFor @NonNull @Initialized EnumerationType.Value caseType, T value) {
        return new Value(caseType, value);
    }

    public @UnknownKeyFor @NonNull @Initialized Schema.FieldType getFieldType(@UnknownKeyFor @NonNull @Initialized Value oneOneValue) {
        return this.oneOfSchema.getField(this.enumerationType.toString(oneOneValue.getCaseType())).getType();
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized Row toBaseType(@UnknownKeyFor @NonNull @Initialized Value input) {
        EnumerationType.Value caseType = input.getCaseType();
        int setFieldIndex = this.oneOfSchema.indexOf(this.enumerationType.toString(caseType));
        Row.Builder builder = Row.withSchema(this.oneOfSchema);
        for (int i = 0; i < this.oneOfSchema.getFieldCount(); ++i) {
            Object value = i == setFieldIndex ? input.getValue() : null;
            builder = builder.addValue(value);
        }
        return builder.build();
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized Value toInputType(@UnknownKeyFor @NonNull @Initialized Row base) {
        EnumerationType.Value caseType = null;
        Object oneOfValue = null;
        for (int i = 0; i < base.getFieldCount(); ++i) {
            Object value = base.getValue(i);
            if (value == null) continue;
            org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions.checkArgument((caseType == null ? 1 : 0) != 0, (String)"More than one field set in union %s", (Object)this);
            caseType = this.enumerationType.valueOf(this.oneOfSchema.getField(i).getName());
            oneOfValue = value;
        }
        Preconditions.checkArgumentNotNull(caseType, "No value set in union %s", (Object)this);
        Preconditions.checkArgumentNotNull(oneOfValue, "No value set in union %s", (Object)this);
        return this.createValue(caseType, oneOfValue);
    }

    @SideEffectFree
    public @UnknownKeyFor @NonNull @Initialized String toString() {
        return "OneOf: " + this.oneOfSchema;
    }

    public static class Value {
        private final @UnknownKeyFor @NonNull @Initialized EnumerationType.Value caseType;
        private final @UnknownKeyFor @NonNull @Initialized Object value;

        public Value(@UnknownKeyFor @NonNull @Initialized EnumerationType.Value caseType, @UnknownKeyFor @NonNull @Initialized Object value) {
            this.caseType = caseType;
            this.value = value;
        }

        public @UnknownKeyFor @NonNull @Initialized EnumerationType.Value getCaseType() {
            return this.caseType;
        }

        public <T> T getValue(@UnknownKeyFor @NonNull @Initialized Class<T> clazz) {
            return (T)this.value;
        }

        public @UnknownKeyFor @NonNull @Initialized Object getValue() {
            return this.value;
        }

        @SideEffectFree
        public @UnknownKeyFor @NonNull @Initialized String toString() {
            return "caseType: " + this.caseType + " Value: " + this.value;
        }

        @EnsuresNonNullIf(expression={"#1"}, result=true)
        @Pure
        public @UnknownKeyFor @NonNull @Initialized boolean equals(@Nullable @UnknownKeyFor @Initialized Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Value value1 = (Value)o;
            return Objects.equals(this.caseType, value1.caseType) && Objects.equals(this.value, value1.value);
        }

        @Pure
        public @UnknownKeyFor @NonNull @Initialized int hashCode() {
            return Objects.hash(this.caseType, this.value);
        }
    }
}

