/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.schemas;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.beam.sdk.coders.BigDecimalCoder;
import org.apache.beam.sdk.coders.BigEndianShortCoder;
import org.apache.beam.sdk.coders.BooleanCoder;
import org.apache.beam.sdk.coders.ByteArrayCoder;
import org.apache.beam.sdk.coders.ByteCoder;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.CoderException;
import org.apache.beam.sdk.coders.DoubleCoder;
import org.apache.beam.sdk.coders.FloatCoder;
import org.apache.beam.sdk.coders.InstantCoder;
import org.apache.beam.sdk.coders.IterableCoder;
import org.apache.beam.sdk.coders.ListCoder;
import org.apache.beam.sdk.coders.MapCoder;
import org.apache.beam.sdk.coders.NullableCoder;
import org.apache.beam.sdk.coders.StringUtf8Coder;
import org.apache.beam.sdk.coders.VarIntCoder;
import org.apache.beam.sdk.coders.VarLongCoder;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.schemas.SchemaCoder;
import org.apache.beam.sdk.util.common.ElementByteSizeObserver;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.ImmutableMap;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.KeyForBottom;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.joda.time.ReadableInstant;

class SchemaCoderHelpers {
    private static final @UnknownKeyFor @NonNull @Initialized Map< @UnknownKeyFor @NonNull @Initialized Schema.TypeName, @UnknownKeyFor @NonNull @Initialized Coder> CODER_MAP = ImmutableMap.builder().put((Object)Schema.TypeName.BYTE, (Object)ByteCoder.of()).put((Object)Schema.TypeName.BYTES, (Object)ByteArrayCoder.of()).put((Object)Schema.TypeName.INT16, (Object)BigEndianShortCoder.of()).put((Object)Schema.TypeName.INT32, (Object)VarIntCoder.of()).put((Object)Schema.TypeName.INT64, (Object)VarLongCoder.of()).put((Object)Schema.TypeName.DECIMAL, (Object)BigDecimalCoder.of()).put((Object)Schema.TypeName.FLOAT, (Object)FloatCoder.of()).put((Object)Schema.TypeName.DOUBLE, (Object)DoubleCoder.of()).put((Object)Schema.TypeName.STRING, (Object)StringUtf8Coder.of()).put((Object)Schema.TypeName.DATETIME, (Object)InstantCoder.of()).put((Object)Schema.TypeName.BOOLEAN, (Object)BooleanCoder.of()).build();

    SchemaCoderHelpers() {
    }

    public static <T> @UnknownKeyFor @NonNull @Initialized Coder<T> coderForFieldType( @UnknownKeyFor @NonNull @Initialized Schema.FieldType fieldType) {
        Coder coder;
        switch (fieldType.getTypeName()) {
            case ROW: {
                coder = SchemaCoder.of(fieldType.getRowSchema());
                break;
            }
            case ARRAY: {
                coder = ListCoder.of(SchemaCoderHelpers.coderForFieldType(fieldType.getCollectionElementType()));
                break;
            }
            case ITERABLE: {
                coder = IterableCoder.of(SchemaCoderHelpers.coderForFieldType(fieldType.getCollectionElementType()));
                break;
            }
            case MAP: {
                coder = MapCoder.of(SchemaCoderHelpers.coderForFieldType(fieldType.getMapKeyType()), SchemaCoderHelpers.coderForFieldType(fieldType.getMapValueType()));
                break;
            }
            case LOGICAL_TYPE: {
                coder = new LogicalTypeCoder(fieldType.getLogicalType(), SchemaCoderHelpers.coderForFieldType(fieldType.getLogicalType().getBaseType()));
                break;
            }
            default: {
                coder = CODER_MAP.get((Object)fieldType.getTypeName());
            }
        }
        Preconditions.checkNotNull(coder, (String)"Unexpected field type %s", (Object)((Object)fieldType.getTypeName()));
        if (fieldType.getNullable().booleanValue()) {
            coder = NullableCoder.of(coder);
        }
        return coder;
    }

    private static class LogicalTypeCoder<@UnknownKeyFor InputT, @UnknownKeyFor BaseT>
    extends Coder<InputT> {
        private final  @UnknownKeyFor @NonNull @Initialized Schema.LogicalType<InputT, BaseT> logicalType;
        private final @UnknownKeyFor @NonNull @Initialized Coder<BaseT> baseTypeCoder;
        private final @UnknownKeyFor @NonNull @Initialized boolean isDateTime;

        LogicalTypeCoder( @UnknownKeyFor @NonNull @Initialized Schema.LogicalType<InputT, BaseT> logicalType, @UnknownKeyFor @NonNull @Initialized Coder baseTypeCoder) {
            this.logicalType = logicalType;
            this.baseTypeCoder = baseTypeCoder;
            this.isDateTime = logicalType.getBaseType().equals(Schema.FieldType.DATETIME);
        }

        @Override
        public void encode(InputT value, @UnknownKeyFor @NonNull @Initialized OutputStream outStream) throws @UnknownKeyFor @NonNull @Initialized CoderException, @UnknownKeyFor @NonNull @Initialized IOException {
            Object baseType = this.logicalType.toBaseType(value);
            if (this.isDateTime) {
                baseType = ((ReadableInstant)baseType).toInstant();
            }
            this.baseTypeCoder.encode(baseType, outStream);
        }

        @Override
        public InputT decode(@UnknownKeyFor @NonNull @Initialized InputStream inStream) throws @UnknownKeyFor @NonNull @Initialized CoderException, @UnknownKeyFor @NonNull @Initialized IOException {
            BaseT baseType = this.baseTypeCoder.decode(inStream);
            return this.logicalType.toInputType(baseType);
        }

        @Override
        public /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized List<@KeyForBottom @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> getCoderArguments() {
            return Collections.emptyList();
        }

        @Override
        public void verifyDeterministic() throws @UnknownKeyFor @NonNull @Initialized Coder.NonDeterministicException {
            this.baseTypeCoder.verifyDeterministic();
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized boolean consistentWithEquals() {
            return false;
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized Object structuralValue(InputT value) {
            if (this.baseTypeCoder.consistentWithEquals()) {
                return this.logicalType.toBaseType(value);
            }
            return this.baseTypeCoder.structuralValue(this.logicalType.toBaseType(value));
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized boolean isRegisterByteSizeObserverCheap(InputT value) {
            return this.baseTypeCoder.isRegisterByteSizeObserverCheap(this.logicalType.toBaseType(value));
        }

        @Override
        public void registerByteSizeObserver(InputT value, @UnknownKeyFor @NonNull @Initialized ElementByteSizeObserver observer) throws @UnknownKeyFor @NonNull @Initialized Exception {
            this.baseTypeCoder.registerByteSizeObserver(this.logicalType.toBaseType(value), observer);
        }
    }
}

