/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.schemas.utils;

import java.io.InputStream;
import java.math.BigDecimal;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.values.Row;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.CaseFormat;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.ImmutableMap;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.io.BaseEncoding;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.yaml.snakeyaml.Yaml;

public class YamlUtils {
    private static final @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized Schema.TypeName, @UnknownKeyFor @NonNull @Initialized Function<@UnknownKeyFor @NonNull @Initialized String, @Nullable @UnknownKeyFor @Initialized Object>> YAML_VALUE_PARSERS = ImmutableMap.builder().put((Object)Schema.TypeName.BYTE, Byte::valueOf).put((Object)Schema.TypeName.INT16, Short::valueOf).put((Object)Schema.TypeName.INT32, Integer::valueOf).put((Object)Schema.TypeName.INT64, Long::valueOf).put((Object)Schema.TypeName.FLOAT, Float::valueOf).put((Object)Schema.TypeName.DOUBLE, Double::valueOf).put((Object)Schema.TypeName.DECIMAL, BigDecimal::new).put((Object)Schema.TypeName.BOOLEAN, Boolean::valueOf).put((Object)Schema.TypeName.STRING, str -> str).put((Object)Schema.TypeName.BYTES, str -> BaseEncoding.base64().decode((CharSequence)str)).build();

    public static @UnknownKeyFor @NonNull @Initialized Row toBeamRow(@Nullable @UnknownKeyFor @Initialized String yamlString, @UnknownKeyFor @NonNull @Initialized Schema schema) {
        return YamlUtils.toBeamRow(yamlString, schema, false);
    }

    public static @UnknownKeyFor @NonNull @Initialized Row toBeamRow(@Nullable @UnknownKeyFor @Initialized String yamlString, @UnknownKeyFor @NonNull @Initialized Schema schema, @UnknownKeyFor @NonNull @Initialized boolean convertNamesToCamelCase) {
        if (yamlString == null || yamlString.isEmpty()) {
            List requiredFields = schema.getFields().stream().filter(field -> field.getType().getNullable() == false).collect(Collectors.toList());
            if (requiredFields.isEmpty()) {
                return Row.nullRow(schema);
            }
            throw new IllegalArgumentException(String.format("Received an empty YAML string, but output schema contains required fields: %s", requiredFields));
        }
        Yaml yaml = new Yaml();
        Object yamlMap = yaml.load(yamlString);
        Preconditions.checkArgument((boolean)(yamlMap instanceof Map), (String)"Expected a YAML mapping but got type '%s' instead.", Preconditions.checkNotNull((Object)yamlMap).getClass());
        return YamlUtils.toBeamRow((Map)Preconditions.checkNotNull((Object)yamlMap), schema, convertNamesToCamelCase);
    }

    private static @Nullable @UnknownKeyFor @Initialized Object toBeamValue(@UnknownKeyFor @NonNull @Initialized Schema.Field field, @Nullable @UnknownKeyFor @Initialized Object yamlValue, @UnknownKeyFor @NonNull @Initialized boolean convertNamesToCamelCase) {
        Schema.FieldType fieldType = field.getType();
        if (yamlValue == null) {
            if (fieldType.getNullable().booleanValue()) {
                return null;
            }
            throw new IllegalArgumentException("Received null value for non-nullable field \"" + field.getName() + "\"");
        }
        if (yamlValue instanceof String || yamlValue instanceof Number || yamlValue instanceof Boolean) {
            String yamlStringValue = yamlValue.toString();
            if (YAML_VALUE_PARSERS.containsKey((Object)fieldType.getTypeName())) {
                return YAML_VALUE_PARSERS.get((Object)fieldType.getTypeName()).apply(yamlStringValue);
            }
        }
        if (yamlValue instanceof byte[] && fieldType.getTypeName() == Schema.TypeName.BYTES) {
            return yamlValue;
        }
        if (yamlValue instanceof List) {
            Schema.FieldType innerType = (Schema.FieldType)Preconditions.checkNotNull((Object)fieldType.getCollectionElementType(), (String)"Cannot convert YAML type '%s` to `%s` because the YAML value is a List, but the output schema field does not define a collection type.", yamlValue.getClass(), (Object)fieldType);
            return ((List)yamlValue).stream().map(v -> Preconditions.checkNotNull((Object)YamlUtils.toBeamValue(field.withType(innerType), v, convertNamesToCamelCase))).collect(Collectors.toList());
        }
        if (yamlValue instanceof Map) {
            if (fieldType.getTypeName() == Schema.TypeName.ROW) {
                Schema nestedSchema = (Schema)Preconditions.checkNotNull((Object)fieldType.getRowSchema(), (String)"Received a YAML '%s' type, but output schema field '%s' does not define a Row Schema", yamlValue.getClass(), (Object)fieldType);
                return YamlUtils.toBeamRow((Map)yamlValue, nestedSchema, convertNamesToCamelCase);
            }
            if (fieldType.getTypeName() == Schema.TypeName.MAP) {
                return yamlValue;
            }
        }
        throw new UnsupportedOperationException(String.format("Converting YAML type '%s' to '%s' is not supported", yamlValue.getClass(), fieldType));
    }

    public static @UnknownKeyFor @NonNull @Initialized Row toBeamRow(@Nullable @UnknownKeyFor @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Object> map, @UnknownKeyFor @NonNull @Initialized Schema rowSchema, @UnknownKeyFor @NonNull @Initialized boolean toCamelCase) {
        if (map == null || map.isEmpty()) {
            List requiredFields = rowSchema.getFields().stream().filter(field -> field.getType().getNullable() == false).collect(Collectors.toList());
            if (requiredFields.isEmpty()) {
                return Row.nullRow(rowSchema);
            }
            throw new IllegalArgumentException(String.format("Received an empty Map, but output schema contains required fields: %s", requiredFields));
        }
        return rowSchema.getFields().stream().map(field -> YamlUtils.toBeamValue(field, map.get(YamlUtils.maybeGetSnakeCase(field.getName(), toCamelCase)), toCamelCase)).collect(Row.toRow(rowSchema));
    }

    private static @UnknownKeyFor @NonNull @Initialized String maybeGetSnakeCase(@UnknownKeyFor @NonNull @Initialized String str, @UnknownKeyFor @NonNull @Initialized boolean getSnakeCase) {
        return getSnakeCase ? CaseFormat.LOWER_CAMEL.to(CaseFormat.LOWER_UNDERSCORE, str) : str;
    }

    public static @UnknownKeyFor @NonNull @Initialized String yamlStringFromMap(@Nullable @UnknownKeyFor @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Object> map) {
        if (map == null || map.isEmpty()) {
            return "";
        }
        return new Yaml().dumpAsMap(map);
    }

    public static @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Object> yamlStringToMap(@Nullable @UnknownKeyFor @Initialized String yaml) {
        if (yaml == null || yaml.isEmpty()) {
            return Collections.emptyMap();
        }
        return (Map)new Yaml().load(yaml);
    }

    public static @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Object> loadFromStream(@UnknownKeyFor @NonNull @Initialized InputStream inputStream) {
        return (Map)new Yaml().load(inputStream);
    }
}

