/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.coders;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.Optional;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.CoderException;
import org.apache.beam.sdk.coders.NullableCoder;
import org.apache.beam.sdk.coders.StructuredCoder;
import org.apache.beam.sdk.util.common.ElementByteSizeObserver;
import org.apache.beam.sdk.values.TypeDescriptor;
import org.apache.beam.sdk.values.TypeParameter;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class OptionalCoder<@UnknownKeyFor T>
extends StructuredCoder<Optional<T>> {
    private final @UnknownKeyFor @NonNull @Initialized NullableCoder<T> nullableCoder;

    public static <T> @UnknownKeyFor @NonNull @Initialized OptionalCoder<T> of(@UnknownKeyFor @NonNull @Initialized Coder<T> valueCoder) {
        return new OptionalCoder<T>(valueCoder);
    }

    private OptionalCoder(@UnknownKeyFor @NonNull @Initialized Coder<T> valueCoder) {
        this.nullableCoder = NullableCoder.of(valueCoder);
    }

    public @UnknownKeyFor @NonNull @Initialized Coder<T> getValueCoder() {
        return this.nullableCoder.getValueCoder();
    }

    @Override
    public void encode(@UnknownKeyFor @NonNull @Initialized Optional<T> value, @UnknownKeyFor @NonNull @Initialized OutputStream outStream) throws @UnknownKeyFor @NonNull @Initialized IOException, @UnknownKeyFor @NonNull @Initialized CoderException {
        this.nullableCoder.encode(value.orElse(null), outStream);
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized Optional<T> decode(@UnknownKeyFor @NonNull @Initialized InputStream inStream) throws @UnknownKeyFor @NonNull @Initialized IOException, @UnknownKeyFor @NonNull @Initialized CoderException {
        return Optional.ofNullable(this.nullableCoder.decode(inStream));
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized Coder<T>> getCoderArguments() {
        return this.nullableCoder.getCoderArguments();
    }

    @Override
    public void verifyDeterministic() throws @UnknownKeyFor @NonNull @Initialized Coder.NonDeterministicException {
        this.nullableCoder.verifyDeterministic();
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized boolean consistentWithEquals() {
        return this.nullableCoder.consistentWithEquals();
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized Object structuralValue(@UnknownKeyFor @NonNull @Initialized Optional<T> value) {
        return this.nullableCoder.structuralValue(value.orElse(null));
    }

    @Override
    public void registerByteSizeObserver(@UnknownKeyFor @NonNull @Initialized Optional<T> value, @UnknownKeyFor @NonNull @Initialized ElementByteSizeObserver observer) throws @UnknownKeyFor @NonNull @Initialized Exception {
        this.nullableCoder.registerByteSizeObserver(value.orElse(null), observer);
    }

    @Override
    protected @UnknownKeyFor @NonNull @Initialized long getEncodedElementByteSize(@UnknownKeyFor @NonNull @Initialized Optional<T> value) throws @UnknownKeyFor @NonNull @Initialized Exception {
        return this.nullableCoder.getEncodedElementByteSize(value.orElse(null));
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized boolean isRegisterByteSizeObserverCheap(@UnknownKeyFor @NonNull @Initialized Optional<T> value) {
        return this.nullableCoder.isRegisterByteSizeObserverCheap(value.orElse(null));
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized TypeDescriptor<@UnknownKeyFor @NonNull @Initialized Optional<T>> getEncodedTypeDescriptor() {
        return new TypeDescriptor<Optional<T>>(){}.where(new TypeParameter<T>(){}, this.getValueCoder().getEncodedTypeDescriptor());
    }
}

