/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.repackaged.direct_java.sdk.fn.stream;

import java.util.concurrent.ExecutorService;
import org.apache.beam.repackaged.direct_java.sdk.fn.stream.AdvancingPhaser;
import org.apache.beam.repackaged.direct_java.sdk.fn.stream.BufferingStreamObserver;
import org.apache.beam.repackaged.direct_java.sdk.fn.stream.DirectStreamObserver;
import org.apache.beam.repackaged.direct_java.sdk.fn.stream.ForwardingClientResponseObserver;
import org.apache.beam.vendor.grpc.v1p26p0.io.grpc.stub.CallStreamObserver;
import org.apache.beam.vendor.grpc.v1p26p0.io.grpc.stub.StreamObserver;

public abstract class OutboundObserverFactory {
    public static OutboundObserverFactory clientBuffered(ExecutorService executorService) {
        return new Buffered(executorService, 64);
    }

    public static OutboundObserverFactory clientBuffered(ExecutorService executorService, int bufferSize) {
        return new Buffered(executorService, bufferSize);
    }

    public static OutboundObserverFactory clientDirect() {
        return new DirectClient();
    }

    public static OutboundObserverFactory serverDirect() {
        return new DirectServer();
    }

    public static OutboundObserverFactory trivial() {
        return new Trivial();
    }

    public abstract <ReqT, RespT> StreamObserver<RespT> outboundObserverFor(BasicFactory<ReqT, RespT> var1, StreamObserver<ReqT> var2);

    private static class Trivial
    extends OutboundObserverFactory {
        private Trivial() {
        }

        @Override
        public <ReqT, RespT> StreamObserver<RespT> outboundObserverFor(BasicFactory<ReqT, RespT> baseOutboundObserverFactory, StreamObserver<ReqT> inboundObserver) {
            return baseOutboundObserverFactory.outboundObserverFor(inboundObserver);
        }
    }

    private static class Buffered
    extends OutboundObserverFactory {
        private static final int DEFAULT_BUFFER_SIZE = 64;
        private final ExecutorService executorService;
        private final int bufferSize;

        private Buffered(ExecutorService executorService, int bufferSize) {
            this.executorService = executorService;
            this.bufferSize = bufferSize;
        }

        @Override
        public <ReqT, RespT> StreamObserver<RespT> outboundObserverFor(BasicFactory<ReqT, RespT> baseOutboundObserverFactory, StreamObserver<ReqT> inboundObserver) {
            AdvancingPhaser phaser = new AdvancingPhaser(1);
            inboundObserver = ForwardingClientResponseObserver.create(inboundObserver, phaser::arrive);
            CallStreamObserver outboundObserver = (CallStreamObserver)baseOutboundObserverFactory.outboundObserverFor((StreamObserver<ReqT>)inboundObserver);
            return new BufferingStreamObserver(phaser, outboundObserver, this.executorService, this.bufferSize);
        }
    }

    private static class DirectServer
    extends OutboundObserverFactory {
        private DirectServer() {
        }

        @Override
        public <ReqT, RespT> StreamObserver<RespT> outboundObserverFor(BasicFactory<ReqT, RespT> baseOutboundObserverFactory, StreamObserver<ReqT> inboundObserver) {
            AdvancingPhaser phaser = new AdvancingPhaser(1);
            CallStreamObserver outboundObserver = (CallStreamObserver)baseOutboundObserverFactory.outboundObserverFor(inboundObserver);
            outboundObserver.setOnReadyHandler(phaser::arrive);
            return new DirectStreamObserver(phaser, outboundObserver);
        }
    }

    private static class DirectClient
    extends OutboundObserverFactory {
        private DirectClient() {
        }

        @Override
        public <ReqT, RespT> StreamObserver<RespT> outboundObserverFor(BasicFactory<ReqT, RespT> baseOutboundObserverFactory, StreamObserver<ReqT> inboundObserver) {
            AdvancingPhaser phaser = new AdvancingPhaser(1);
            inboundObserver = ForwardingClientResponseObserver.create(inboundObserver, phaser::arrive);
            CallStreamObserver outboundObserver = (CallStreamObserver)baseOutboundObserverFactory.outboundObserverFor((StreamObserver<ReqT>)inboundObserver);
            return new DirectStreamObserver(phaser, outboundObserver);
        }
    }

    @FunctionalInterface
    public static interface BasicFactory<ReqT, RespT> {
        public StreamObserver<RespT> outboundObserverFor(StreamObserver<ReqT> var1);
    }
}

