/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.repackaged.direct_java.sdk.fn.data;

import java.io.InputStream;
import org.apache.beam.repackaged.direct_java.sdk.fn.data.FnDataReceiver;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.vendor.grpc.v1p26p0.com.google.protobuf.ByteString;

public class DecodingFnDataReceiver<T>
implements FnDataReceiver<ByteString> {
    private final Coder<T> coder;
    private final FnDataReceiver<T> consumer;

    public DecodingFnDataReceiver(Coder<T> coder, FnDataReceiver<T> consumer) {
        this.coder = coder;
        this.consumer = consumer;
    }

    public static <T> DecodingFnDataReceiver<T> create(Coder<T> coder, FnDataReceiver<T> consumer) {
        return new DecodingFnDataReceiver<T>(coder, consumer);
    }

    @Override
    public void accept(ByteString input) throws Exception {
        InputStream inputStream = input.newInput();
        while (inputStream.available() > 0) {
            this.consumer.accept(this.coder.decode(inputStream));
        }
    }
}

