/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.repackaged.direct_java.runners.core.construction;

import java.io.IOException;
import java.io.Serializable;
import org.apache.beam.model.pipeline.v1.RunnerApi;
import org.apache.beam.model.pipeline.v1.StandardWindowFns;
import org.apache.beam.repackaged.direct_java.runners.core.construction.BeamUrns;
import org.apache.beam.repackaged.direct_java.runners.core.construction.RehydratedComponents;
import org.apache.beam.repackaged.direct_java.runners.core.construction.SdkComponents;
import org.apache.beam.repackaged.direct_java.runners.core.construction.TriggerTranslation;
import org.apache.beam.sdk.transforms.windowing.FixedWindows;
import org.apache.beam.sdk.transforms.windowing.GlobalWindows;
import org.apache.beam.sdk.transforms.windowing.Sessions;
import org.apache.beam.sdk.transforms.windowing.SlidingWindows;
import org.apache.beam.sdk.transforms.windowing.TimestampCombiner;
import org.apache.beam.sdk.transforms.windowing.Trigger;
import org.apache.beam.sdk.transforms.windowing.Window;
import org.apache.beam.sdk.transforms.windowing.WindowFn;
import org.apache.beam.sdk.util.SerializableUtils;
import org.apache.beam.sdk.values.WindowingStrategy;
import org.apache.beam.vendor.grpc.v1p26p0.com.google.protobuf.ByteString;
import org.apache.beam.vendor.grpc.v1p26p0.com.google.protobuf.Duration;
import org.apache.beam.vendor.grpc.v1p26p0.com.google.protobuf.InvalidProtocolBufferException;
import org.apache.beam.vendor.grpc.v1p26p0.com.google.protobuf.ProtocolMessageEnum;
import org.apache.beam.vendor.grpc.v1p26p0.com.google.protobuf.Timestamp;
import org.apache.beam.vendor.grpc.v1p26p0.com.google.protobuf.util.Durations;
import org.apache.beam.vendor.grpc.v1p26p0.com.google.protobuf.util.Timestamps;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Strings;

public class WindowingStrategyTranslation
implements Serializable {
    public static final String SERIALIZED_JAVA_WINDOWFN_URN = "beam:window_fn:serialized_java:v1";
    public static final String GLOBAL_WINDOWS_URN = BeamUrns.getUrn((ProtocolMessageEnum)StandardWindowFns.GlobalWindowsPayload.Enum.PROPERTIES);
    public static final String FIXED_WINDOWS_URN = BeamUrns.getUrn((ProtocolMessageEnum)StandardWindowFns.FixedWindowsPayload.Enum.PROPERTIES);
    public static final String SLIDING_WINDOWS_URN = BeamUrns.getUrn((ProtocolMessageEnum)StandardWindowFns.SlidingWindowsPayload.Enum.PROPERTIES);
    public static final String SESSION_WINDOWS_URN = BeamUrns.getUrn((ProtocolMessageEnum)StandardWindowFns.SessionWindowsPayload.Enum.PROPERTIES);

    public static WindowingStrategy.AccumulationMode fromProto(RunnerApi.AccumulationMode.Enum proto) {
        switch (proto) {
            case DISCARDING: {
                return WindowingStrategy.AccumulationMode.DISCARDING_FIRED_PANES;
            }
            case ACCUMULATING: {
                return WindowingStrategy.AccumulationMode.ACCUMULATING_FIRED_PANES;
            }
            case RETRACTING: {
                return WindowingStrategy.AccumulationMode.RETRACTING_FIRED_PANES;
            }
        }
        throw new IllegalArgumentException(String.format("Cannot convert unknown %s to %s: %s", RunnerApi.AccumulationMode.class.getCanonicalName(), WindowingStrategy.AccumulationMode.class.getCanonicalName(), proto));
    }

    public static RunnerApi.AccumulationMode.Enum toProto(WindowingStrategy.AccumulationMode accumulationMode) {
        switch (accumulationMode) {
            case DISCARDING_FIRED_PANES: {
                return RunnerApi.AccumulationMode.Enum.DISCARDING;
            }
            case ACCUMULATING_FIRED_PANES: {
                return RunnerApi.AccumulationMode.Enum.ACCUMULATING;
            }
            case RETRACTING_FIRED_PANES: {
                return RunnerApi.AccumulationMode.Enum.RETRACTING;
            }
        }
        throw new IllegalArgumentException(String.format("Cannot convert unknown %s to %s: %s", WindowingStrategy.AccumulationMode.class.getCanonicalName(), RunnerApi.AccumulationMode.class.getCanonicalName(), accumulationMode));
    }

    public static RunnerApi.ClosingBehavior.Enum toProto(Window.ClosingBehavior closingBehavior) {
        switch (closingBehavior) {
            case FIRE_ALWAYS: {
                return RunnerApi.ClosingBehavior.Enum.EMIT_ALWAYS;
            }
            case FIRE_IF_NON_EMPTY: {
                return RunnerApi.ClosingBehavior.Enum.EMIT_IF_NONEMPTY;
            }
        }
        throw new IllegalArgumentException(String.format("Cannot convert unknown %s to %s: %s", Window.ClosingBehavior.class.getCanonicalName(), RunnerApi.ClosingBehavior.class.getCanonicalName(), closingBehavior));
    }

    public static Window.ClosingBehavior fromProto(RunnerApi.ClosingBehavior.Enum proto) {
        switch (proto) {
            case EMIT_ALWAYS: {
                return Window.ClosingBehavior.FIRE_ALWAYS;
            }
            case EMIT_IF_NONEMPTY: {
                return Window.ClosingBehavior.FIRE_IF_NON_EMPTY;
            }
        }
        throw new IllegalArgumentException(String.format("Cannot convert unknown %s to %s: %s", RunnerApi.ClosingBehavior.class.getCanonicalName(), Window.ClosingBehavior.class.getCanonicalName(), proto));
    }

    public static RunnerApi.OnTimeBehavior.Enum toProto(Window.OnTimeBehavior onTimeBehavior) {
        switch (onTimeBehavior) {
            case FIRE_ALWAYS: {
                return RunnerApi.OnTimeBehavior.Enum.FIRE_ALWAYS;
            }
            case FIRE_IF_NON_EMPTY: {
                return RunnerApi.OnTimeBehavior.Enum.FIRE_IF_NONEMPTY;
            }
        }
        throw new IllegalArgumentException(String.format("Cannot convert unknown %s to %s: %s", Window.OnTimeBehavior.class.getCanonicalName(), RunnerApi.OnTimeBehavior.class.getCanonicalName(), onTimeBehavior));
    }

    public static Window.OnTimeBehavior fromProto(RunnerApi.OnTimeBehavior.Enum proto) {
        switch (proto) {
            case FIRE_ALWAYS: {
                return Window.OnTimeBehavior.FIRE_ALWAYS;
            }
            case FIRE_IF_NONEMPTY: {
                return Window.OnTimeBehavior.FIRE_IF_NON_EMPTY;
            }
        }
        throw new IllegalArgumentException(String.format("Cannot convert unknown %s to %s: %s", RunnerApi.OnTimeBehavior.class.getCanonicalName(), Window.OnTimeBehavior.class.getCanonicalName(), proto));
    }

    public static RunnerApi.OutputTime.Enum toProto(TimestampCombiner timestampCombiner) {
        switch (timestampCombiner) {
            case EARLIEST: {
                return RunnerApi.OutputTime.Enum.EARLIEST_IN_PANE;
            }
            case END_OF_WINDOW: {
                return RunnerApi.OutputTime.Enum.END_OF_WINDOW;
            }
            case LATEST: {
                return RunnerApi.OutputTime.Enum.LATEST_IN_PANE;
            }
        }
        throw new IllegalArgumentException(String.format("Unknown %s: %s", TimestampCombiner.class.getSimpleName(), timestampCombiner));
    }

    public static TimestampCombiner timestampCombinerFromProto(RunnerApi.OutputTime.Enum proto) {
        switch (proto) {
            case EARLIEST_IN_PANE: {
                return TimestampCombiner.EARLIEST;
            }
            case END_OF_WINDOW: {
                return TimestampCombiner.END_OF_WINDOW;
            }
            case LATEST_IN_PANE: {
                return TimestampCombiner.LATEST;
            }
        }
        throw new IllegalArgumentException(String.format("Cannot convert unknown %s to %s: %s", RunnerApi.OutputTime.class.getCanonicalName(), RunnerApi.OutputTime.class.getCanonicalName(), proto));
    }

    public static RunnerApi.FunctionSpec toProto(WindowFn<?, ?> windowFn, SdkComponents components) {
        ByteString serializedFn = ByteString.copyFrom((byte[])SerializableUtils.serializeToByteArray(windowFn));
        if (windowFn instanceof GlobalWindows) {
            return RunnerApi.FunctionSpec.newBuilder().setUrn(GLOBAL_WINDOWS_URN).build();
        }
        if (windowFn instanceof FixedWindows) {
            StandardWindowFns.FixedWindowsPayload fixedWindowsPayload = StandardWindowFns.FixedWindowsPayload.newBuilder().setSize(Durations.fromMillis((long)((FixedWindows)windowFn).getSize().getMillis())).setOffset(Timestamps.fromMillis((long)((FixedWindows)windowFn).getOffset().getMillis())).build();
            return RunnerApi.FunctionSpec.newBuilder().setUrn(FIXED_WINDOWS_URN).setPayload(fixedWindowsPayload.toByteString()).build();
        }
        if (windowFn instanceof SlidingWindows) {
            StandardWindowFns.SlidingWindowsPayload slidingWindowsPayload = StandardWindowFns.SlidingWindowsPayload.newBuilder().setSize(Durations.fromMillis((long)((SlidingWindows)windowFn).getSize().getMillis())).setOffset(Timestamps.fromMillis((long)((SlidingWindows)windowFn).getOffset().getMillis())).setPeriod(Durations.fromMillis((long)((SlidingWindows)windowFn).getPeriod().getMillis())).build();
            return RunnerApi.FunctionSpec.newBuilder().setUrn(SLIDING_WINDOWS_URN).setPayload(slidingWindowsPayload.toByteString()).build();
        }
        if (windowFn instanceof Sessions) {
            StandardWindowFns.SessionWindowsPayload sessionWindowsPayload = StandardWindowFns.SessionWindowsPayload.newBuilder().setGapSize(Durations.fromMillis((long)((Sessions)windowFn).getGapDuration().getMillis())).build();
            return RunnerApi.FunctionSpec.newBuilder().setUrn(SESSION_WINDOWS_URN).setPayload(sessionWindowsPayload.toByteString()).build();
        }
        return RunnerApi.FunctionSpec.newBuilder().setUrn(SERIALIZED_JAVA_WINDOWFN_URN).setPayload(serializedFn).build();
    }

    public static RunnerApi.MessageWithComponents toMessageProto(WindowingStrategy<?, ?> windowingStrategy, SdkComponents components) throws IOException {
        RunnerApi.WindowingStrategy windowingStrategyProto = WindowingStrategyTranslation.toProto(windowingStrategy, components);
        return RunnerApi.MessageWithComponents.newBuilder().setWindowingStrategy(windowingStrategyProto).setComponents(components.toComponents()).build();
    }

    public static RunnerApi.WindowingStrategy toProto(WindowingStrategy<?, ?> windowingStrategy, SdkComponents components) throws IOException {
        WindowFn windowFn = windowingStrategy.getWindowFn();
        RunnerApi.FunctionSpec windowFnSpec = WindowingStrategyTranslation.toProto(windowFn, components);
        String environmentId = Strings.isNullOrEmpty((String)windowingStrategy.getEnvironmentId()) ? components.getOnlyEnvironmentId() : windowingStrategy.getEnvironmentId();
        RunnerApi.WindowingStrategy.Builder windowingStrategyProto = RunnerApi.WindowingStrategy.newBuilder().setOutputTime(WindowingStrategyTranslation.toProto(windowingStrategy.getTimestampCombiner())).setAccumulationMode(WindowingStrategyTranslation.toProto(windowingStrategy.getMode())).setClosingBehavior(WindowingStrategyTranslation.toProto(windowingStrategy.getClosingBehavior())).setAllowedLateness(windowingStrategy.getAllowedLateness().getMillis()).setTrigger(TriggerTranslation.toProto(windowingStrategy.getTrigger())).setWindowFn(windowFnSpec).setAssignsToOneWindow(windowFn.assignsToOneWindow()).setMergeStatus(windowFn.isNonMerging() ? RunnerApi.MergeStatus.Enum.NON_MERGING : (windowingStrategy.isAlreadyMerged() ? RunnerApi.MergeStatus.Enum.ALREADY_MERGED : RunnerApi.MergeStatus.Enum.NEEDS_MERGE)).setOnTimeBehavior(WindowingStrategyTranslation.toProto(windowingStrategy.getOnTimeBehavior())).setWindowCoderId(components.registerCoder(windowFn.windowCoder())).setEnvironmentId(environmentId);
        return windowingStrategyProto.build();
    }

    public static WindowingStrategy<?, ?> fromProto(RunnerApi.MessageWithComponents proto) throws InvalidProtocolBufferException {
        switch (proto.getRootCase()) {
            case WINDOWING_STRATEGY: {
                return WindowingStrategyTranslation.fromProto(proto.getWindowingStrategy(), RehydratedComponents.forComponents(proto.getComponents()));
            }
        }
        throw new IllegalArgumentException(String.format("Expected a %s with components but received %s", RunnerApi.WindowingStrategy.class.getCanonicalName(), proto));
    }

    public static WindowingStrategy<?, ?> fromProto(RunnerApi.WindowingStrategy proto, RehydratedComponents components) throws InvalidProtocolBufferException {
        RunnerApi.FunctionSpec windowFnSpec = proto.getWindowFn();
        WindowFn<?, ?> windowFn = WindowingStrategyTranslation.windowFnFromProto(windowFnSpec);
        TimestampCombiner timestampCombiner = WindowingStrategyTranslation.timestampCombinerFromProto(proto.getOutputTime());
        WindowingStrategy.AccumulationMode accumulationMode = WindowingStrategyTranslation.fromProto(proto.getAccumulationMode());
        Trigger trigger = TriggerTranslation.fromProto(proto.getTrigger());
        Window.ClosingBehavior closingBehavior = WindowingStrategyTranslation.fromProto(proto.getClosingBehavior());
        org.joda.time.Duration allowedLateness = org.joda.time.Duration.millis((long)proto.getAllowedLateness());
        Window.OnTimeBehavior onTimeBehavior = WindowingStrategyTranslation.fromProto(proto.getOnTimeBehavior());
        String environmentId = proto.getEnvironmentId();
        return WindowingStrategy.of(windowFn).withAllowedLateness(allowedLateness).withMode(accumulationMode).withTrigger(trigger).withTimestampCombiner(timestampCombiner).withClosingBehavior(closingBehavior).withOnTimeBehavior(onTimeBehavior).withEnvironmentId(environmentId);
    }

    public static WindowFn<?, ?> windowFnFromProto(RunnerApi.FunctionSpec windowFnSpec) {
        try {
            String s = windowFnSpec.getUrn();
            if (s.equals(BeamUrns.getUrn((ProtocolMessageEnum)StandardWindowFns.GlobalWindowsPayload.Enum.PROPERTIES))) {
                return new GlobalWindows();
            }
            if (s.equals(BeamUrns.getUrn((ProtocolMessageEnum)StandardWindowFns.FixedWindowsPayload.Enum.PROPERTIES))) {
                StandardWindowFns.FixedWindowsPayload fixedParams = StandardWindowFns.FixedWindowsPayload.parseFrom((ByteString)windowFnSpec.getPayload());
                return FixedWindows.of((org.joda.time.Duration)org.joda.time.Duration.millis((long)Durations.toMillis((Duration)fixedParams.getSize()))).withOffset(org.joda.time.Duration.millis((long)Timestamps.toMillis((Timestamp)fixedParams.getOffset())));
            }
            if (s.equals(BeamUrns.getUrn((ProtocolMessageEnum)StandardWindowFns.SlidingWindowsPayload.Enum.PROPERTIES))) {
                StandardWindowFns.SlidingWindowsPayload slidingParams = StandardWindowFns.SlidingWindowsPayload.parseFrom((ByteString)windowFnSpec.getPayload());
                return SlidingWindows.of((org.joda.time.Duration)org.joda.time.Duration.millis((long)Durations.toMillis((Duration)slidingParams.getSize()))).every(org.joda.time.Duration.millis((long)Durations.toMillis((Duration)slidingParams.getPeriod()))).withOffset(org.joda.time.Duration.millis((long)Timestamps.toMillis((Timestamp)slidingParams.getOffset())));
            }
            if (s.equals(BeamUrns.getUrn((ProtocolMessageEnum)StandardWindowFns.SessionWindowsPayload.Enum.PROPERTIES))) {
                StandardWindowFns.SessionWindowsPayload sessionParams = StandardWindowFns.SessionWindowsPayload.parseFrom((ByteString)windowFnSpec.getPayload());
                return Sessions.withGapDuration((org.joda.time.Duration)org.joda.time.Duration.millis((long)Durations.toMillis((Duration)sessionParams.getGapSize())));
            }
            if (s.equals(SERIALIZED_JAVA_WINDOWFN_URN)) {
                return (WindowFn)SerializableUtils.deserializeFromByteArray((byte[])windowFnSpec.getPayload().toByteArray(), (String)"WindowFn");
            }
            throw new IllegalArgumentException("Unknown or unsupported WindowFn: " + windowFnSpec.getUrn());
        }
        catch (InvalidProtocolBufferException e) {
            throw new IllegalArgumentException(String.format("%s for %s with URN %s did not contain expected proto message for payload", RunnerApi.FunctionSpec.class.getSimpleName(), WindowFn.class.getSimpleName(), windowFnSpec.getUrn()), e);
        }
    }
}

