/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.direct.repackaged.runners.core;

import java.util.concurrent.CancellationException;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.beam.runners.direct.repackaged.javax.annotation.Nullable;
import org.apache.beam.runners.direct.repackaged.runners.core.OutputWindowedValue;
import org.apache.beam.runners.direct.repackaged.runners.core.SideInputReader;
import org.apache.beam.runners.direct.repackaged.runners.core.SplittableProcessElementInvoker;
import org.apache.beam.runners.direct.repackaged.runners.core.java.repackaged.com.google.common.base.Preconditions;
import org.apache.beam.runners.direct.repackaged.runners.core.java.repackaged.com.google.common.collect.Iterables;
import org.apache.beam.runners.direct.repackaged.runners.core.java.repackaged.com.google.common.util.concurrent.Futures;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.state.State;
import org.apache.beam.sdk.state.Timer;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.reflect.DoFnInvoker;
import org.apache.beam.sdk.transforms.splittabledofn.RestrictionTracker;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.transforms.windowing.PaneInfo;
import org.apache.beam.sdk.util.WindowedValue;
import org.apache.beam.sdk.values.PCollectionView;
import org.apache.beam.sdk.values.TupleTag;
import org.joda.time.Duration;
import org.joda.time.Instant;

public class OutputAndTimeBoundedSplittableProcessElementInvoker<InputT, OutputT, RestrictionT, TrackerT extends RestrictionTracker<RestrictionT>>
extends SplittableProcessElementInvoker<InputT, OutputT, RestrictionT, TrackerT> {
    private final DoFn<InputT, OutputT> fn;
    private final PipelineOptions pipelineOptions;
    private final OutputWindowedValue<OutputT> output;
    private final SideInputReader sideInputReader;
    private final ScheduledExecutorService executor;
    private final int maxNumOutputs;
    private final Duration maxDuration;

    public OutputAndTimeBoundedSplittableProcessElementInvoker(DoFn<InputT, OutputT> fn, PipelineOptions pipelineOptions, OutputWindowedValue<OutputT> output, SideInputReader sideInputReader, ScheduledExecutorService executor, int maxNumOutputs, Duration maxDuration) {
        this.fn = fn;
        this.pipelineOptions = pipelineOptions;
        this.output = output;
        this.sideInputReader = sideInputReader;
        this.executor = executor;
        this.maxNumOutputs = maxNumOutputs;
        this.maxDuration = maxDuration;
    }

    @Override
    public SplittableProcessElementInvoker.Result invokeProcessElement(DoFnInvoker<InputT, OutputT> invoker, WindowedValue<InputT> element, TrackerT tracker) {
        final ProcessContext processContext = new ProcessContext(this, element, tracker);
        invoker.invokeProcessElement(new DoFnInvoker.ArgumentProvider<InputT, OutputT>((RestrictionTracker)tracker){
            final /* synthetic */ RestrictionTracker val$tracker;
            {
                this.val$tracker = restrictionTracker;
            }

            public DoFn.ProcessContext processContext(DoFn<InputT, OutputT> doFn) {
                return processContext;
            }

            public RestrictionTracker<?> restrictionTracker() {
                return this.val$tracker;
            }

            public BoundedWindow window() {
                throw new UnsupportedOperationException("Access to window of the element not supported in Splittable DoFn");
            }

            public DoFn.StartBundleContext startBundleContext(DoFn<InputT, OutputT> doFn) {
                throw new IllegalStateException("Should not access startBundleContext() from @" + DoFn.ProcessElement.class.getSimpleName());
            }

            public DoFn.FinishBundleContext finishBundleContext(DoFn<InputT, OutputT> doFn) {
                throw new IllegalStateException("Should not access finishBundleContext() from @" + DoFn.ProcessElement.class.getSimpleName());
            }

            public DoFn.OnTimerContext onTimerContext(DoFn<InputT, OutputT> doFn) {
                throw new UnsupportedOperationException("Access to timers not supported in Splittable DoFn");
            }

            public State state(String stateId) {
                throw new UnsupportedOperationException("Access to state not supported in Splittable DoFn");
            }

            public Timer timer(String timerId) {
                throw new UnsupportedOperationException("Access to timers not supported in Splittable DoFn");
            }
        });
        tracker.checkDone();
        return new SplittableProcessElementInvoker.Result(this, processContext.extractCheckpoint(), processContext.getLastReportedWatermark());
    }

    private static class ProcessContext
    extends DoFn.ProcessContext {
        private final WindowedValue<InputT> element;
        private final TrackerT tracker;
        private int numOutputs;
        private RestrictionT checkpoint;
        private Future<?> scheduledCheckpoint;
        private Instant lastReportedWatermark;
        final /* synthetic */ OutputAndTimeBoundedSplittableProcessElementInvoker this$0;

        public ProcessContext(WindowedValue<InputT> element, TrackerT tracker) {
            this.this$0 = var1_1;
            super(((OutputAndTimeBoundedSplittableProcessElementInvoker)var1_1).fn);
            this.element = element;
            this.tracker = tracker;
            this.scheduledCheckpoint = ((OutputAndTimeBoundedSplittableProcessElementInvoker)var1_1).executor.schedule(new Runnable(){

                @Override
                public void run() {
                    ProcessContext.this.initiateCheckpoint();
                }
            }, ((OutputAndTimeBoundedSplittableProcessElementInvoker)var1_1).maxDuration.getMillis(), TimeUnit.MILLISECONDS);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Nullable
        RestrictionT extractCheckpoint() {
            this.scheduledCheckpoint.cancel(true);
            try {
                Futures.getUnchecked(this.scheduledCheckpoint);
            }
            catch (CancellationException cancellationException) {
                // empty catch block
            }
            ProcessContext processContext = this;
            synchronized (processContext) {
                return this.checkpoint;
            }
        }

        private synchronized void initiateCheckpoint() {
            if (this.checkpoint == null) {
                this.checkpoint = Preconditions.checkNotNull(this.tracker.checkpoint());
            }
        }

        public InputT element() {
            return this.element.getValue();
        }

        public <T> T sideInput(PCollectionView<T> view) {
            return this.this$0.sideInputReader.get(view, view.getWindowMappingFn().getSideInputWindow((BoundedWindow)Iterables.getOnlyElement(this.element.getWindows())));
        }

        public Instant timestamp() {
            return this.element.getTimestamp();
        }

        public PaneInfo pane() {
            return this.element.getPane();
        }

        public synchronized void updateWatermark(Instant watermark) {
            this.lastReportedWatermark = watermark;
        }

        public synchronized Instant getLastReportedWatermark() {
            return this.lastReportedWatermark;
        }

        public PipelineOptions getPipelineOptions() {
            return this.this$0.pipelineOptions;
        }

        public void output(OutputT output) {
            this.outputWithTimestamp(output, this.element.getTimestamp());
        }

        public void outputWithTimestamp(OutputT value, Instant timestamp) {
            this.this$0.output.outputWindowedValue(value, timestamp, this.element.getWindows(), this.element.getPane());
            this.noteOutput();
        }

        public <T> void output(TupleTag<T> tag, T value) {
            this.outputWithTimestamp(tag, value, this.element.getTimestamp());
        }

        public <T> void outputWithTimestamp(TupleTag<T> tag, T value, Instant timestamp) {
            this.this$0.output.outputWindowedValue(tag, value, timestamp, this.element.getWindows(), this.element.getPane());
            this.noteOutput();
        }

        private void noteOutput() {
            ++this.numOutputs;
            if (this.numOutputs >= this.this$0.maxNumOutputs) {
                this.initiateCheckpoint();
            }
        }
    }
}

