/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.direct.repackaged.runners.core;

import org.apache.beam.runners.direct.repackaged.runners.core.KeyedWorkItem;
import org.apache.beam.runners.direct.repackaged.runners.core.OldDoFn;
import org.apache.beam.runners.direct.repackaged.runners.core.ReduceFnRunner;
import org.apache.beam.runners.direct.repackaged.runners.core.StateInternals;
import org.apache.beam.runners.direct.repackaged.runners.core.StateInternalsFactory;
import org.apache.beam.runners.direct.repackaged.runners.core.SystemReduceFn;
import org.apache.beam.runners.direct.repackaged.runners.core.TimerInternals;
import org.apache.beam.runners.direct.repackaged.runners.core.WindowingInternalsAdapters;
import org.apache.beam.runners.direct.repackaged.runners.core.construction.Triggers;
import org.apache.beam.runners.direct.repackaged.runners.core.triggers.ExecutableTriggerStateMachine;
import org.apache.beam.runners.direct.repackaged.runners.core.triggers.TriggerStateMachines;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.util.SystemDoFnInternal;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.WindowingStrategy;

@SystemDoFnInternal
public class GroupAlsoByWindowViaWindowSetDoFn<K, InputT, OutputT, W extends BoundedWindow, RinT extends KeyedWorkItem<K, InputT>>
extends OldDoFn<RinT, KV<K, OutputT>> {
    private final WindowingStrategy<Object, W> windowingStrategy;
    private final StateInternalsFactory<K> stateInternalsFactory;
    private SystemReduceFn<K, InputT, ?, OutputT, W> reduceFn;

    public static <K, InputT, OutputT, W extends BoundedWindow> OldDoFn<KeyedWorkItem<K, InputT>, KV<K, OutputT>> create(WindowingStrategy<?, W> strategy, StateInternalsFactory<K> stateInternalsFactory, SystemReduceFn<K, InputT, ?, OutputT, W> reduceFn) {
        return new GroupAlsoByWindowViaWindowSetDoFn(strategy, stateInternalsFactory, reduceFn);
    }

    private GroupAlsoByWindowViaWindowSetDoFn(WindowingStrategy<?, W> windowingStrategy, StateInternalsFactory<K> stateInternalsFactory, SystemReduceFn<K, InputT, ?, OutputT, W> reduceFn) {
        WindowingStrategy<?, W> noWildcard = windowingStrategy;
        this.windowingStrategy = noWildcard;
        this.reduceFn = reduceFn;
        this.stateInternalsFactory = stateInternalsFactory;
    }

    @Override
    public void processElement(OldDoFn.ProcessContext c) throws Exception {
        KeyedWorkItem keyedWorkItem = (KeyedWorkItem)c.element();
        Object key = keyedWorkItem.key();
        TimerInternals timerInternals = c.windowingInternals().timerInternals();
        StateInternals stateInternals = this.stateInternalsFactory.stateInternalsForKey(key);
        ReduceFnRunner reduceFnRunner = new ReduceFnRunner(key, this.windowingStrategy, ExecutableTriggerStateMachine.create(TriggerStateMachines.stateMachineForTrigger(Triggers.toProto(this.windowingStrategy.getTrigger()))), stateInternals, timerInternals, WindowingInternalsAdapters.outputWindowedValue(c.windowingInternals()), WindowingInternalsAdapters.sideInputReader(c.windowingInternals()), this.reduceFn, c.getPipelineOptions());
        reduceFnRunner.processElements(keyedWorkItem.elementsIterable());
        reduceFnRunner.onTimers(keyedWorkItem.timersIterable());
        reduceFnRunner.persist();
    }

    public OldDoFn<KeyedWorkItem<K, InputT>, KV<K, OutputT>> asDoFn() {
        GroupAlsoByWindowViaWindowSetDoFn asFn = this;
        return asFn;
    }
}

