/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.direct;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.beam.runners.direct.DirectGroupByKey;
import org.apache.beam.runners.direct.ParDoMultiOverrideFactory;
import org.apache.beam.runners.direct.repackaged.com.google.common.base.Preconditions;
import org.apache.beam.runners.direct.repackaged.com.google.common.collect.ImmutableSet;
import org.apache.beam.runners.direct.repackaged.runners.core.SplittableParDo;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.runners.TransformHierarchy;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.values.PValue;

class KeyedPValueTrackingVisitor
implements Pipeline.PipelineVisitor {
    private static final Set<Class<? extends PTransform>> PRODUCES_KEYED_OUTPUTS = ImmutableSet.of(SplittableParDo.GBKIntoKeyedWorkItems.class, DirectGroupByKey.DirectGroupByKeyOnly.class, DirectGroupByKey.DirectGroupAlsoByWindow.class);
    private final Set<PValue> keyedValues = new HashSet<PValue>();
    private boolean finalized;

    public static KeyedPValueTrackingVisitor create() {
        return new KeyedPValueTrackingVisitor();
    }

    private KeyedPValueTrackingVisitor() {
    }

    public Pipeline.PipelineVisitor.CompositeBehavior enterCompositeTransform(TransformHierarchy.Node node) {
        Preconditions.checkState(!this.finalized, "Attempted to use a %s that has already been finalized on a pipeline (visiting node %s)", (Object)KeyedPValueTrackingVisitor.class.getSimpleName(), (Object)node);
        return Pipeline.PipelineVisitor.CompositeBehavior.ENTER_TRANSFORM;
    }

    public void leaveCompositeTransform(TransformHierarchy.Node node) {
        Preconditions.checkState(!this.finalized, "Attempted to use a %s that has already been finalized on a pipeline (visiting node %s)", (Object)KeyedPValueTrackingVisitor.class.getSimpleName(), (Object)node);
        if (node.isRootNode()) {
            this.finalized = true;
        } else if (PRODUCES_KEYED_OUTPUTS.contains(node.getTransform().getClass())) {
            Map outputs = node.getOutputs();
            for (PValue output : outputs.values()) {
                this.keyedValues.add(output);
            }
        }
    }

    public void visitPrimitiveTransform(TransformHierarchy.Node node) {
    }

    public void visitValue(PValue value, TransformHierarchy.Node producer) {
        boolean inputsAreKeyed = true;
        for (PValue input : producer.getInputs().values()) {
            inputsAreKeyed = inputsAreKeyed && this.keyedValues.contains(input);
        }
        if (PRODUCES_KEYED_OUTPUTS.contains(producer.getTransform().getClass()) || KeyedPValueTrackingVisitor.isKeyPreserving(producer.getTransform()) && inputsAreKeyed) {
            this.keyedValues.add(value);
        }
    }

    public Set<PValue> getKeyedPValues() {
        Preconditions.checkState(this.finalized, "can't call getKeyedPValues before a Pipeline has been completely traversed");
        return this.keyedValues;
    }

    private static boolean isKeyPreserving(PTransform<?, ?> transform) {
        if (transform instanceof ParDo.MultiOutput) {
            ParDo.MultiOutput parDo = (ParDo.MultiOutput)transform;
            return parDo.getFn() instanceof ParDoMultiOverrideFactory.ToKeyedWorkItem;
        }
        return false;
    }
}

