/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batchee.test;

import jakarta.batch.runtime.BatchStatus;
import jakarta.batch.runtime.JobExecution;
import jakarta.batch.runtime.JobInstance;
import jakarta.batch.runtime.StepExecution;
import java.util.Properties;
import org.apache.batchee.container.impl.JobContextImpl;
import org.apache.batchee.container.impl.StepContextImpl;
import org.apache.batchee.container.impl.controller.JobController;
import org.apache.batchee.container.impl.jobinstance.RuntimeJobExecution;
import org.apache.batchee.container.modelresolver.PropertyResolverFactory;
import org.apache.batchee.container.navigator.JobNavigator;
import org.apache.batchee.container.navigator.ModelNavigator;
import org.apache.batchee.container.services.JobStatusManagerService;
import org.apache.batchee.container.services.ServicesManager;
import org.apache.batchee.container.services.persistence.MemoryPersistenceManagerService;
import org.apache.batchee.jaxb.JSLJob;
import org.apache.batchee.jaxb.JSLProperties;
import org.apache.batchee.jaxb.Step;
import org.apache.batchee.spi.PersistenceManagerService;

public class StepLauncher {
    private static final Properties EMPTY_PROPERTIES = new Properties();
    private static final JSLProperties EMPTY_JSL_PROPERTIES = new JSLProperties();
    private static final Properties TEST_PROPERTIES = new Properties();

    public static StepExecution execute(Step step) {
        return StepLauncher.execute(step, EMPTY_PROPERTIES);
    }

    public static Result exec(Step step, Properties jobParams) {
        step.setNextFromAttribute(null);
        ServicesManager manager = new ServicesManager();
        manager.init(TEST_PROPERTIES);
        PersistenceManagerService persistenceManagerService = (PersistenceManagerService)manager.service(PersistenceManagerService.class);
        JSLJob job = new JSLJob();
        PropertyResolverFactory.createStepPropertyResolver((boolean)false).substituteProperties((Object)step, jobParams);
        job.getExecutionElements().add(step);
        JobInstance jobInstance = persistenceManagerService.createJobInstance(step.getId(), null);
        ((JobStatusManagerService)manager.service(JobStatusManagerService.class)).createJobStatus(jobInstance.getInstanceId());
        JobContextImpl jobContext = new JobContextImpl((ModelNavigator)new JobNavigator(job), EMPTY_JSL_PROPERTIES);
        StepContextImpl stepContext = new StepContextImpl(step.getId());
        RuntimeJobExecution runtimeJobExecution = persistenceManagerService.createJobExecution(jobInstance, jobParams, BatchStatus.STARTED);
        runtimeJobExecution.prepareForExecution(jobContext, null);
        new JobController(runtimeJobExecution, manager).originateExecutionOnThread();
        return new Result(stepContext, runtimeJobExecution, persistenceManagerService);
    }

    public static StepExecution execute(Step step, Properties jobParams) {
        Result execution = StepLauncher.exec(step, jobParams);
        return execution.stepExecution();
    }

    private StepLauncher() {
    }

    static {
        TEST_PROPERTIES.put(PersistenceManagerService.class.getName(), MemoryPersistenceManagerService.class.getName());
    }

    public static class Result {
        private final StepContextImpl stepContext;
        private final RuntimeJobExecution jobExecution;
        private final PersistenceManagerService persistenceManagerService;

        public Result(StepContextImpl stepContext, RuntimeJobExecution jobExecution, PersistenceManagerService persistenceManagerService) {
            this.stepContext = stepContext;
            this.jobExecution = jobExecution;
            this.persistenceManagerService = persistenceManagerService;
        }

        public StepExecution stepExecution() {
            return this.persistenceManagerService.getStepExecutionByStepExecutionId(this.stepContext.getStepInternalExecID());
        }

        public JobExecution jobExecution() {
            return this.jobExecution.getJobOperatorJobExecution();
        }
    }
}

