/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batchee.servlet;

import jakarta.servlet.DispatcherType;
import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.FilterRegistration;
import jakarta.servlet.Servlet;
import jakarta.servlet.ServletContainerInitializer;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.EnumSet;
import java.util.Set;
import org.apache.batchee.servlet.JBatchController;

public class JBatchServletInitializer
implements ServletContainerInitializer {
    public static final String ACTIVE = "org.apache.batchee.servlet.active";
    public static final String CONTROLLER_MAPPING = "org.apache.batchee.servlet.mapping";
    public static final String DEFAULT_SCANNING = "org.apache.batchee.servlet.scan";
    public static final String ACTIVE_PRIVATE_FILTER = "org.apache.batchee.servlet.filter.private";
    public static final String BY_PAGE = "org.apache.batchee.servlet.pagination";
    private static final String DEFAULT_MAPPING = "/jbatch/*";

    public void onStartup(Set<Class<?>> classes, ServletContext ctx) throws ServletException {
        FilterRegistration.Dynamic filter;
        String active = ctx.getInitParameter(ACTIVE);
        if (active != null && !Boolean.parseBoolean(active)) {
            return;
        }
        Object mapping = ctx.getInitParameter(CONTROLLER_MAPPING);
        if (mapping == null) {
            mapping = DEFAULT_MAPPING;
        } else if (!((String)mapping).endsWith("/*")) {
            mapping = (String)mapping + "/*";
        }
        Object byPage = ctx.getInitParameter(BY_PAGE);
        byPage = byPage == null ? "30" : (String)byPage + (String)byPage;
        ctx.addServlet("JBatch Servlet", (Servlet)new JBatchController().readOnly(false).defaultScan(Boolean.parseBoolean(ctx.getInitParameter(DEFAULT_SCANNING))).mapping((String)mapping).executionByPage(Integer.parseInt((String)byPage))).addMapping(new String[]{mapping});
        String activePrivateFilter = ctx.getInitParameter(ACTIVE_PRIVATE_FILTER);
        if ((activePrivateFilter == null || Boolean.parseBoolean(activePrivateFilter)) && (filter = ctx.addFilter("JBatch Private Filter", PrivateFilter.class)) != null) {
            filter.addMappingForUrlPatterns(EnumSet.of(DispatcherType.REQUEST), false, new String[]{"/*"});
        }
    }

    public static class PrivateFilter
    implements Filter {
        public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
            HttpServletRequest httpServletRequest;
            String requestURI;
            if (HttpServletRequest.class.isInstance(request) && HttpServletResponse.class.isInstance(response) && (requestURI = (httpServletRequest = (HttpServletRequest)HttpServletRequest.class.cast(request)).getRequestURI()).contains("/internal/batchee") && requestURI.endsWith("jsp")) {
                ((HttpServletResponse)HttpServletResponse.class.cast(response)).sendError(404);
                return;
            }
            chain.doFilter(request, response);
        }

        public void init(FilterConfig filterConfig) throws ServletException {
        }

        public void destroy() {
        }
    }
}

