/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batchee.tools.maven.doc;

import edu.uci.ics.jung.algorithms.layout.AbstractLayout;
import edu.uci.ics.jung.algorithms.layout.CircleLayout;
import edu.uci.ics.jung.algorithms.layout.FRLayout;
import edu.uci.ics.jung.algorithms.layout.KKLayout;
import edu.uci.ics.jung.algorithms.layout.Layout;
import edu.uci.ics.jung.algorithms.layout.SpringLayout;
import edu.uci.ics.jung.algorithms.shortestpath.DijkstraDistance;
import edu.uci.ics.jung.algorithms.shortestpath.Distance;
import edu.uci.ics.jung.algorithms.shortestpath.UnweightedShortestPath;
import edu.uci.ics.jung.graph.DirectedSparseGraph;
import edu.uci.ics.jung.graph.Graph;
import edu.uci.ics.jung.graph.Hypergraph;
import edu.uci.ics.jung.graph.util.Context;
import edu.uci.ics.jung.graph.util.Pair;
import edu.uci.ics.jung.visualization.Layer;
import edu.uci.ics.jung.visualization.RenderContext;
import edu.uci.ics.jung.visualization.VisualizationViewer;
import edu.uci.ics.jung.visualization.control.DefaultModalGraphMouse;
import edu.uci.ics.jung.visualization.control.ModalGraphMouse;
import edu.uci.ics.jung.visualization.decorators.EdgeShape;
import edu.uci.ics.jung.visualization.decorators.ToStringLabeller;
import edu.uci.ics.jung.visualization.renderers.BasicEdgeLabelRenderer;
import edu.uci.ics.jung.visualization.renderers.Renderer;
import edu.uci.ics.jung.visualization.transform.shape.GraphicsDecorator;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Point2D;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import javax.imageio.ImageIO;
import javax.swing.JFrame;
import org.apache.batchee.container.jsl.ExecutionElement;
import org.apache.batchee.container.jsl.JobModelResolver;
import org.apache.batchee.container.jsl.TransitionElement;
import org.apache.batchee.container.navigator.JobNavigator;
import org.apache.batchee.jaxb.End;
import org.apache.batchee.jaxb.Fail;
import org.apache.batchee.jaxb.Flow;
import org.apache.batchee.jaxb.JSLJob;
import org.apache.batchee.jaxb.Next;
import org.apache.batchee.jaxb.Split;
import org.apache.batchee.jaxb.Step;
import org.apache.batchee.jaxb.Stop;
import org.apache.commons.collections15.Transformer;
import org.apache.commons.collections15.functors.ConstantTransformer;
import org.codehaus.plexus.util.IOUtil;

public abstract class DiagramGenerator {
    protected final String path;
    protected final boolean failIfMissing;
    protected final boolean view;
    protected final int width;
    protected final int height;
    protected final boolean adjust;
    protected final File output;
    protected final String format;
    protected final String outputFileName;
    protected final boolean rotateEdges;
    protected final String layout;

    public DiagramGenerator(String path, boolean failIfMissing, boolean view, int width, int height, boolean adjust, File output, String format, String outputFileName, boolean rotateEdges, String layout) {
        this.path = path;
        this.failIfMissing = failIfMissing;
        this.view = view;
        this.width = width;
        this.height = height;
        this.adjust = adjust;
        this.output = output;
        this.format = format;
        this.outputFileName = outputFileName;
        this.rotateEdges = rotateEdges;
        this.layout = layout;
    }

    public void execute() {
        String content = this.slurp(this.validInput());
        JSLJob job = new JobModelResolver().resolveModel(content);
        List executionElements = job.getExecutionElements();
        if (executionElements == null) {
            this.warn("No step found, no diagram will be generated.");
            return;
        }
        Diagram diagram = new Diagram(job.getId());
        this.visitBatch(job, diagram);
        this.draw(diagram);
    }

    private void visitBatch(JSLJob job, Diagram diagram) {
        HashMap<String, Node> nodes = new HashMap<String, Node>();
        String first = null;
        try {
            first = new JobNavigator(job).getFirstExecutionElement(null).getId();
        }
        catch (Exception exception) {
            // empty catch block
        }
        List executionElements = job.getExecutionElements();
        HashSet<ExecutionElement> allElements = new HashSet<ExecutionElement>();
        this.initNodes(diagram, nodes, allElements, executionElements);
        for (ExecutionElement element : allElements) {
            String next;
            String id = element.getId();
            Node source = (Node)nodes.get(id);
            if (id.equals(first)) {
                source.root();
            }
            if (Step.class.isInstance(element) && (next = ((Step)Step.class.cast(element)).getNextFromAttribute()) != null) {
                Node target = DiagramGenerator.addNodeIfMissing(diagram, nodes, next, Node.Type.STEP);
                diagram.addEdge(new Edge("next"), source, target);
            }
            for (TransitionElement transitionElement : element.getTransitionElements()) {
                End end;
                String exitStatus;
                Node target;
                if (Stop.class.isInstance(transitionElement)) {
                    String exitStatus2;
                    Stop stop = (Stop)Stop.class.cast(transitionElement);
                    String restart = stop.getRestart();
                    if (restart != null) {
                        target = DiagramGenerator.addNodeIfMissing(diagram, nodes, restart, Node.Type.STEP);
                        diagram.addEdge(new Edge("stop(" + stop.getOn() + ")"), source, target);
                    }
                    if ((exitStatus2 = stop.getRestart()) == null) continue;
                    Node target2 = DiagramGenerator.addNodeIfMissing(diagram, nodes, exitStatus2, Node.Type.SINK);
                    diagram.addEdge(new Edge("stop(" + stop.getOn() + ")"), source, target2);
                    continue;
                }
                if (Fail.class.isInstance(transitionElement)) {
                    Fail fail = (Fail)Fail.class.cast(transitionElement);
                    exitStatus = fail.getExitStatus();
                    target = DiagramGenerator.addNodeIfMissing(diagram, nodes, exitStatus, Node.Type.SINK);
                    diagram.addEdge(new Edge("fail(" + fail.getOn() + ")"), source, target);
                    continue;
                }
                if (End.class.isInstance(transitionElement)) {
                    end = (End)End.class.cast(transitionElement);
                    exitStatus = end.getExitStatus();
                    target = DiagramGenerator.addNodeIfMissing(diagram, nodes, exitStatus, Node.Type.SINK);
                    diagram.addEdge(new Edge("end(" + end.getOn() + ")"), source, target);
                    continue;
                }
                if (Next.class.isInstance(transitionElement)) {
                    end = (Next)Next.class.cast(transitionElement);
                    String to = end.getTo();
                    target = DiagramGenerator.addNodeIfMissing(diagram, nodes, to, Node.Type.STEP);
                    diagram.addEdge(new Edge("next(" + end.getOn() + ")"), source, target);
                    continue;
                }
                this.warn("Unknown next element: " + transitionElement);
            }
        }
    }

    protected abstract void warn(String var1);

    protected abstract void info(String var1);

    private void initNodes(Diagram diagram, Map<String, Node> nodes, Collection<ExecutionElement> allElements, Collection<ExecutionElement> executionElements) {
        for (ExecutionElement element : executionElements) {
            String id = element.getId();
            allElements.add(element);
            Node node = DiagramGenerator.addNodeIfMissing(diagram, nodes, id, Node.Type.STEP);
            if (Split.class.isInstance(element)) {
                Split split = (Split)Split.class.cast(element);
                List flows = split.getFlows();
                for (Flow flow : flows) {
                    Node target;
                    this.initNodes(diagram, nodes, allElements, flow.getExecutionElements());
                    if (flow.getExecutionElements().isEmpty() || (target = nodes.get(((ExecutionElement)flow.getExecutionElements().iterator().next()).getId())) == null) continue;
                    diagram.addEdge(new Edge("split"), node, target);
                }
                continue;
            }
            if (!Flow.class.isInstance(element)) continue;
            this.initNodes(diagram, nodes, allElements, ((Flow)Flow.class.cast(element)).getExecutionElements());
        }
    }

    private static Node addNodeIfMissing(Diagram diagram, Map<String, Node> nodes, String id, Node.Type type) {
        Node node = nodes.get(id);
        if (node == null) {
            node = new Node(id, type);
            nodes.put(id, node);
            diagram.addVertex(node);
        }
        return node;
    }

    private void draw(Diagram diagram) {
        Layout<Node, Edge> diagramLayout = this.newLayout(diagram);
        Dimension outputSize = new Dimension(this.width, this.height);
        GraphViewer viewer = new GraphViewer(diagramLayout, this.rotateEdges);
        if (LevelLayout.class.isInstance(diagramLayout)) {
            ((LevelLayout)((Object)LevelLayout.class.cast(diagramLayout))).vertexShapeTransformer = viewer.getRenderContext().getVertexShapeTransformer();
        }
        diagramLayout.setSize(outputSize);
        diagramLayout.reset();
        viewer.setPreferredSize(diagramLayout.getSize());
        viewer.setSize(diagramLayout.getSize());
        if (!this.output.exists() && !this.output.mkdirs()) {
            throw new IllegalStateException("Can't create '" + this.output.getPath() + "'");
        }
        this.saveView(diagramLayout.getSize(), outputSize, diagram.getName(), viewer);
        if (this.view) {
            JFrame window = this.createWindow(viewer, diagram.getName());
            final CountDownLatch latch = new CountDownLatch(1);
            window.setVisible(true);
            window.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosed(WindowEvent e) {
                    super.windowClosed(e);
                    latch.countDown();
                }
            });
            try {
                latch.await();
            }
            catch (InterruptedException e) {
                this.warn("can't await window close event: " + e.getMessage());
            }
        }
    }

    private Layout<Node, Edge> newLayout(Diagram diagram) {
        Object diagramLayout;
        if (this.layout != null && this.layout.startsWith("spring")) {
            diagramLayout = new SpringLayout((Graph)diagram, (Transformer)new ConstantTransformer((Object)Integer.parseInt(this.config("spring", "100"))));
        } else if (this.layout != null && this.layout.startsWith("kk")) {
            DijkstraDistance distance = new DijkstraDistance((Graph)diagram);
            if (this.layout.endsWith("unweight")) {
                distance = new UnweightedShortestPath((Hypergraph)diagram);
            }
            diagramLayout = new KKLayout((Graph)diagram, (Distance)distance);
        } else if (this.layout != null && this.layout.equalsIgnoreCase("circle")) {
            diagramLayout = new CircleLayout((Graph)diagram);
        } else if (this.layout != null && this.layout.equalsIgnoreCase("fr")) {
            diagramLayout = new FRLayout((Graph)diagram);
        } else {
            LevelLayout levelLayout = new LevelLayout(diagram);
            levelLayout.adjust = this.adjust;
            diagramLayout = levelLayout;
        }
        return diagramLayout;
    }

    private String config(String name, String defaultValue) {
        String cst = this.layout.substring(name.length());
        String len = defaultValue;
        if (!cst.isEmpty()) {
            len = cst;
        }
        return len;
    }

    private JFrame createWindow(VisualizationViewer<Node, Edge> viewer, String name) {
        viewer.setBackground(Color.WHITE);
        DefaultModalGraphMouse gm = new DefaultModalGraphMouse();
        gm.setMode(ModalGraphMouse.Mode.PICKING);
        viewer.setGraphMouse((VisualizationViewer.GraphMouse)gm);
        JFrame frame = new JFrame(name + " viewer");
        frame.setDefaultCloseOperation(2);
        frame.setLayout(new GridLayout());
        frame.getContentPane().add((Component)viewer);
        frame.pack();
        return frame;
    }

    private void saveView(Dimension currentSize, Dimension desiredSize, String name, VisualizationViewer<Node, Edge> viewer) {
        BufferedImage bi = new BufferedImage(currentSize.width, currentSize.height, 2);
        Graphics2D g = bi.createGraphics();
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        boolean db = viewer.isDoubleBuffered();
        viewer.setDoubleBuffered(false);
        viewer.paint((Graphics)g);
        viewer.setDoubleBuffered(db);
        if (!currentSize.equals(desiredSize)) {
            double xFactor = (double)desiredSize.width * 1.0 / (double)currentSize.width;
            double yFactor = (double)desiredSize.height * 1.0 / (double)currentSize.height;
            double factor = Math.min(xFactor, yFactor);
            this.info("optimal size is (" + currentSize.width + ", " + currentSize.height + ")");
            this.info("scaling with a factor of " + factor);
            AffineTransform tx = new AffineTransform();
            tx.scale(factor, factor);
            AffineTransformOp op = new AffineTransformOp(tx, 2);
            BufferedImage biNew = new BufferedImage((int)((double)bi.getWidth() * factor), (int)((double)bi.getHeight() * factor), bi.getType());
            bi = op.filter(bi, biNew);
        }
        g.dispose();
        OutputStream os = null;
        try {
            File file = new File(this.output, (this.outputFileName != null ? this.outputFileName : name) + "." + this.format);
            os = new FileOutputStream(file);
            if (!ImageIO.write((RenderedImage)bi, this.format, os)) {
                throw new IllegalStateException("can't save picture " + name + "." + this.format);
            }
            this.info("Saved " + file.getAbsolutePath());
        }
        catch (IOException e) {
            throw new IllegalStateException("can't save the diagram", e);
        }
        finally {
            if (os != null) {
                try {
                    os.flush();
                    os.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private File validInput() {
        File file = new File(this.path);
        if (!file.exists()) {
            String msg = "Can't find '" + this.path + "'";
            if (this.failIfMissing) {
                throw new IllegalStateException(msg);
            }
            this.warn(msg);
        }
        return file;
    }

    private String slurp(File file) {
        String content;
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(file);
            content = IOUtil.toString((InputStream)fis);
        }
        catch (Exception e) {
            try {
                throw new IllegalStateException(e.getMessage(), e);
            }
            catch (Throwable throwable) {
                IOUtil.close(fis);
                throw throwable;
            }
        }
        IOUtil.close((InputStream)fis);
        return content;
    }

    private static class NodeComparator
    implements Comparator<Node> {
        private final Diagram graph;
        private final Map<Node, Point2D> locations;

        public NodeComparator(Diagram diagram, Map<Node, Point2D> points) {
            this.graph = diagram;
            this.locations = points;
        }

        @Override
        public int compare(Node o1, Node o2) {
            Collection p1 = this.graph.getPredecessors(o1);
            Collection p2 = this.graph.getPredecessors(o2);
            int m1 = this.mean(p1);
            int m2 = this.mean(p2);
            return m1 - m2;
        }

        private int mean(Collection<Node> p) {
            if (p.size() == 0) {
                return 0;
            }
            int mean = 0;
            for (Node n : p) {
                mean = (int)((double)mean + this.locations.get(n).getX());
            }
            return mean / p.size();
        }
    }

    private static class LevelLayout
    extends AbstractLayout<Node, Edge> {
        private static final int X_MARGIN = 4;
        private Transformer<Node, Shape> vertexShapeTransformer = null;
        private boolean adjust;

        public LevelLayout(Diagram nodeEdgeGraph) {
            super((Graph)nodeEdgeGraph);
        }

        public void initialize() {
            Map<Node, Integer> level = this.levels();
            List<List<Node>> nodes = this.sortNodeByLevel(level);
            int ySpace = this.maxHeight(nodes);
            int nLevels = nodes.size();
            int yLevel = Math.max(0, this.getSize().height - nLevels * ySpace) / Math.max(1, nLevels - 1);
            int y = ySpace / 2;
            int maxWidth = this.getSize().width;
            for (List<Node> currentNodes : nodes) {
                if (currentNodes.size() == 1) {
                    this.setLocation(currentNodes.iterator().next(), new Point(this.getSize().width / 2, y));
                } else {
                    int x = 0;
                    int xLevel = Math.max(0, this.getSize().width - this.width(currentNodes) - 4) / (currentNodes.size() - 1);
                    Collections.sort(currentNodes, new NodeComparator((Diagram)this.graph, this.locations));
                    for (Node node : currentNodes) {
                        Rectangle b = this.getBound(node, this.vertexShapeTransformer);
                        int step = b.getBounds().width / 2;
                        this.setLocation(node, new Point(x += step, y));
                        x += xLevel + step;
                    }
                    maxWidth = Math.max(maxWidth, x - xLevel);
                }
                y += yLevel + ySpace;
            }
            if (this.adjust) {
                this.adjust = false;
                this.setSize(new Dimension(maxWidth, y + ySpace));
                this.initialize();
                this.adjust = true;
            }
        }

        public void reset() {
            this.initialize();
        }

        private int width(List<Node> nodes) {
            int sum = 0;
            for (Node node : nodes) {
                sum += this.getBound((Node)node, this.vertexShapeTransformer).width;
            }
            return sum;
        }

        private int maxHeight(List<List<Node>> nodes) {
            int max = 0;
            for (List<Node> list : nodes) {
                for (Node n : list) {
                    max = Math.max(max, this.getBound((Node)n, this.vertexShapeTransformer).height);
                }
            }
            return max;
        }

        private Rectangle getBound(Node n, Transformer<Node, Shape> vst) {
            if (vst == null) {
                return new Rectangle(0, 0);
            }
            return ((Shape)vst.transform((Object)n)).getBounds();
        }

        private List<List<Node>> sortNodeByLevel(Map<Node, Integer> level) {
            int levels = this.max(level);
            ArrayList<List<Node>> sorted = new ArrayList<List<Node>>();
            for (int i = 0; i < levels; ++i) {
                sorted.add(new ArrayList());
            }
            for (Map.Entry<Node, Integer> entry : level.entrySet()) {
                ((List)sorted.get(entry.getValue())).add(entry.getKey());
            }
            return sorted;
        }

        private int max(Map<Node, Integer> level) {
            int i = 0;
            for (Map.Entry<Node, Integer> l : level.entrySet()) {
                if (l.getValue() < i) continue;
                i = l.getValue() + 1;
            }
            return i;
        }

        private Map<Node, Integer> levels() {
            boolean done;
            HashMap<Node, Integer> out = new HashMap<Node, Integer>();
            for (Node node : this.graph.getVertices()) {
                out.put(node, 0);
            }
            HashMap<Node, Collection> successors = new HashMap<Node, Collection>();
            HashMap<Object, Collection> predecessors = new HashMap<Object, Collection>();
            for (Object node : this.graph.getVertices()) {
                successors.put((Node)node, this.graph.getSuccessors(node));
                predecessors.put(node, this.graph.getPredecessors(node));
            }
            do {
                done = true;
                for (Node node : this.graph.getVertices()) {
                    int nodeLevel = (Integer)out.get(node);
                    for (Node successor : (Collection)successors.get(node)) {
                        if ((Integer)out.get(successor) > nodeLevel || successor == node || ((Collection)predecessors.get(node)).contains(successor)) continue;
                        done = false;
                        out.put(successor, nodeLevel + 1);
                    }
                }
            } while (!done);
            int min = (Integer)Collections.min(out.values());
            for (Map.Entry entry : out.entrySet()) {
                out.put((Node)entry.getKey(), (Integer)entry.getValue() - min);
            }
            return out;
        }
    }

    private static class EdgeLabelRenderer
    extends BasicEdgeLabelRenderer<Node, Edge> {
        private EdgeLabelRenderer() {
        }

        public void labelEdge(RenderContext<Node, Edge> rc, Layout<Node, Edge> layout, Edge e, String label) {
            if (label == null || label.length() == 0) {
                return;
            }
            Graph graph = layout.getGraph();
            Pair endpoints = graph.getEndpoints((Object)e);
            Node v1 = (Node)endpoints.getFirst();
            Node v2 = (Node)endpoints.getSecond();
            if (!rc.getEdgeIncludePredicate().evaluate((Object)Context.getInstance((Object)graph, (Object)e))) {
                return;
            }
            if (!rc.getVertexIncludePredicate().evaluate((Object)Context.getInstance((Object)graph, (Object)v1)) || !rc.getVertexIncludePredicate().evaluate((Object)Context.getInstance((Object)graph, (Object)v2))) {
                return;
            }
            Point2D p1 = rc.getMultiLayerTransformer().transform(Layer.LAYOUT, (Point2D)layout.transform((Object)v1));
            Point2D p2 = rc.getMultiLayerTransformer().transform(Layer.LAYOUT, (Point2D)layout.transform((Object)v2));
            GraphicsDecorator g = rc.getGraphicsContext();
            Component component = this.prepareRenderer(rc, rc.getEdgeLabelRenderer(), label, rc.getPickedEdgeState().isPicked((Object)e), e);
            Dimension d = component.getPreferredSize();
            AffineTransform old = g.getTransform();
            AffineTransform xform = new AffineTransform(old);
            FontMetrics fm = g.getFontMetrics();
            int w = fm.stringWidth(e.text);
            double p = Math.max(0.0, p1.getX() + p2.getX() - (double)w);
            xform.translate(Math.min((double)(layout.getSize().width - w), p / 2.0), (p1.getY() + p2.getY() - (double)fm.getHeight()) / 2.0);
            g.setTransform(xform);
            g.draw(component, rc.getRendererPane(), 0, 0, d.width, d.height, true);
            g.setTransform(old);
        }
    }

    private static class EdgeLabelClosenessTransformer
    implements Transformer<Context<Graph<Node, Edge>, Edge>, Number> {
        private EdgeLabelClosenessTransformer() {
        }

        public Number transform(Context<Graph<Node, Edge>, Edge> context) {
            return 0.5;
        }
    }

    private static class VertexLabelTransformer
    extends ToStringLabeller<Node> {
        private VertexLabelTransformer() {
        }

        public String transform(Node node) {
            return node.text;
        }
    }

    private static class EdgeLabelTransformer
    implements Transformer<Edge, String> {
        private EdgeLabelTransformer() {
        }

        public String transform(Edge i) {
            return i.text;
        }
    }

    private static class VertexFillPaintTransformer
    implements Transformer<Node, Paint> {
        private VertexFillPaintTransformer() {
        }

        public Paint transform(Node node) {
            if (node.root) {
                return Color.GREEN;
            }
            switch (node.type) {
                case SINK: {
                    return Color.RED;
                }
            }
            return Color.WHITE;
        }
    }

    private static class VertexShapeTransformer
    implements Transformer<Node, Shape> {
        private static final int X_MARGIN = 4;
        private static final int Y_MARGIN = 2;
        private FontMetrics metrics;

        public VertexShapeTransformer(FontMetrics f) {
            this.metrics = f;
        }

        public Shape transform(Node i) {
            int w = this.metrics.stringWidth(i.text) + 4;
            int h = this.metrics.getHeight() + 2;
            AffineTransform transform = AffineTransform.getTranslateInstance((double)(-w) / 2.0, (double)(-h) / 2.0);
            switch (i.type) {
                case SINK: {
                    return transform.createTransformedShape(new Ellipse2D.Double(0.0, 0.0, w, h));
                }
            }
            return transform.createTransformedShape(new Rectangle(0, 0, w, h));
        }
    }

    private static class GraphViewer
    extends VisualizationViewer<Node, Edge> {
        private final boolean rotateEdges;

        public GraphViewer(Layout<Node, Edge> nodeEdgeLayout, boolean rotateEdges) {
            super(nodeEdgeLayout);
            this.rotateEdges = rotateEdges;
            this.init();
        }

        private void init() {
            this.setOpaque(true);
            this.setBackground(new Color(255, 255, 255, 0));
            RenderContext context = this.getRenderContext();
            context.setVertexFillPaintTransformer((Transformer)new VertexFillPaintTransformer());
            context.setVertexShapeTransformer((Transformer)new VertexShapeTransformer(this.getFontMetrics(this.getFont())));
            context.setVertexLabelTransformer((Transformer)new VertexLabelTransformer());
            this.getRenderer().getVertexLabelRenderer().setPosition(Renderer.VertexLabel.Position.CNTR);
            context.setEdgeLabelTransformer((Transformer)new EdgeLabelTransformer());
            context.setEdgeShapeTransformer((Transformer)new EdgeShape.Line());
            context.setEdgeLabelClosenessTransformer((Transformer)new EdgeLabelClosenessTransformer());
            context.getEdgeLabelRenderer().setRotateEdgeLabels(this.rotateEdges);
            this.getRenderer().setEdgeLabelRenderer((Renderer.EdgeLabel)new EdgeLabelRenderer());
        }
    }

    private static class Edge {
        private final String text;

        private Edge(String text) {
            this.text = text;
        }
    }

    private static class Node {
        private final String text;
        private final Type type;
        private boolean root = false;

        private Node(String text, Type type) {
            this.text = text;
            this.type = type;
        }

        public void root() {
            this.root = true;
        }

        public static enum Type {
            STEP,
            SINK;

        }
    }

    private static class Diagram
    extends DirectedSparseGraph<Node, Edge> {
        private final String name;

        private Diagram(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }
    }
}

