/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batchee.jsefa;

import java.io.File;
import java.io.Serializable;
import java.io.Writer;
import java.util.List;
import javax.batch.api.BatchProperty;
import javax.batch.api.chunk.ItemWriter;
import javax.batch.operations.BatchRuntimeException;
import javax.inject.Inject;
import org.apache.batchee.extras.transaction.TransactionalWriter;
import org.jsefa.Serializer;

public abstract class JSefaWriter
implements ItemWriter {
    @Inject
    @BatchProperty
    protected String objectTypes;
    @Inject
    @BatchProperty
    protected String validationMode;
    @Inject
    @BatchProperty
    protected String objectAccessorProvider;
    @Inject
    @BatchProperty
    protected String validationProvider;
    @Inject
    @BatchProperty
    protected String simpleTypeProvider;
    @Inject
    @BatchProperty
    protected String typeMappingRegistry;
    @Inject
    @BatchProperty
    protected String file;
    @Inject
    @BatchProperty
    protected String encoding;
    protected Serializer serializer;
    protected TransactionalWriter transactionalWriter;

    public void open(Serializable checkpoint) throws Exception {
        File f = new File(this.file);
        if (!f.getParentFile().exists() && !f.getParentFile().mkdirs()) {
            throw new BatchRuntimeException(f.getParentFile().getAbsolutePath());
        }
        this.serializer = this.createSerializer();
        this.transactionalWriter = new TransactionalWriter(f, this.encoding, checkpoint);
        this.serializer.open((Writer)this.transactionalWriter);
    }

    protected abstract Serializer createSerializer() throws Exception;

    public void close() throws Exception {
        if (this.serializer != null) {
            this.serializer.close(true);
        }
    }

    public void writeItems(List<Object> items) throws Exception {
        for (Object item : items) {
            this.serializer.write(item);
        }
        this.transactionalWriter.flush();
    }

    public Serializable checkpointInfo() throws Exception {
        return Long.valueOf(this.transactionalWriter.position());
    }
}

