/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batchee.container.cdi;

import java.io.File;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.URI;
import java.net.URL;
import java.util.Date;
import java.util.Properties;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.batch.api.BatchProperty;
import javax.batch.runtime.context.JobContext;
import javax.batch.runtime.context.StepContext;
import javax.enterprise.inject.Produces;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.management.ObjectName;
import org.apache.batchee.container.proxy.ProxyFactory;
import org.apache.batchee.container.util.DependencyInjections;

public class BatchProducerBean {
    private static final int[] EMPTY_INTS = new int[0];
    private static final double[] EMPTY_DOUBLES = new double[0];
    private static final String[] EMPTY_STRINGS = new String[0];

    @Produces
    public JobContext getJobContext() {
        if (ProxyFactory.getInjectionReferences() != null) {
            return ProxyFactory.getInjectionReferences().getJobContext();
        }
        return null;
    }

    @Produces
    public StepContext getStepContext() {
        if (ProxyFactory.getInjectionReferences() != null) {
            return ProxyFactory.getInjectionReferences().getStepContext();
        }
        return null;
    }

    @Produces
    @BatchProperty
    public String produceProperty(InjectionPoint injectionPoint) {
        if (injectionPoint != null && ProxyFactory.getInjectionReferences() != null) {
            BatchProperty batchPropAnnotation = (BatchProperty)injectionPoint.getAnnotated().getAnnotation(BatchProperty.class);
            String batchPropName = batchPropAnnotation.name().equals("") ? injectionPoint.getMember().getName() : batchPropAnnotation.name();
            return DependencyInjections.getPropertyValue(ProxyFactory.getInjectionReferences().getProps(), batchPropName);
        }
        return null;
    }

    @Produces
    @BatchProperty
    public Integer produceIntProperty(InjectionPoint injectionPoint) {
        String v = this.produceProperty(injectionPoint);
        if (v != null) {
            return DependencyInjections.convertTo(v, Integer.class, Integer.class);
        }
        return 0;
    }

    @Produces
    @BatchProperty
    public Double produceDoubleProperty(InjectionPoint injectionPoint) {
        String v = this.produceProperty(injectionPoint);
        if (v != null) {
            return DependencyInjections.convertTo(v, Double.class, Double.class);
        }
        return 0.0;
    }

    @Produces
    @BatchProperty
    public Float produceFloatProperty(InjectionPoint injectionPoint) {
        String v = this.produceProperty(injectionPoint);
        if (v != null) {
            return DependencyInjections.convertTo(v, Float.class, Float.class);
        }
        return Float.valueOf(0.0f);
    }

    @Produces
    @BatchProperty
    public Short produceShortProperty(InjectionPoint injectionPoint) {
        String v = this.produceProperty(injectionPoint);
        if (v != null) {
            return DependencyInjections.convertTo(v, Short.class, Short.class);
        }
        return (short)0;
    }

    @Produces
    @BatchProperty
    public Boolean produceBooleanProperty(InjectionPoint injectionPoint) {
        String v = this.produceProperty(injectionPoint);
        if (v != null) {
            return DependencyInjections.convertTo(v, Boolean.class, Boolean.class);
        }
        return false;
    }

    @Produces
    @BatchProperty
    public Long produceLongProperty(InjectionPoint injectionPoint) {
        String v = this.produceProperty(injectionPoint);
        if (v != null) {
            return DependencyInjections.convertTo(v, Long.class, Long.class);
        }
        return 0L;
    }

    @Produces
    @BatchProperty
    public Byte produceByteProperty(InjectionPoint injectionPoint) {
        String v = this.produceProperty(injectionPoint);
        if (v != null) {
            return DependencyInjections.convertTo(v, Byte.class, Byte.class);
        }
        return (byte)0;
    }

    @Produces
    @BatchProperty
    public Character produceCharProperty(InjectionPoint injectionPoint) {
        String v = this.produceProperty(injectionPoint);
        if (v != null) {
            return DependencyInjections.convertTo(v, Character.class, Character.class);
        }
        return Character.valueOf('\u0000');
    }

    @Produces
    @BatchProperty
    public int[] produceIntArrayProperty(InjectionPoint injectionPoint) {
        String v = this.produceProperty(injectionPoint);
        if (v != null) {
            return (int[])DependencyInjections.convertTo(v, EMPTY_INTS.getClass(), null);
        }
        return EMPTY_INTS;
    }

    @Produces
    @BatchProperty
    public double[] produceDoubleArrayProperty(InjectionPoint injectionPoint) {
        String v = this.produceProperty(injectionPoint);
        if (v != null) {
            return (double[])DependencyInjections.convertTo(v, EMPTY_DOUBLES.getClass(), null);
        }
        return EMPTY_DOUBLES;
    }

    @Produces
    @BatchProperty
    public String[] produceStringArrayProperty(InjectionPoint injectionPoint) {
        String v = this.produceProperty(injectionPoint);
        if (v != null) {
            return (String[])DependencyInjections.convertTo(v, EMPTY_STRINGS.getClass(), null);
        }
        return EMPTY_STRINGS;
    }

    @Produces
    @BatchProperty
    public Date produceDateProperty(InjectionPoint injectionPoint) {
        String v = this.produceProperty(injectionPoint);
        if (v != null) {
            return DependencyInjections.convertTo(v, Date.class, Date.class);
        }
        return null;
    }

    @Produces
    @BatchProperty
    public Inet4Address produceIp4Property(InjectionPoint injectionPoint) {
        String v = this.produceProperty(injectionPoint);
        if (v != null) {
            return DependencyInjections.convertTo(v, Inet4Address.class, Inet4Address.class);
        }
        return null;
    }

    @Produces
    @BatchProperty
    public Inet6Address produceIp6Property(InjectionPoint injectionPoint) {
        String v = this.produceProperty(injectionPoint);
        if (v != null) {
            return DependencyInjections.convertTo(v, Inet6Address.class, Inet6Address.class);
        }
        return null;
    }

    @Produces
    @BatchProperty
    public URI produceUriProperty(InjectionPoint injectionPoint) {
        String v = this.produceProperty(injectionPoint);
        if (v != null) {
            return DependencyInjections.convertTo(v, URI.class, URI.class);
        }
        return null;
    }

    @Produces
    @BatchProperty
    public URL produceUrlProperty(InjectionPoint injectionPoint) {
        String v = this.produceProperty(injectionPoint);
        if (v != null) {
            return DependencyInjections.convertTo(v, URL.class, URL.class);
        }
        return null;
    }

    @Produces
    @BatchProperty
    public Logger produceLoggerProperty(InjectionPoint injectionPoint) {
        String v = this.produceProperty(injectionPoint);
        if (v != null) {
            return DependencyInjections.convertTo(v, Logger.class, Logger.class);
        }
        return null;
    }

    @Produces
    @BatchProperty
    public Properties producePropertiesProperty(InjectionPoint injectionPoint) {
        String v = this.produceProperty(injectionPoint);
        if (v != null) {
            return DependencyInjections.convertTo(v, Properties.class, Properties.class);
        }
        return null;
    }

    @Produces
    @BatchProperty
    public Class produceClassProperty(InjectionPoint injectionPoint) {
        String v = this.produceProperty(injectionPoint);
        if (v != null) {
            return DependencyInjections.convertTo(v, Class.class, Class.class);
        }
        return null;
    }

    @Produces
    @BatchProperty
    public Pattern producePatternProperty(InjectionPoint injectionPoint) {
        String v = this.produceProperty(injectionPoint);
        if (v != null) {
            return DependencyInjections.convertTo(v, Pattern.class, Pattern.class);
        }
        return null;
    }

    @Produces
    @BatchProperty
    public ObjectName produceObjectNameProperty(InjectionPoint injectionPoint) {
        String v = this.produceProperty(injectionPoint);
        if (v != null) {
            return DependencyInjections.convertTo(v, ObjectName.class, ObjectName.class);
        }
        return null;
    }

    @Produces
    @BatchProperty
    public File produceFileProperty(InjectionPoint injectionPoint) {
        String v = this.produceProperty(injectionPoint);
        if (v != null) {
            return DependencyInjections.convertTo(v, File.class, File.class);
        }
        return null;
    }
}

